/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.workbench.shell.BNiagaraWbDialog;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.web.browser.BrowserUtil;
import java.util.ArrayList;
import javax.baja.file.BMemoryFileStore;
import javax.baja.file.BSubSpaceFile;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;

@NiagaraType
public class BSaveAllDialog
extends BDialog {
    @Generated
    public static final Type TYPE = Sys.loadType(BSaveAllDialog.class);
    public static final int NONE = 0;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    UiLexicon lex = UiLexicon.bajaui();
    BCheckList list;
    boolean ok;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static int saveAll(BWidget owner, String title) {
        return BSaveAllDialog.saveAll(owner, title, (BOrd)null);
    }

    public static int saveAll(BWidget owner, String title, BOrd prefix) {
        if (!BSaveAllDialog.confirmBrowserBeforeUnload(null)) {
            return 2;
        }
        ArrayList<Saveable> acc = new ArrayList<Saveable>();
        BSaveAllDialog.accShells(acc, prefix);
        BSaveAllDialog.accBogs(acc, prefix);
        Saveable[] saveables = acc.toArray(new Saveable[0]);
        if (saveables.length == 0) {
            return 0;
        }
        BSaveAllDialog dialog = new BSaveAllDialog(owner, title, saveables);
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        return dialog.ok ? 1 : 2;
    }

    public static int saveAll(BWidget owner, String title, BOrd[] prefixes) {
        if (!BSaveAllDialog.confirmBrowserBeforeUnload(null)) {
            return 2;
        }
        ArrayList<Saveable> acc = new ArrayList<Saveable>();
        for (int i = 0; i < prefixes.length; ++i) {
            BSaveAllDialog.accShells(acc, prefixes[i]);
            BSaveAllDialog.accBogs(acc, prefixes[i]);
        }
        Saveable[] saveables = acc.toArray(new Saveable[0]);
        if (saveables.length == 0) {
            return 0;
        }
        BSaveAllDialog dialog = new BSaveAllDialog(owner, title, saveables);
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        return dialog.ok ? 1 : 2;
    }

    public static int saveTabs(BNiagaraWbShell shell, String title) {
        if (!BSaveAllDialog.confirmBrowserBeforeUnload(shell)) {
            return 2;
        }
        ArrayList<Saveable> acc = new ArrayList<Saveable>();
        BSaveAllDialog.accTabs(acc, shell, null);
        Saveable[] saveables = acc.toArray(new Saveable[0]);
        if (saveables.length == 0) {
            return 0;
        }
        BSaveAllDialog dialog = new BSaveAllDialog((BWidget)shell, title, saveables);
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        return dialog.ok ? 1 : 2;
    }

    static void accShells(ArrayList<Saveable> acc, BOrd prefix) {
        BWidgetShell[] shells = BWidget.getApplication().getShells();
        for (int i = 0; i < shells.length; ++i) {
            if (!(shells[i] instanceof BNiagaraWbShell) || shells[i] instanceof BNiagaraWbDialog) continue;
            BSaveAllDialog.accTabs(acc, (BNiagaraWbShell)shells[i], prefix);
        }
    }

    static void accTabs(ArrayList<Saveable> acc, BNiagaraWbShell shell, BOrd prefix) {
        BViewTab[] tabs = shell.pane.views.getModifiedTabs();
        for (int i = 0; i < tabs.length; ++i) {
            BViewTab tab = tabs[i];
            if (!BSaveAllDialog.isPrefixMatch(prefix, tab.ord)) continue;
            acc.add(new TabSaveable(tabs[i]));
        }
        BNiagaraWbDialog[] dlgShells = BNiagaraWbDialog.getDialogsForOwner(shell);
        for (int i = 0; i < dlgShells.length; ++i) {
            BSaveAllDialog.accTabs(acc, dlgShells[i], null);
        }
    }

    static void accBogs(ArrayList<Saveable> acc, BOrd prefix) {
        BSubSpaceFile[] files = BSubSpaceFile.listOpen();
        for (int i = 0; i < files.length; ++i) {
            BSubSpaceFile file = files[i];
            if (!file.isModified() || file.isReadonly() || file.getStore() instanceof BMemoryFileStore || !BSaveAllDialog.isPrefixMatch(prefix, file.getAbsoluteOrd())) continue;
            acc.add(new SubSpaceSaveable(files[i]));
        }
    }

    static boolean isPrefixMatch(BOrd prefix, BOrd ord) {
        if (prefix == null || ord == null) {
            return true;
        }
        String sPrefix = TextUtil.toLowerCase((String)prefix.toString());
        if (sPrefix.endsWith("fox:") || sPrefix.endsWith("foxs:")) {
            sPrefix = sPrefix + "|";
        }
        String sOrd = TextUtil.toLowerCase((String)ord.toString());
        return sOrd.startsWith(sPrefix);
    }

    static boolean confirmBrowserBeforeUnload(BWidgetShell currentShell) {
        BWidgetShell[] shells = currentShell != null ? new BWidgetShell[]{currentShell} : BWidget.getApplication().getShells();
        for (BWidgetShell shell : shells) {
            BViewTab[] tabs;
            if (!(shell instanceof BNiagaraWbShell) || shell instanceof BNiagaraWbDialog) continue;
            for (BViewTab tab : tabs = ((BNiagaraWbShell)shell).pane.views.getTabs()) {
                if (!BrowserUtil.hasBeforeUnload(tab.view)) continue;
                return BrowserUtil.confirmBeforeUnload(tab.view);
            }
        }
        return true;
    }

    public BSaveAllDialog() {
        throw new IllegalStateException();
    }

    public BSaveAllDialog(BWidget owner, String title, Saveable[] saveables) {
        super(owner, title, true);
        this.list = new BCheckList();
        for (int i = 0; i < saveables.length; ++i) {
            this.list.addItem((Object)saveables[i]);
        }
        this.list.getSelection().selectAll();
        BGridPane buttons = new BGridPane(3);
        buttons.setColumnAlign(BHalign.fill);
        buttons.setUniformColumnWidth(true);
        buttons.add(null, (BValue)new BButton((Command)new ReflectCommand((BWidget)this, this.lex.getText("saveChecked"), "ok")));
        buttons.add(null, (BValue)new BButton((Command)new SaveNoneCommand(this, this.lex.getText("saveNone"))));
        buttons.add(null, (BValue)new BButton((Command)new ReflectCommand((BWidget)this, this.lex.getText("dialog.cancel"), "cancel")));
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this.list, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0))));
        edge.setBottom((BWidget)new BBorderPane((BWidget)buttons));
        this.setContent((BWidget)edge);
    }

    public void computePreferredSize() {
        this.setPreferredSize(500.0, 160.0);
    }

    public void ok() {
        Object[] toSave = this.list.getSelectedItems();
        for (int i = 0; i < toSave.length; ++i) {
            Saveable saveable = (Saveable)toSave[i];
            try {
                if (saveable.save()) continue;
                return;
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (String)("Cannot save: " + saveable.toString()), (Object)e);
                return;
            }
        }
        this.ok = true;
        this.getOwner().repaint();
        this.close();
    }

    public void cancel() {
        this.close();
    }

    public void windowClosing(BWindowEvent event) {
        this.cancel();
    }

    public static class SubSpaceSaveable
    implements Saveable {
        BSubSpaceFile file;
        String string;

        public SubSpaceSaveable(BSubSpaceFile file) {
            this.file = file;
            this.string = String.valueOf(file.getAbsoluteOrd());
        }

        @Override
        public String toString() {
            return this.string;
        }

        @Override
        public boolean save() throws Exception {
            this.file.save();
            return true;
        }
    }

    public static class TabSaveable
    implements Saveable {
        BViewTab tab;
        String string;

        public TabSaveable(BViewTab tab) {
            this.tab = tab;
            this.string = String.valueOf(tab.ord);
        }

        @Override
        public String toString() {
            return this.string;
        }

        @Override
        public boolean save() {
            this.tab.shell.save(this.tab.view);
            return !this.tab.view.isModified();
        }
    }

    public static interface Saveable {
        public String toString();

        public boolean save() throws Exception;
    }

    class SaveNoneCommand
    extends Command {
        private BSaveAllDialog dlg;

        public SaveNoneCommand(BSaveAllDialog dlg, String text) {
            super((BWidget)dlg, text);
            this.dlg = dlg;
        }

        public CommandArtifact doInvoke() {
            this.dlg.list.getSelection().deselectAll();
            new ReflectCommand((BWidget)this.dlg, "", "ok").invoke();
            return null;
        }
    }
}

