/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.sys.Nre;
import com.tridium.workbench.shell.BWbApplication;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.options.BUserOptions;
import javax.baja.ui.options.OptionsManager;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;

public class WbOptionsManager
extends Thread
implements OptionsManager {
    private volatile boolean stopRequested = false;
    static final Logger log = Logger.getLogger("sys.options");
    private final BWbApplication app;
    private final HashMap<String, BOptions> keyToOptions = new HashMap();
    private final HashMap<BOptions, String> optionsToKey = new HashMap();
    private final HashMap<String, BOptions> toSave = new HashMap();

    WbOptionsManager(BWbApplication app) {
        super(Nre.mainThreadGroup, "Ui:OptionsManager");
        this.setDaemon(true);
        this.app = app;
        this.start();
    }

    public BOptions[] getLoaded() {
        return this.keyToOptions.values().toArray(new BOptions[0]);
    }

    public String toKey(BOptions options) {
        String key = this.optionsToKey.get(options);
        if (key == null) {
            throw new IllegalStateException("Options not loaded " + options.getType());
        }
        return key;
    }

    public BOptions load(TypeInfo typeInfo) {
        return this.load(typeInfo.getTypeSpec().getResolvedType());
    }

    public BOptions load(Type type) {
        return this.load(type.toString(), type);
    }

    public synchronized BOptions load(String key, Type type) {
        if (type.is(BUserOptions.TYPE) && !key.equals(type.toString())) {
            throw new IllegalArgumentException("Key must be type.toString() for UserOptions: " + type);
        }
        BOptions options = this.keyToOptions.get(key);
        if (options == null) {
            try {
                options = AccessController.doPrivileged(() -> {
                    File file = WbOptionsManager.keyToFile(key);
                    if (file.exists()) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Load \"" + key + "\" from " + file.getName());
                        }
                        try (ValueDocDecoder decoder = new ValueDocDecoder(file);){
                            BOptions decodedOptions = (BOptions)decoder.decodeDocument();
                            decodedOptions.loaded();
                            BOptions bOptions = decodedOptions;
                            return bOptions;
                        }
                    }
                    return null;
                });
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Cannot load options \"" + key + "\": " + e);
            }
            if (options == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Load \"" + key + "\" new");
                }
                options = (BOptions)type.getInstance();
            }
            this.keyToOptions.put(key, options);
            this.optionsToKey.put(options, key);
        }
        try {
            options.loaded();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Options  \"" + key + "\" partially loaded. loaded() callback failed: " + e);
        }
        return options;
    }

    public void save(BOptions options) {
        this.saveAsync(options);
    }

    public void saveAll() {
        BOptions[] o = this.getLoaded();
        for (int i = 0; i < o.length; ++i) {
            this.saveSync(o[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsync(BOptions options) {
        HashMap<String, BOptions> hashMap = this.toSave;
        synchronized (hashMap) {
            this.toSave.put(options.getName(), options);
        }
    }

    public void saveSync(BOptions options) {
        AccessController.doPrivileged(new SaveSyncPrivilegedAction(options));
    }

    public static File keyToFile(String key) {
        File dir = new File(Sys.getNiagaraUserHome(), "etc" + File.separator + "options");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        key = key.replace(':', '-');
        return new File(dir, key + ".options");
    }

    public static TypeInfo[] getAllUserOptions(BWbShell shell) {
        Array types = new Array((Object[])Sys.getRegistry().getConcreteTypes(BUserOptions.TYPE.getTypeInfo()));
        BWbProfile profile = shell.getProfile();
        for (int i = types.size() - 1; i >= 0; --i) {
            if (profile.hasUserOptions((TypeInfo)types.get(i))) continue;
            types.remove(i);
        }
        types.sort((Comparator)new Comparator<TypeInfo>(){

            @Override
            public int compare(TypeInfo a, TypeInfo b) {
                TypeInfo x = a;
                TypeInfo y = b;
                return x.getDisplayName(null).compareTo(y.getDisplayName(null));
            }
        });
        int general = -1;
        for (int i = 0; i < types.size(); ++i) {
            if (!((TypeInfo)types.get(i)).toString().equals("workbench:GeneralOptions")) continue;
            general = i;
            break;
        }
        if (general != -1) {
            TypeInfo x = (TypeInfo)types.remove(general);
            types.add(0, (Object)x);
        }
        return (TypeInfo[])types.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopRequested) {
            try {
                BOptions[] options;
                Thread.sleep(5000L);
                HashMap<String, BOptions> hashMap = this.toSave;
                synchronized (hashMap) {
                    if (this.toSave.size() == 0) {
                        continue;
                    }
                    options = this.toSave.values().toArray(new BOptions[0]);
                    this.toSave.clear();
                }
                for (int i = 0; i < options.length; ++i) {
                    this.saveSync(options[i]);
                }
            }
            catch (Throwable e) {
                if (this.stopRequested) continue;
                e.printStackTrace();
            }
        }
    }

    public void stopRequest() {
        this.stopRequested = true;
        this.interrupt();
    }

    private class SaveSyncPrivilegedAction
    implements PrivilegedAction<Void> {
        private BOptions options;

        private SaveSyncPrivilegedAction(BOptions options) {
            this.options = options;
        }

        @Override
        public Void run() {
            try {
                String key = WbOptionsManager.this.toKey(this.options);
                File file = WbOptionsManager.keyToFile(key);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Save \"" + key + "\" to " + file.getName());
                }
                try (ValueDocEncoder encoder = new ValueDocEncoder(file);){
                    encoder.encodeDocument((BValue)this.options);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Cannot save options", e);
            }
            return null;
        }
    }
}

