/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.sidebars;

import java.util.Arrays;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;

@NiagaraType
public class BNavReorderPad
extends BEdgePane {
    @Generated
    public static final Type TYPE = Sys.loadType(BNavReorderPad.class);
    Row[] oldOrder;
    Row[] newOrder;
    BINavNode target;
    BTable table;
    Model model;
    BButton up;
    BButton down;
    BButton byName;
    BButton reset;
    boolean byNameAscending;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNavReorderPad() {
        this((BINavNode)BNavRoot.INSTANCE);
    }

    public BNavReorderPad(BINavNode target) {
        this.target = target;
        this.oldOrder = (Row[])Arrays.stream(target.getNavChildren()).map(Row::new).toArray(Row[]::new);
        this.newOrder = new Row[this.oldOrder.length];
        System.arraycopy(this.oldOrder, 0, this.newOrder, 0, this.newOrder.length);
        this.model = new Model();
        this.table = new BTable((TableModel)this.model);
        this.table.setHeaderVisible(false);
        this.table.setMultipleSelection(true);
        this.table.setHgridVisible(false);
        BGridPane buttons = new BGridPane(1);
        buttons.setValign(BValign.top);
        buttons.setColumnAlign(BHalign.fill);
        this.up = BNavReorderPad.newButton(new UpCommand((BWidget)this));
        buttons.add("up", (BValue)this.up);
        this.down = BNavReorderPad.newButton(new DownCommand((BWidget)this));
        buttons.add("down", (BValue)this.down);
        this.byName = BNavReorderPad.newButton(new ByNameCommand((BWidget)this));
        buttons.add("byName", (BValue)this.byName);
        this.reset = BNavReorderPad.newButton(new ResetCommand((BWidget)this));
        buttons.add("reset", (BValue)this.reset);
        if (this.oldOrder.length == 0) {
            this.up.setEnabled(false);
            this.down.setEnabled(false);
            this.byName.setEnabled(false);
            this.reset.setEnabled(false);
        } else {
            this.table.getSelection().select(0);
        }
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        edge.setRight((BWidget)new BBorderPane((BWidget)buttons, 0.0, 0.0, 0.0, 10.0));
        this.setCenter((BWidget)new BBorderPane((BWidget)edge));
    }

    void up() {
        int[] rows = this.table.getSelection().getRows();
        if (rows.length == 0) {
            return;
        }
        this.table.getSelection().deselectAll();
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] == i) {
                this.table.getSelection().select(rows[i]);
                this.table.ensureRowIsVisible(rows[i]);
                continue;
            }
            this.swap(rows[i], rows[i] - 1);
            this.table.getSelection().select(rows[i] - 1);
            this.table.ensureRowIsVisible(rows[i] - 1);
        }
        this.table.repaint();
    }

    void down() {
        int[] rows = this.table.getSelection().getRows();
        if (rows.length == 0) {
            return;
        }
        this.table.getSelection().deselectAll();
        int n = this.newOrder.length - 1;
        for (int i = 0; i < rows.length; ++i) {
            int r = rows.length - 1 - i;
            if (rows[r] == n - i) {
                this.table.getSelection().select(rows[r]);
                this.table.ensureRowIsVisible(rows[r]);
                continue;
            }
            this.swap(rows[r], rows[r] + 1);
            this.table.getSelection().select(rows[r] + 1);
            this.table.ensureRowIsVisible(rows[r] + 1);
        }
        this.table.repaint();
    }

    private void sortByName() {
        Object[] keys = new String[this.newOrder.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.newOrder[i].getName();
        }
        this.byNameAscending = !this.byNameAscending;
        SortUtil.sort((Object[])keys, (Object[])this.newOrder, (boolean)this.byNameAscending);
        this.reset(false);
    }

    private void reset(boolean backToOld) {
        if (backToOld) {
            System.arraycopy(this.oldOrder, 0, this.newOrder, 0, this.oldOrder.length);
        }
        this.table.getSelection().deselectAll();
        this.table.getSelection().select(0);
        this.table.ensureRowIsVisible(0);
        this.table.repaint();
    }

    static BButton newButton(Command cmd) {
        BButton b = new BButton(cmd, true, true);
        b.setHalign(BHalign.left);
        return b;
    }

    int swap(int i1, int i2) {
        Row temp = this.newOrder[i1];
        this.newOrder[i1] = this.newOrder[i2];
        this.newOrder[i2] = temp;
        return i2;
    }

    public BINavNode[] newOrder() {
        BINavNode[] p = new BINavNode[this.newOrder.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = this.newOrder[i].node;
        }
        return p;
    }

    public BINavNode[] oldOrder() {
        BINavNode[] p = new BINavNode[this.oldOrder.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = this.oldOrder[i].node;
        }
        return p;
    }

    public class ResetCommand
    extends Command {
        ResetCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "reorder.reset");
        }

        public CommandArtifact doInvoke() {
            BNavReorderPad.this.reset(true);
            return null;
        }
    }

    public class ByNameCommand
    extends Command {
        public ByNameCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "reorder.byName");
        }

        public CommandArtifact doInvoke() {
            BNavReorderPad.this.sortByName();
            return null;
        }
    }

    public class DownCommand
    extends Command {
        public DownCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "reorder.down");
        }

        public CommandArtifact doInvoke() {
            BNavReorderPad.this.down();
            return null;
        }
    }

    public class UpCommand
    extends Command {
        public UpCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "reorder.up");
        }

        public CommandArtifact doInvoke() {
            BNavReorderPad.this.up();
            return null;
        }
    }

    static class Row {
        BINavNode node;

        Row(BINavNode node) {
            this.node = node;
        }

        String getName() {
            return this.node.getNavDisplayName(null);
        }

        BIcon getIcon() {
            return this.node.getNavIcon();
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BNavReorderPad.this.newOrder.length;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int col) {
            return "";
        }

        public Object getValueAt(int row, int col) {
            return BNavReorderPad.this.newOrder[row].getName();
        }

        public Object getSubject(int row) {
            return BNavReorderPad.this.newOrder[row];
        }

        public BImage getRowIcon(int row) {
            return BImage.make((BIcon)BNavReorderPad.this.newOrder[row].getIcon());
        }
    }
}

