/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.synthetic;

import java.io.IOException;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.table.TableSubject;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.BWbPlugin;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class SyntheticModuleDependenciesTab {
    private BAbstractButton editButton;
    private BTable table;
    private BWidget content;
    private XElem root;
    private BWbPlugin parent;

    public SyntheticModuleDependenciesTab(BWbPlugin parent) {
        this.parent = parent;
        BBorderPane borderPane = new BBorderPane();
        borderPane.setPadding(BInsets.make((double)10.0, (double)10.0, (double)10.0, (double)10.0));
        BEdgePane edgePane = new BEdgePane();
        this.table = new BTable((TableModel)new Model());
        this.table.setController((TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        edgePane.setCenter((BWidget)this.table);
        BBorderPane buttonBorder = new BBorderPane();
        buttonBorder.setPadding(BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)0.0));
        edgePane.setBottom((BWidget)buttonBorder);
        BGridPane buttonGrid = new BGridPane(4);
        buttonGrid.setColumnGap(20.0);
        this.editButton = BButton.make((Command)new EditCommand(parent));
        buttonGrid.add(null, (BValue)this.editButton);
        buttonBorder.setContent((BWidget)buttonGrid);
        borderPane.setContent((BWidget)edgePane);
        this.content = borderPane;
    }

    public void loadValue(XElem root, Context cx) {
        this.root = root;
        this.table.sizeColumnsToFit();
    }

    public void saveValue(Context cx) {
    }

    public BWidget getContent() {
        return this.content;
    }

    public void updateDependencies() {
        int i;
        if (this.root.elem("types") == null) {
            return;
        }
        XElem[] types = this.root.elem("types").elems("type");
        ArrayList<Object> dependsOn = new ArrayList<Object>();
        TypeInfo[] regTypes = Sys.getRegistry().getTypes();
        dependsOn.add(Sys.getBajaModule().getModuleInfo(RuntimeProfile.rt));
        for (i = 0; i < types.length; ++i) {
            String extendsClass = types[i].get("extends");
            for (TypeInfo ti : regTypes) {
                if (!ti.getTypeClassName().equals(extendsClass)) continue;
                dependsOn.add(Sys.getRegistry().getModule(ti.getModuleName(), ti.getRuntimeProfile()).getModulePartName());
                break;
            }
            if (types[i].elem("slots") == null) continue;
            XElem[] properties = types[i].elem("slots").elems("property");
            for (int j = 0; j < properties.length; ++j) {
                try {
                    BTypeSpec spec = BTypeSpec.make((String)properties[j].get("type", BTypeSpec.NULL.encodeToString()));
                    dependsOn.add(Sys.getRegistry().getModule(spec.getModuleName(), spec.getResolvedType().getRuntimeProfile()));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        for (int j = 0; j < this.root.elem("dependencies").elems("dependency").length; ++j) {
            boolean delete = true;
            for (int k = 0; k < dependsOn.size(); ++k) {
                if (!((ModuleInfo)dependsOn.get(k)).getModulePartName().equals(this.root.elem("dependencies").elems("dependency")[j].get("name"))) continue;
                delete = false;
            }
            if (!delete) continue;
            this.root.elem("dependencies").removeContent(j--);
        }
        for (i = 0; i < dependsOn.size(); ++i) {
            ModuleInfo modelInfo = (ModuleInfo)dependsOn.get(i);
            if (modelInfo.getModulePartName().equals(this.root.get("name"))) continue;
            this.addDependency(modelInfo);
        }
        this.table.getModel().updateTable(true);
        this.table.repaint();
    }

    private void addDependency(ModuleInfo info) {
        XElem[] dependencies = this.root.elem("dependencies").elems("dependency");
        for (int j = 0; j < dependencies.length; ++j) {
            if (!dependencies[j].get("name", "").equals(info.getModulePartName())) continue;
            return;
        }
        XElem slotElem = new XElem("dependency");
        slotElem.addAttr("name", info.getModulePartName());
        slotElem.addAttr("vendor", info.getVendor());
        slotElem.addAttr("vendorVersion", info.getVendorVersion().toString());
        this.root.elem("dependencies").addContent((XContent)slotElem);
    }

    private class Model
    extends TableModel {
        private Model() {
        }

        public int getRowCount() {
            try {
                return SyntheticModuleDependenciesTab.this.root.elem("dependencies").elems("dependency").length;
            }
            catch (Exception e) {
                return 0;
            }
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Module";
            }
            if (col == 1) {
                return "Vendor";
            }
            if (col == 2) {
                return "Version";
            }
            return "???";
        }

        public Object getSubject(int row) {
            return SyntheticModuleDependenciesTab.this.root.elem("dependencies").elems("dependency")[row];
        }

        public Object getValueAt(int row, int col) {
            XElem dep = SyntheticModuleDependenciesTab.this.root.elem("dependencies").elems("dependency")[row];
            switch (col) {
                case 0: {
                    return dep.get("name");
                }
                case 1: {
                    return dep.get("vendor");
                }
                case 2: {
                    return dep.get("vendorVersion");
                }
            }
            return "???";
        }

        public BImage getRowIcon(int row) {
            return BImage.make((BIcon)BIcon.std((String)"module.png"));
        }

        public boolean isColumnSortable(int col) {
            return false;
        }
    }

    private class Selection
    extends TableSelection {
        private Selection() {
        }

        private void updateButtons() {
            boolean isEmpty = this.isEmpty();
            SyntheticModuleDependenciesTab.this.editButton.setEnabled(!isEmpty);
        }

        public void deselect(int row) {
            super.deselect(row);
            this.updateButtons();
        }

        public void deselectAll() {
            super.deselectAll();
            this.updateButtons();
        }

        public void select(int row, boolean clear) {
            super.select(row, clear);
            this.updateButtons();
        }

        public void select(int anchor, int lead, boolean clear) {
            super.select(anchor, lead, clear);
            this.updateButtons();
        }

        public void select(int anchor, int lead) {
            super.select(anchor, lead);
            this.updateButtons();
        }

        public void select(int row) {
            super.select(row);
            this.updateButtons();
        }

        public void select(int[] rows) {
            super.select(rows);
            this.updateButtons();
        }

        public void selectAll() {
            super.selectAll();
            this.updateButtons();
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        public int getTextSearchColumn() {
            return 0;
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            this.getTable().getSelection().select(row, true);
            try {
                SyntheticModuleDependenciesTab.this.editButton.getCommand().doInvoke();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected BMenu makePopup(TableSubject subject) {
            BMenu menu = new BMenu();
            if (subject.getRows().length > 0) {
                menu.add("edit", SyntheticModuleDependenciesTab.this.editButton.getCommand());
            }
            return menu;
        }
    }

    private class EditCommand
    extends Command {
        public EditCommand(BWidget owner) {
            super(owner, "Edit Version");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"edit.png"));
        }

        public CommandArtifact doInvoke() throws Exception {
            XElem dependency = SyntheticModuleDependenciesTab.this.root.elem("dependencies").elem(SyntheticModuleDependenciesTab.this.table.getSelection().getRow());
            BGridPane gridPane = new BGridPane(2);
            gridPane.setHalign(BHalign.left);
            BTextField version = new BTextField("", 25);
            version.setText(dependency.get("vendorVersion"));
            gridPane.add(null, (BValue)new BLabel("Version"));
            gridPane.add(null, (BValue)version);
            String title = "Edit Dependency";
            int buttons = 3;
            if (BDialog.open((BWidget)this.getOwner(), (String)title, (Object)gridPane, (int)buttons, null) == 2) {
                return null;
            }
            dependency.setAttr("vendor", Sys.getRegistry().moduleForDependency(dependency.get("name")).getVendor());
            dependency.setAttr("vendorVersion", version.getText());
            SyntheticModuleDependenciesTab.this.table.getModel().updateTable();
            SyntheticModuleDependenciesTab.this.parent.setModified();
            return null;
        }
    }
}

