/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.export.impl.destination.BLaunchExternalApplicationDestinationType;
import com.tridium.net.BHttpObject;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.shell.BNiagaraWbWebShell;
import java.io.File;
import java.security.AccessController;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.types.application.BApplicationFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"file:ApplicationFile", "net:HttpObject"}, requiredPermissions="r")})
public class BGenericAppFileView
extends BWbView {
    @Generated
    public static final Type TYPE = Sys.loadType(BGenericAppFileView.class);
    private static final char[] INVALID_CHARACTERS = new char[]{'{', '}', '(', ')', '<', '>', '&', '*', '\u2018', '|', '=', '?', ';', '$', '^', '#', '~', '!', '%', '@', '+', ',', '`', '\"'};
    private static final boolean HEADLESS = AccessController.doPrivileged(() -> Boolean.getBoolean("java.awt.headless"));
    static Lexicon lex = Lexicon.make((String)"workbench");
    static final String note1 = lex.getText("genericAppFileView.note1");
    static final String note2 = lex.getText("genericAppFileView.note2");
    static final String browserNote = lex.getText("genericAppFileView.browserNote");
    static final String launch = lex.getText("genericAppFileView.launch");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        if (value instanceof BApplicationFile) {
            this.doLoadApplicationFile((BApplicationFile)value);
        } else {
            this.doLoadHttpObject((BHttpObject)value);
        }
    }

    void doLoadApplicationFile(BApplicationFile file) {
        BImage icon = BImage.make((BIcon)file.getIcon());
        String name = file.getFileName();
        boolean local = file.getStore() instanceof BLocalFileStore;
        boolean applet = this.getShell() instanceof BNiagaraWbWebShell;
        String note = note1;
        if (local) {
            note = note + " " + note2;
        } else if (applet) {
            note = note + " " + browserNote;
        }
        BLabel label = new BLabel(icon, name);
        label.setFont(Theme.widget().getBoldText());
        BGridPane grid = new BGridPane(1);
        grid.add(null, (BValue)label);
        grid.add(null, (BValue)new BLabel(note));
        BGridPane content = new BGridPane(1);
        content.setColumnAlign(BHalign.center);
        content.add(null, (BValue)new BBorderPane((BWidget)grid, 0.0, 0.0, 10.0, 0.0));
        if (local) {
            content.add(null, (BValue)new BButton((Command)new LaunchFile(this, (BIFile)file)));
        } else if (applet) {
            content.add(null, (BValue)new BButton((Command)new LaunchFromBrowser(this, (BIFile)file)));
        }
        this.setContent((BWidget)content);
    }

    void doLoadHttpObject(BHttpObject http) {
        BImage icon = BImage.make((String)"module://icons/x16/files/html.png");
        String name = http.getUri();
        String note = note1 + " " + note2;
        BLabel label = new BLabel(icon, name);
        label.setFont(Theme.widget().getBoldText());
        BGridPane grid = new BGridPane(1);
        grid.add(null, (BValue)label);
        grid.add(null, (BValue)new BLabel(note));
        BGridPane content = new BGridPane(1);
        content.setColumnAlign(BHalign.center);
        content.add(null, (BValue)new BBorderPane((BWidget)grid, 0.0, 0.0, 10.0, 0.0));
        content.add(null, (BValue)new BButton((Command)new LaunchUri(this, http.getUri())));
        this.setContent((BWidget)content);
    }

    class LaunchFromBrowser
    extends Command {
        BIFile file;

        public LaunchFromBrowser(BWidget owner, BIFile file) {
            super(owner, launch);
            this.file = file;
        }

        public CommandArtifact doInvoke() throws Exception {
            BNiagaraWbWebShell shell = (BNiagaraWbWebShell)this.getShell();
            BOrd ord = this.file.getNavOrd();
            if (shell.isWebStart()) {
                ord = BOrd.make((BOrd)ord, (OrdQuery)new ViewQuery("?browser=true"));
            }
            shell.reloadHyperlink(new HyperlinkInfo(ord));
            return null;
        }
    }

    class LaunchUri
    extends Command {
        String uri;

        public LaunchUri(BWidget owner, String uri) {
            super(owner, launch);
            this.uri = uri;
        }

        public CommandArtifact doInvoke() throws Exception {
            if (HEADLESS) {
                throw new UnsupportedOperationException("Display required to launch external application");
            }
            for (char invalidChar : INVALID_CHARACTERS) {
                if (this.uri.indexOf(invalidChar) == -1) continue;
                throw new IllegalArgumentException("Provided uri contains invalid character '" + invalidChar + "'");
            }
            if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.linux)) {
                new ProcessBuilder("xdg-open", this.uri).start();
            } else if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows)) {
                new ProcessBuilder("cmd.exe", "/c", "start", this.uri).start();
            }
            return null;
        }
    }

    class LaunchFile
    extends Command {
        BIFile file;

        public LaunchFile(BWidget owner, BIFile file) {
            super(owner, launch);
            this.file = file;
        }

        public CommandArtifact doInvoke() throws Exception {
            File local = ((BLocalFileStore)this.file.getStore()).getLocalFile();
            BLaunchExternalApplicationDestinationType.launchExternal((File)local);
            return null;
        }
    }
}

