/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.workbench.fieldeditors.BFloatFE;
import java.util.ArrayList;
import java.util.Arrays;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BSize;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraAction(name="pageSizeSelected", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")
public class BPageSizeFE
extends BWbFieldEditor {
    @Generated
    public static final Action pageSizeSelected = BPageSizeFE.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPageSizeFE.class);
    static Lexicon pdf = Lexicon.make((String)"pdf");
    static Lexicon gx = Lexicon.make((String)"gx");
    int customIndex = -1;
    BListDropDown sizes = null;
    BListDropDown orient = null;
    BFloatFE widthEditor;
    BFloatFE heightEditor;
    BLabel widthLabel;
    BLabel heightLabel;

    @Generated
    public void pageSizeSelected(BWidgetEvent parameter) {
        this.invoke(pageSizeSelected, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.sizes.setEnabled(!readonly);
        this.orient.setEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        this.sizes = new BListDropDown();
        this.orient = new BListDropDown();
        this.widthEditor = new BFloatFE();
        this.heightEditor = new BFloatFE();
        this.widthLabel = new BLabel();
        this.heightLabel = new BLabel();
        String list = pdf.getText("pageSize.list");
        ArrayList<String> a = new ArrayList<String>(Arrays.asList(TextUtil.split((String)list, (char)';')));
        if (!a.contains("custom")) {
            a.add("custom");
        }
        String[] keys = a.toArray(new String[0]);
        BSize size = (BSize)value;
        int sel = -1;
        boolean landscape = false;
        for (int i = 0; i < keys.length; ++i) {
            String key = "pageSize." + keys[i];
            PageSize item = new PageSize();
            item.displayName = pdf.getText(key + ".displayName");
            item.width = Double.parseDouble(pdf.getText(key + ".width"));
            item.height = Double.parseDouble(pdf.getText(key + ".height"));
            this.sizes.getList().addItem((Object)item);
            if ("custom".equals(keys[i])) {
                this.customIndex = i;
            }
            if (Math.abs(size.height - item.height) < 0.1 && Math.abs(size.width - item.width) < 0.1) {
                sel = i;
                continue;
            }
            if (!(Math.abs(size.height - item.width) < 0.1) || !(Math.abs(size.width - item.height) < 0.1)) continue;
            sel = i;
            landscape = true;
        }
        if (sel == -1) {
            sel = this.customIndex != -1 ? this.customIndex : 0;
        }
        this.sizes.getList().setSelectedIndex(sel);
        this.updateVisibility(sel);
        this.orient.getList().addItem((Object)pdf.getText("pageSize.orient.portrait"));
        this.orient.getList().addItem((Object)pdf.getText("pageSize.orient.landscape"));
        this.orient.getList().setSelectedIndex(landscape ? 1 : 0);
        this.widthLabel.setText(gx.getText("size.width"));
        this.heightLabel.setText(gx.getText("size.height"));
        BGridPane grid = new BGridPane(4);
        grid.add(null, (BValue)this.sizes);
        grid.add(null, (BValue)this.orient);
        grid.add(null, (BValue)this.widthLabel);
        grid.add(null, (BValue)this.widthEditor);
        grid.add(null, (BValue)new BLabel());
        grid.add(null, (BValue)new BLabel());
        grid.add(null, (BValue)this.heightLabel);
        grid.add(null, (BValue)this.heightEditor);
        this.setContent((BWidget)grid);
        this.loadCustomSize(size, cx);
        this.linkTo((BComponent)this.sizes, (Slot)BListDropDown.valueModified, (Slot)pageSizeSelected);
        this.linkTo((BComponent)this.orient, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo((BComponent)this.heightEditor, (Slot)BFloatFE.pluginModified, (Slot)setModified);
        this.linkTo((BComponent)this.widthEditor, (Slot)BFloatFE.pluginModified, (Slot)setModified);
    }

    private void loadCustomSize(BSize size, Context cx) {
        BFacets facets = BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"inch"), (String)"precision", (BIDataValue)BInteger.make((int)2), (String)"min", (BIDataValue)BDouble.make((double)2.0));
        BasicContext ctx = new BasicContext(cx, facets);
        this.widthEditor.loadValue((BObject)BDouble.make((double)size.width), (Context)ctx);
        this.heightEditor.loadValue((BObject)BDouble.make((double)size.height), (Context)ctx);
    }

    @Override
    protected BObject doSaveValue(BObject facetsValue, Context cx) throws Exception {
        PageSize item = (PageSize)this.sizes.getList().getSelectedItem();
        if (this.sizes.getSelectedIndex() == this.customIndex) {
            BNumber newWidth = (BNumber)this.widthEditor.saveValue();
            BNumber newHeight = (BNumber)this.heightEditor.saveValue();
            return BSize.make((double)newWidth.getDouble(), (double)newHeight.getDouble());
        }
        if (this.orient.getSelectedIndex() == 0) {
            return BSize.make((double)item.width, (double)item.height);
        }
        return BSize.make((double)item.height, (double)item.width);
    }

    public void doPageSizeSelected(BWidgetEvent event) {
        int selectedIndex = this.sizes.getSelectedIndex();
        this.updateVisibility(selectedIndex);
        this.setModified();
    }

    private void updateVisibility(int selectedIndex) {
        boolean custom = selectedIndex == this.customIndex;
        this.orient.setVisible(!custom);
        this.widthLabel.setVisible(custom);
        this.widthEditor.setVisible(custom);
        this.heightLabel.setVisible(custom);
        this.heightEditor.setVisible(custom);
    }

    class PageSize {
        String displayName;
        double width;
        double height;

        PageSize() {
        }

        public String toString() {
            return this.displayName;
        }
    }
}

