/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.nav.BNavContainerView;
import javax.baja.gx.BFont;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BIExportableTableView;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"fox:FoxSession"}, requiredPermissions="r")})
public class BStationSummary
extends BWbView
implements BIExportableTableView {
    @Generated
    public static final Type TYPE = Sys.loadType(BStationSummary.class);
    static final BFont bold = Theme.widget().getBoldText();
    static final Lexicon lex = Lexicon.make((BModule)TYPE.getModule(), (Context)null);
    static final String lexStatus = lex.getText("serviceManager.status");
    BTable propTable;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BStationSummary() {
        this.setContent((BWidget)new BLabel("Station Summary"));
    }

    @Override
    public BTable getExportTable() {
        return this.propTable;
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BFoxSession session = (BFoxSession)value;
        BNavContainerView navView = new BNavContainerView();
        navView.loadValue((BObject)session, cx);
        String[][] pairs = new String[0][0];
        try {
            pairs = session.getConnection().getChannels().getSysChannel().summary();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.propTable = new BTable((TableModel)new PropertyModel(pairs));
        BSplitPane split = new BSplitPane(BOrientation.vertical, 50.0);
        split.setWidget1((BWidget)navView);
        split.setWidget2((BWidget)BTitlePane.makePane((String)lex.getText("stationSummary.props"), (BTable)this.propTable));
        this.setContent((BWidget)split);
    }

    class PropertyModel
    extends TableModel {
        String[][] pairs;

        public PropertyModel(String[][] pairs) {
            this.pairs = pairs;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return lex.getText("stationSummary.key");
            }
            return lex.getText("stationSummary.value");
        }

        public int getRowCount() {
            return this.pairs.length;
        }

        public Object getValueAt(int row, int col) {
            return col == 0 ? lex.getText(this.pairs[row][0]) : this.pairs[row][1];
        }
    }
}

