/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.ui.UiEnv;
import com.tridium.workbench.util.BTimeoutMeter;
import java.util.HashMap;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.gx.IRectGeom;
import javax.baja.ui.BBorder;
import javax.baja.ui.BFrame;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWindow;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.workbench.util.BNotifyPane;

public class NotifyManager {
    private static NotifyManager instance;
    private static final int DEFAULT_TIMEOUT = 4000;
    private static final int rate = 50;
    private static final int delta = 5;
    private BFrame frame;
    private IRectGeom screen;
    private HashMap<BWindow, BTimeoutMeter> hash = new HashMap();

    public static NotifyManager get() {
        if (instance == null) {
            instance = new NotifyManager();
        }
        return instance;
    }

    NotifyManager() {
        this.frame = new BFrame();
        this.screen = UiEnv.get().getScreenBounds(null);
    }

    public void open(BNotifyPane pane, int timeout) {
        BWindow w = this.makeWindow(pane, timeout);
        new Animate(w, timeout).start();
    }

    public void close(BNotifyPane pane) {
    }

    private BWindow makeWindow(BNotifyPane content, double timeout) {
        BTimeoutMeter meter = new BTimeoutMeter(timeout);
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)new BBorderPane((BWidget)content));
        edge.setRight((BWidget)meter);
        BBorderPane pane = new BBorderPane((BWidget)edge);
        pane.setBorder(BBorder.make((String)"1px solid black"));
        pane.setFill(BColor.make((int)0xEEEEEE).toBrush());
        pane.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        BWindow w = new BWindow((BWidget)this.frame, (BWidget)pane);
        this.hash.put(w, meter);
        return w;
    }

    class Animate
    extends Thread {
        private BWindow window;
        private int timeout;

        public Animate(BWindow w, int timeout) {
            super("Ui:NotifyAnimation");
            this.window = w;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            BWidget c = this.window.getContent();
            c.computePreferredSize();
            double w = c.getPreferredWidth();
            double h = c.getPreferredHeight();
            double x = NotifyManager.this.screen.width() - w;
            double y = NotifyManager.this.screen.height() - h;
            double dy = NotifyManager.this.screen.height();
            for (BWindow temp : NotifyManager.this.hash.keySet()) {
                if (temp == this.window) continue;
                y -= temp.getContent().getPreferredHeight() - 1.0;
                dy -= temp.getContent().getPreferredHeight() - 1.0;
            }
            this.window.setScreenBounds(x, dy, w, h);
            this.window.open();
            while (dy > y) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception temp) {
                    // empty catch block
                }
                dy -= 5.0;
                if (dy < y) {
                    dy = y;
                }
                this.window.setScreenBounds(x, dy, w, h);
            }
            BTimeoutMeter m = (BTimeoutMeter)((Object)NotifyManager.this.hash.get(this.window));
            int dr = 0;
            while (dr < this.timeout) {
                try {
                    Thread.sleep(100L);
                    dr += 100;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                m.setCurrent(this.timeout - dr);
                m.repaint();
            }
            while (dy < NotifyManager.this.screen.height()) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.window.setScreenBounds(x, dy += 5.0, w, h);
            }
            this.window.close();
            NotifyManager.this.hash.remove(this.window);
        }
    }
}

