/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.file.types.bog.BBogSpace;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tagdictionary.BSmartTagDictionary;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;

public interface TagUtil {
    public static TagDictionaryService makeTagDictionaryService() {
        BComponent service = (BComponent)TagUtil.getTagDictionaryServiceFromPalettes();
        HashMap<String, TagDictionary> namespaceMap = new HashMap<String, TagDictionary>();
        for (TagDictionary tagDictionary : TagUtil.getTagDictionariesFromPalettes()) {
            TagUtil.checkAddDictionary(tagDictionary, service, namespaceMap);
        }
        for (TagDictionary tagDictionary : TagUtil.getUserTagDictionaries()) {
            TagUtil.checkAddDictionary(tagDictionary, service, namespaceMap);
        }
        return (TagDictionaryService)service;
    }

    public static void checkAddDictionary(TagDictionary tagDictionary, BComponent service, HashMap<String, TagDictionary> namespaceMap) {
        String namespace = tagDictionary.getNamespace();
        if (namespaceMap.containsKey(namespace)) {
            return;
        }
        BComponent thisTagDictn = (BComponent)tagDictionary;
        if (service.get(thisTagDictn.getName()) != null) {
            return;
        }
        if (tagDictionary.getTags().hasNext() || tagDictionary.getTagGroups().hasNext()) {
            Property addedTd = service.add(thisTagDictn.getName(), thisTagDictn.newCopy());
            service.setDisplayName(addedTd, BFormat.make((String)thisTagDictn.getDisplayName(null)), null);
            namespaceMap.put(namespace, tagDictionary);
        }
    }

    public static TagDictionaryService getTagDictionaryServiceFromPalettes() {
        TypeInfo[] types;
        BTypeSpec tagDictionary = BTypeSpec.make((String)"tagdictionary", (String)"TagDictionary");
        for (TypeInfo type : types = Sys.getRegistry().getTypes(tagDictionary.getTypeInfo())) {
            BINavNode[] entries;
            BModule module = Sys.loadModule((String)type.getModuleName());
            BINavNode node = module.getNavChild("module.palette");
            for (BINavNode entry : entries = node.getNavChildren()) {
                if (!(entry instanceof TagDictionaryService)) continue;
                return (TagDictionaryService)entry;
            }
        }
        return null;
    }

    public static Collection<TagDictionary> getTagDictionariesFromPalettes() {
        ArrayList<TagDictionary> result = new ArrayList<TagDictionary>();
        BTypeSpec tagDictionary = BTypeSpec.make((String)"tagdictionary", (String)"TagDictionary");
        for (TypeInfo type : Sys.getRegistry().getTypes(tagDictionary.getTypeInfo())) {
            BINavNode[] entries;
            BModule module = Sys.loadModule((String)type.getModuleName());
            BINavNode node = module.getNavChild("module.palette");
            for (BINavNode entry : entries = node.getNavChildren()) {
                if (entry instanceof TagDictionaryService) {
                    entry = entry.getNavChild("Niagara");
                }
                if (!(entry instanceof TagDictionary) || result.contains(entry)) continue;
                result.add((TagDictionary)entry);
            }
        }
        return result;
    }

    public static Collection<TagDictionary> getUserTagDictionaries() {
        ArrayList<TagDictionary> result = new ArrayList<TagDictionary>();
        BDirectory tdDirectory = TagUtil.getTagDictionaryDirectory();
        BTypeSpec tdTypeSpec = BTypeSpec.make((String)"tagdictionary", (String)"TagDictionary");
        TypeInfo tdTypeInfo = tdTypeSpec.getTypeInfo();
        for (BIFile file : tdDirectory.listFiles()) {
            BBogFile bFile;
            BBogSpace bogSpace;
            BComponent rootComponent;
            if ("bog".equals(file.getExtension()) && (rootComponent = (bogSpace = (BBogSpace)(bFile = (BBogFile)file).open()).getRootComponent().getChildComponents()[0]).getType().is(tdTypeInfo)) {
                TagDictionary td = (TagDictionary)rootComponent;
                if (result.contains(td)) continue;
                result.add(td);
            }
            if (!"json".equals(file.getExtension())) continue;
            try (InputStream inputStream = file.getInputStream();){
                BSmartTagDictionary td;
                JSONTokener tokener = new JSONTokener(inputStream);
                JSONObject dictionaryJson = new JSONObject(tokener);
                if (dictionaryJson.has("rules")) {
                    td = new BSmartTagDictionary();
                    td.decodeFromJson(dictionaryJson);
                    TagUtil.addDictionary(result, (TagDictionary)td);
                    continue;
                }
                td = new BTagDictionary();
                td.decodeFromJson(dictionaryJson);
                TagUtil.addDictionary(result, (TagDictionary)td);
            }
            catch (Exception e) {
                BTagDictionary.logger.log(Level.WARNING, "Unable to load user tag dictionary from file " + file.getFileName());
            }
        }
        return result;
    }

    public static void addDictionary(Collection<TagDictionary> dictionaries, TagDictionary td) {
        if (td.getNamespace() == null) {
            return;
        }
        for (TagDictionary dictionary : dictionaries) {
            if (!td.getNamespace().equals(dictionary.getNamespace())) continue;
            return;
        }
        dictionaries.add(td);
    }

    public static BDirectory getTagDictionaryDirectory() {
        try {
            return (BDirectory)TagUtil.getTagDictionaryDirectoryOrd().resolve().get();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BOrd getTagDictionaryDirectoryOrd() throws Exception {
        BOrd tdOrd = BOrd.make((String)"local:|file:~tagDictionaries");
        try {
            tdOrd.resolve();
        }
        catch (UnresolvedException e) {
            BDirectory fDir = BFileSystem.INSTANCE.getUserHome();
            fDir.getFileSpace().makeDir(fDir.getFilePath().merge("tagDictionaries"));
        }
        return tdOrd;
    }

    public static boolean isValidTagId(String id) {
        String[] split = id.split(":");
        if (split.length != 2) {
            return false;
        }
        if (split[0].isEmpty() || !SlotPath.isValidName((String)split[0])) {
            return false;
        }
        return !split[1].isEmpty() && SlotPath.isValidName((String)split[1]);
    }

    public static boolean isDirectTag(BComponent comp, Tag tag) {
        try {
            return comp.get(SlotPath.escape((String)tag.getId().getQName())) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

