/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.security.UrlWhitelist;
import com.tridium.sys.Nre;
import com.tridium.ui.theme.Theme;
import com.tridium.ux.NiagaraEnv;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.web.browser.BIWebBrowserImpl;
import com.tridium.workbench.web.browser.BNullWebBrowserImpl;
import com.tridium.workbench.web.browser.BWebWidget;
import com.tridium.workbench.web.browser.IJs;
import com.tridium.workbench.web.browser.interop.ConsoleEventHandler;
import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.util.LexiconModule;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="title", type="String", defaultValue=""), @NiagaraProperty(name="ord", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="location", type="String", defaultValue="", flags=259), @NiagaraProperty(name="progress", type="double", defaultValue="0", flags=259), @NiagaraProperty(name="progressRunning", type="boolean", defaultValue="false", flags=259), @NiagaraProperty(name="showProgressIndicator", type="boolean", defaultValue="false"), @NiagaraProperty(name="contextMenuEnabled", type="boolean", defaultValue="true")})
@NiagaraAction(name="reload")
@NiagaraTopics(value={@NiagaraTopic(name="initialized"), @NiagaraTopic(name="closing"), @NiagaraTopic(name="loaded", eventType="BBoolean"), @NiagaraTopic(name="statusMsg", eventType="BString"), @NiagaraTopic(name="error", eventType="BString"), @NiagaraTopic(name="forward"), @NiagaraTopic(name="back"), @NiagaraTopic(name="appendHistory", eventType="BOrd")})
public final class BWebBrowser
extends BWidget {
    @Generated
    public static final Property title = BWebBrowser.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property ord = BWebBrowser.newProperty((int)0, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property location = BWebBrowser.newProperty((int)259, (String)"", null);
    @Generated
    public static final Property progress = BWebBrowser.newProperty((int)259, (int)0, null);
    @Generated
    public static final Property progressRunning = BWebBrowser.newProperty((int)259, (boolean)false, null);
    @Generated
    public static final Property showProgressIndicator = BWebBrowser.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property contextMenuEnabled = BWebBrowser.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action reload = BWebBrowser.newAction((int)0, null);
    @Generated
    public static final Topic initialized = BWebBrowser.newTopic((int)0, null);
    @Generated
    public static final Topic closing = BWebBrowser.newTopic((int)0, null);
    @Generated
    public static final Topic loaded = BWebBrowser.newTopic((int)0, null);
    @Generated
    public static final Topic statusMsg = BWebBrowser.newTopic((int)0, null);
    @Generated
    public static final Topic error = BWebBrowser.newTopic((int)0, null);
    @Generated
    public static final Topic forward = BWebBrowser.newTopic((int)0, null);
    @Generated
    public static final Topic back = BWebBrowser.newTopic((int)0, null);
    @Generated
    public static final Topic appendHistory = BWebBrowser.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWebBrowser.class);
    public static final double DEFAULT_PREFERRED_WIDTH = 640.0;
    public static final double DEFAULT_PREFERRED_HEIGHT = 480.0;
    public static final Logger profileLog = Logger.getLogger("profile.browser");
    public static final Logger consoleLog = Logger.getLogger("webBrowser.console");
    private final BIWebBrowserImpl impl;
    private static final Object STATIC_MONITOR = new Object();
    private static BWebBrowser staticBrowser;
    private static boolean loggedPreInitError;
    private static final BIcon icon;
    public static final Logger log;
    private static final LexiconModule LEX;
    private volatile boolean closeOnStop = true;
    private static final String[] supportedBrowserImpl;
    public static final boolean BROWSING_DISABLED;
    private static final boolean HEADLESS;

    @Generated
    public String getTitle() {
        return this.getString(title);
    }

    @Generated
    public void setTitle(String v) {
        this.setString(title, v, null);
    }

    @Generated
    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    @Generated
    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    @Generated
    public String getLocation() {
        return this.getString(location);
    }

    @Generated
    public void setLocation(String v) {
        this.setString(location, v, null);
    }

    @Generated
    public double getProgress() {
        return this.getDouble(progress);
    }

    @Generated
    public void setProgress(double v) {
        this.setDouble(progress, v, null);
    }

    @Generated
    public boolean getProgressRunning() {
        return this.getBoolean(progressRunning);
    }

    @Generated
    public void setProgressRunning(boolean v) {
        this.setBoolean(progressRunning, v, null);
    }

    @Generated
    public boolean getShowProgressIndicator() {
        return this.getBoolean(showProgressIndicator);
    }

    @Generated
    public void setShowProgressIndicator(boolean v) {
        this.setBoolean(showProgressIndicator, v, null);
    }

    @Generated
    public boolean getContextMenuEnabled() {
        return this.getBoolean(contextMenuEnabled);
    }

    @Generated
    public void setContextMenuEnabled(boolean v) {
        this.setBoolean(contextMenuEnabled, v, null);
    }

    @Generated
    public void reload() {
        this.invoke(reload, null, null);
    }

    @Generated
    public void fireInitialized(BValue event) {
        this.fire(initialized, event, null);
    }

    @Generated
    public void fireClosing(BValue event) {
        this.fire(closing, event, null);
    }

    @Generated
    public void fireLoaded(BBoolean event) {
        this.fire(loaded, (BValue)event, null);
    }

    @Generated
    public void fireStatusMsg(BString event) {
        this.fire(statusMsg, (BValue)event, null);
    }

    @Generated
    public void fireError(BString event) {
        this.fire(error, (BValue)event, null);
    }

    @Generated
    public void fireForward(BValue event) {
        this.fire(forward, event, null);
    }

    @Generated
    public void fireBack(BValue event) {
        this.fire(back, event, null);
    }

    @Generated
    public void fireAppendHistory(BOrd event) {
        this.fire(appendHistory, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWebBrowser() {
        this(Collections.emptyMap());
        this.setWhitelist(UrlWhitelist.getDefaultInstance((String[])new String[0]));
    }

    public BWebBrowser(Map<String, String> options) {
        this(BWebBrowser.makeImpl(options));
    }

    public BWebBrowser(BIWebBrowserImpl impl) {
        if (impl == null) {
            throw new IllegalArgumentException("BIWebBrowserImpl required");
        }
        this.impl = impl;
        impl.setOnLoaded(this::onLoaded);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "using " + impl.getType());
        }
        this.add("impl", (BValue)impl, 2);
    }

    public static BIWebBrowserImpl makeImpl(Map<String, String> options) {
        BIWebBrowserImpl im = null;
        for (String implTypeSpec : supportedBrowserImpl) {
            boolean stationFx;
            boolean isNullWebBrowserImpl = "workbench:NullWebBrowserImpl".equals(implTypeSpec);
            boolean isFxWebBrowserImpl = "workbench:FxWebBrowserImpl".equals(implTypeSpec);
            boolean bl = stationFx = isFxWebBrowserImpl && Sys.isStation();
            if (BROWSING_DISABLED && !isNullWebBrowserImpl || stationFx) continue;
            try {
                im = (BIWebBrowserImpl)Sys.getType((String)implTypeSpec).getInstance();
                if (im.preInitialize(options)) break;
                im = null;
            }
            catch (Throwable t) {
                Level level = Level.FINE;
                if (!loggedPreInitError) {
                    if (BWebWidget.IS_WEB_LAUNCHER) {
                        level = Level.INFO;
                    } else if (!HEADLESS) {
                        level = Level.WARNING;
                    }
                    loggedPreInitError = true;
                }
                log.log(level, "Cannot initialize browser", t);
                im = null;
            }
        }
        if (im == null) {
            throw new IllegalStateException("Cannot find Web Browser Impl!");
        }
        return im;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void changed(Property prop, Context context) {
        this.impl.browserChanged(prop, context);
    }

    public void computePreferredSize() {
        this.setPreferredSize(640.0, 480.0);
    }

    public void doLayout(BWidget[] children) {
        this.impl.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    public void doReload() {
        this.impl.browserReload();
    }

    void setDropHandler(IWebBrowserDropHandler dropHandler) {
        this.impl.setDropHandler(dropHandler);
    }

    public BTransferWidget getTransferWidget() {
        return (BTransferWidget)this.impl;
    }

    public boolean hasBeforeUnload() {
        try {
            if (!this.isInitialized()) {
                return false;
            }
            return this.executeScriptAndWait("typeof window.onbeforeunload === 'function' && !!window.onbeforeunload();").toBool();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to check beforeunload", e);
            return false;
        }
    }

    private static String getThemeName() {
        String installedThemeName = Theme.getInstalledThemeName();
        if (installedThemeName != null && !installedThemeName.isEmpty()) {
            return installedThemeName;
        }
        if (BWidget.getApplication() != null) {
            BDynamicEnum activeTheme = BGeneralOptions.make().getActiveTheme();
            return activeTheme.getTag();
        }
        return "Zebra";
    }

    private void onLoaded() {
        String themeName = BWebBrowser.getThemeName();
        NiagaraEnv env = new NiagaraEnv(NiagaraEnv.EnvType.WORKBENCH).withCustomProperty("profileBrowser", (Object)profileLog.isLoggable(Level.FINE)).withCustomProperty("designTime", (Object)this.isDesignTime()).withCustomProperty("nreBootTime", (Object)Nre.bootTime).withThemeName(themeName);
        this.executeScriptAsync(env.toJavaScript());
    }

    public IJs executeScript(String script) {
        return AccessController.doPrivileged(() -> this.impl.executeScript(script));
    }

    public IJs executeScriptAndWait(String script) {
        return AccessController.doPrivileged(() -> this.impl.executeScriptAndWait(script));
    }

    public void executeScriptAsync(String script) {
        AccessController.doPrivileged(() -> {
            this.impl.executeScriptAsync(script);
            return null;
        });
    }

    public void load(BObject object, Context cx) {
        this.impl.load(object, cx);
    }

    public void setWhitelist(UrlWhitelist whitelist) {
        this.impl.setWhitelist(whitelist);
    }

    public static String getWhitelistBlockedMessage(Context cx) {
        return LEX.getHtmlSafe("WebBrowser.whitelist.blocked", cx);
    }

    public static String getCertificateBlockedMessage(Context cx) {
        return LEX.getHtmlSafe("WebBrowser.certificate.blocked", cx);
    }

    public void setOnRegisterFunctions(Runnable newOnRegisterFunctions) {
        this.impl.setOnRegisterFunctions(newOnRegisterFunctions);
    }

    public void setOnLoaded(Runnable newOnLoaded) {
        this.impl.setOnLoaded(() -> {
            this.onLoaded();
            newOnLoaded.run();
        });
    }

    public void setUserAgentStyleSheetLocation(String location) {
        this.impl.setUserAgentStyleSheetLocation(location);
    }

    public boolean isInitialized() {
        return this.impl.isInitialized();
    }

    public boolean isUri() {
        return !this.getLocation().isEmpty();
    }

    public Optional<String> fromJsToString(Object o) {
        return this.impl.fromJsToString(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void post(BWebBrowser browser, Runnable r) {
        if (browser == null) {
            Object object = STATIC_MONITOR;
            synchronized (object) {
                if (staticBrowser == null) {
                    staticBrowser = new BWebBrowser(Collections.singletonMap("forceStationBrowserInit", Boolean.TRUE.toString()));
                }
            }
            browser = staticBrowser;
        }
        browser.impl.post(r);
    }

    void forceInitialize() {
        ((BWidget)this.impl).add("forceInitialize", (BValue)BBoolean.TRUE);
    }

    public boolean isStub() {
        return this.impl instanceof BNullWebBrowserImpl;
    }

    public boolean isCookiePresent(URI uri, String name, String value, String path) {
        return this.impl.isCookiePresent(uri, name, value, path);
    }

    public Optional<String> getCookieValue(URI uri, String name, String path) {
        return this.impl.getCookieValue(uri, name, path);
    }

    public void removeCookie(URI uri, String name, String path) {
        this.impl.removeCookie(uri, name, path);
    }

    public void addCookie(URI uri, String name, String value, String path) throws IOException {
        this.impl.addCookie(uri, name, value, path);
    }

    public void register(String name, Runnable func) {
        this.impl.register(name, func);
    }

    public <T> void registerConsumer(String name, Consumer<T> func) {
        this.impl.registerConsumer(name, func);
    }

    public <T, U> void registerBiConsumer(String name, BiConsumer<T, U> func) {
        this.impl.registerBiConsumer(name, func);
    }

    public <T, R> void registerFunction(String name, Function<T, R> func) {
        this.impl.registerFunction(name, func);
    }

    public <T, U, R> void registerBiFunction(String name, BiFunction<T, U, R> func) {
        this.impl.registerBiFunction(name, func);
    }

    public <R> void registerSupplier(String name, Supplier<R> func) {
        this.impl.registerSupplier(name, func);
    }

    public void registerObject(Object o) {
        this.impl.registerObject(o);
    }

    public void registerConsoleEventHandler(ConsoleEventHandler eventHandler) {
        this.impl.registerConsoleEventHandler(eventHandler);
    }

    public void removeConsoleEventHandler(ConsoleEventHandler eventHandler) {
        this.impl.removeConsoleEventHandler(eventHandler);
    }

    public void close() {
        this.impl.close();
    }

    public boolean canUseLocalWbResources() {
        return this.impl.canUseLocalWbResources();
    }

    public boolean isCloseOnStop() {
        return this.closeOnStop;
    }

    public void setCloseOnStop(boolean closeOnStop) {
        this.closeOnStop = closeOnStop;
    }

    public String toHostAddr(BHost host) {
        return this.impl.toHostAddr(host);
    }

    public boolean supportsNativePdfExport() {
        return this.impl.supportsNativePdfExport();
    }

    public void exportToNativePdf(PdfOp op) throws Exception {
        if (!this.supportsNativePdfExport()) {
            throw new UnsupportedOperationException("Native PDF export not supported by " + this.getType());
        }
        this.impl.exportToNativePdf(op);
    }

    String getFragmentScrollReadyJs() {
        return this.impl.getFragmentScrollReadyJs();
    }

    boolean isJavaFx() {
        return this.impl.getType().toString().equals("workbench:FxWebBrowserImpl");
    }

    public String getDebugUrl() {
        return this.impl.getDebugUrl();
    }

    public String getDebugId() {
        return this.impl.getDebugId();
    }

    public void clearCache() {
        this.impl.clearCache();
    }

    void playSound(BOrd sound) {
        this.impl.playSound(sound);
    }

    void stopSound(BOrd sound) {
        this.impl.stopSound(sound);
    }

    static {
        icon = BIcon.std((String)"web.png");
        log = Logger.getLogger("webBrowser");
        LEX = LexiconModule.make((String)"workbench");
        supportedBrowserImpl = new String[]{"jxBrowser:JxWebBrowserImpl", "workbench:FxWebBrowserImpl", "workbench:NullWebBrowserImpl"};
        BROWSING_DISABLED = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.webbrowser.disabled"));
        HEADLESS = AccessController.doPrivileged(() -> Boolean.getBoolean("java.awt.headless"));
    }

    public static interface IWebBrowserDropHandler {
        public int doDragOver(TransferContext var1);

        public CommandArtifact doDrop(TransferContext var1);
    }
}

