/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.workbench.web.browser.LoopbackCallbackHandler;
import com.tridium.workbench.web.browser.LoopbackNiagaraSession;
import java.security.AccessController;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public final class LoopbackLoginModule
implements LoginModule {
    private CallbackHandler callbackHandler;
    private Subject subject;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.callbackHandler = callbackHandler;
        this.subject = subject;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null || !(this.callbackHandler instanceof LoopbackCallbackHandler)) {
            throw new LoginException("Invalid callback handler");
        }
        this.succeeded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (!this.subject.getPrincipals().contains(LoopbackNiagaraSession.SUPER_ADMIN_USER)) {
            AccessController.doPrivileged(() -> this.subject.getPrincipals().add((Principal)LoopbackNiagaraSession.SUPER_ADMIN_USER));
        }
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        AccessController.doPrivileged(() -> {
            this.subject.getPrincipals().remove(LoopbackNiagaraSession.SUPER_ADMIN_USER);
            return null;
        });
        this.succeeded = false;
        this.commitSucceeded = false;
        return true;
    }
}

