/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.commands;

import com.tridium.workbench.util.WbUtil;
import javax.baja.naming.SlotPath;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;

public class ComponentRenameCommand
extends Command {
    final UiLexicon lex;
    final String lexTitle;
    BIPropertyContainer[] components;
    Slot[] slots;
    String[] oldNames;
    String[] oldDisplay;
    String[] newNames;

    public ComponentRenameCommand(BWidget owner, BComponent component) {
        this(owner, component, (String)null);
    }

    public ComponentRenameCommand(BWidget owner, BComponent component, String newName) {
        this(owner, (BComponent)component.getParent(), component.getPropertyInParent(), newName);
    }

    public ComponentRenameCommand(BWidget owner, BComponent component, Property slot) {
        this(owner, component, slot, null);
    }

    public ComponentRenameCommand(BWidget owner, BComponent component, Property slot, String newName) {
        String[] stringArray;
        BIPropertyContainer[] bIPropertyContainerArray = new BIPropertyContainer[]{component};
        Property[] propertyArray = new Property[]{slot};
        if (newName == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = newName;
        }
        this(owner, bIPropertyContainerArray, propertyArray, stringArray);
    }

    public ComponentRenameCommand(BWidget owner, BComponent[] components, Property[] slots, String[] newNames) {
        this(owner, (BIPropertyContainer[])components, slots, newNames);
    }

    public ComponentRenameCommand(BWidget owner, BIPropertyContainer[] containers, Property[] slots, String[] newNames) {
        super(owner, UiLexicon.bajaui().module, "commands.rename");
        this.lex = UiLexicon.bajaui();
        this.lexTitle = this.lex.getText("commands.rename.label");
        if (containers.length != slots.length) {
            throw new IllegalArgumentException();
        }
        if (newNames != null) {
            if (containers.length != newNames.length) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < newNames.length; ++i) {
                if (newNames[i] != null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.components = containers;
        this.slots = slots;
        this.newNames = newNames;
    }

    public CommandArtifact doInvoke() throws Exception {
        int i;
        int len = this.components.length;
        this.oldNames = new String[len];
        this.oldDisplay = new String[len];
        for (i = 0; i < len; ++i) {
            String name;
            this.oldNames[i] = name = this.slots[i].getName();
            this.oldDisplay[i] = SlotPath.unescape((String)name);
            BValue val = this.components[i].get(name);
            if (!(val instanceof BIMixIn)) continue;
            BDialog.error((BWidget)this.getShell(), (String)this.getLabel(), (Object)UiLexicon.bajaui().getText("commands.rename.errorMixIn"));
            return null;
        }
        if (this.newNames == null) {
            if (this.components.length == 1) {
                this.promptSingle();
            } else {
                this.promptList();
            }
            if (this.newNames == null) {
                return null;
            }
            for (i = 0; i < len; ++i) {
                this.newNames[i] = SlotPath.escape((String)this.newNames[i].trim());
            }
        }
        Artifact artifact = new Artifact();
        artifact.redo();
        return artifact;
    }

    void promptSingle() {
        String s = BDialog.prompt((BWidget)this.getShell(), (String)this.getLabel(), (String)this.oldDisplay[0], (int)40);
        if (s == null) {
            return;
        }
        this.newNames = new String[]{s};
    }

    void promptList() {
        WbUtil.BatchReplace batch = new WbUtil.BatchReplace(this.getOwner(), this.oldDisplay);
        this.newNames = batch.prompt(this.lexTitle);
    }

    static void fixLinks(BComponent c, Property prop, BString newName, Context tx) {
        BLink[] links = c.getLinks((Slot)prop);
        for (int i = 0; i < links.length; ++i) {
            BLink link = links[i];
            try {
                link.set(BLink.targetSlotName, (BValue)newName, tx);
                continue;
            }
            catch (Exception e) {
                System.out.println("ERROR: Cannot fix link: " + link);
                e.printStackTrace();
            }
        }
        Knob[] knobs = c.getKnobs((Slot)prop);
        block5: for (int i = 0; i < knobs.length; ++i) {
            Knob knob = knobs[i];
            try {
                BComponent target = (BComponent)knob.getTargetOrd().get((BObject)c);
                target.lease();
                Property targetProp = target.getProperty(knob.getTargetSlotName());
                BLink[] targetLinks = target.getLinks((Slot)targetProp);
                for (int j = 0; j < targetLinks.length; ++j) {
                    BLink link = targetLinks[j];
                    if (!ComponentRenameCommand.isMatch(knob, link)) continue;
                    link.set(BLink.sourceSlotName, (BValue)newName, tx);
                    continue block5;
                }
                continue;
            }
            catch (Exception e) {
                System.out.println("ERROR: Cannot fix knob: " + knob);
                e.printStackTrace();
            }
        }
    }

    static boolean isMatch(Knob knob, BLink link) {
        return link.getSourceOrd().equals((Object)knob.getSourceOrd()) && link.getSourceSlotName().equals(knob.getSourceSlotName());
    }

    class Artifact
    implements CommandArtifact {
        Artifact() {
        }

        public void undo() throws Exception {
            this.rename(ComponentRenameCommand.this.newNames, ComponentRenameCommand.this.oldNames);
        }

        public void redo() throws Exception {
            this.rename(ComponentRenameCommand.this.oldNames, ComponentRenameCommand.this.newNames);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rename(String[] oldNames, String[] newNames) throws Exception {
            ComponentRenameCommand.this.getShell().enterBusy();
            try {
                boolean useTx = ComponentRenameCommand.this.components[0] instanceof BComponent;
                Context tx = useTx ? Transaction.start((BComponent)((BComponent)ComponentRenameCommand.this.components[0]), null) : null;
                for (int i = 0; i < ComponentRenameCommand.this.components.length; ++i) {
                    BIPropertyContainer c = ComponentRenameCommand.this.components[i];
                    String oldName = oldNames[i];
                    String newName = newNames[i];
                    Property prop = c.getProperty(oldName);
                    if (c instanceof BComponent) {
                        ComponentRenameCommand.fixLinks((BComponent)c, prop, BString.make((String)newName), tx);
                    }
                    c.rename(prop, newName, tx);
                }
                if (useTx) {
                    Transaction.end((BComponent)((BComponent)ComponentRenameCommand.this.components[0]), (Context)tx);
                }
            }
            finally {
                ComponentRenameCommand.this.getShell().exitBusy();
            }
        }
    }
}

