/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.util.WbViewEventWorker;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableCellRenderer;
import javax.baja.workbench.component.table.ComponentTableController;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.component.table.ComponentTableSelection;
import javax.baja.workbench.component.table.ComponentTableSubject;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.folder.FolderModel;

@NiagaraType
public class BMgrTable
extends BComponentTable {
    @Generated
    public static final Type TYPE = Sys.loadType(BMgrTable.class);
    BAbstractManager manager;
    MgrModel model;
    FolderModel folderModel;
    ComponentTableModel componentModel;
    DynamicTableModel dynamicModel;
    Type[] includes;
    HashMap<BComponent, BComponent> subscription = new HashMap();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMgrTable() {
    }

    public BMgrTable(MgrModel model) {
        this.manager = model.getManager();
        this.model = model;
        this.componentModel = new Model();
        this.dynamicModel = new DynamicTableModel((TableModel)this.componentModel);
        this.folderModel = model instanceof FolderModel ? (FolderModel)model : null;
        this.setModel((TableModel)this.dynamicModel);
        this.setController(new Controller());
        this.setSelection(new Selection());
        this.setCellRenderer(new CellRenderer());
        this.columnsModified();
    }

    public BAbstractManager getManager() {
        return this.manager;
    }

    public MgrColumn columnIndexToMgrColumn(int column) {
        return this.model.cols[this.dynamicModel.toRootColumnIndex(column)];
    }

    @Override
    protected final boolean include(BComponent c) {
        for (int i = 0; i < this.includes.length; ++i) {
            if (!c.getType().is(this.includes[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reload() {
        BAbstractManager mgr = this.manager;
        this.setContainer(mgr.target);
        this.includes = this.model.getIncludeTypes();
        BComponent[] rows = this.resolve();
        this.subscribe(rows);
        Array accepted = new Array(BComponent.class, rows.length);
        for (int i = 0; i < rows.length; ++i) {
            if (!this.model.accept(rows[i]) || !rows[i].getPermissions(this.manager.getCurrentContext()).hasOperatorRead()) continue;
            accepted.add((Object)rows[i]);
        }
        rows = (BComponent[])accepted.trim();
        this.getSelection().deselectAll();
        this.componentModel.setRows(rows);
    }

    private BComponent[] resolve() {
        if (this.folderModel == null || !this.folderModel.isAllDescendants()) {
            return this.resolveFlat();
        }
        return this.resolveDeep();
    }

    private BComponent[] resolveFlat() {
        BComponent target = this.manager.target;
        Array acc = new Array(BComponent.class);
        SlotCursor c = target.getProperties();
        while (c.nextComponent()) {
            Property prop = c.property();
            BComponent comp = (BComponent)c.get();
            if (Flags.isHidden((BComplex)target, (Slot)prop) || !this.include(comp)) continue;
            acc.add((Object)comp);
        }
        return (BComponent[])acc.trim();
    }

    private BComponent[] resolveDeep() {
        BComponent target = this.manager.target;
        String bql = "bql:select slotPath from ";
        for (int i = 0; i < this.includes.length; ++i) {
            if (i > 0) {
                bql = bql + ", ";
            }
            bql = bql + this.includes[i];
        }
        BITable result = (BITable)BOrd.make((String)bql).get((BObject)target);
        try (TableCursor cursor = result.cursor();){
            ArrayList<BOrd> ords = new ArrayList<BOrd>();
            Column col = result.getColumns().get(0);
            while (cursor.next()) {
                ords.add(BOrd.make((String)cursor.cell(col).toString()));
            }
            BComponent[] bComponentArray = new BatchResolve(ords.toArray(new BOrd[0])).resolve((BObject)target).getTargetComponents();
            return bComponentArray;
        }
    }

    private void subscribe(BComponent[] rows) {
        BAbstractManager mgr = this.manager;
        BComponent target = mgr.target;
        Array list = new Array(BComponent.class);
        if (this.subscription.get(target) == null && target != null) {
            list.add((Object)target);
            this.subscription.put(target, target);
        }
        for (int i = 0; i < rows.length; ++i) {
            BComponent p = (BComponent)rows[i].getParent();
            if (this.subscription.get(p) != null || p == null) continue;
            list.add((Object)p);
            this.subscription.put(p, p);
        }
        if (list.size() == 0) {
            return;
        }
        BComponent[] toSub = (BComponent[])list.trim();
        int depth = this.model.getSubscribeDepth();
        mgr.registerForComponentEvents(toSub, depth);
    }

    public void columnsModified() {
        int i;
        ComponentTableModel.Column[] cols = new MgrColumnWrapper[this.model.cols.length];
        for (i = 0; i < cols.length; ++i) {
            cols[i] = new MgrColumnWrapper(this.model.cols[i]);
        }
        this.componentModel.setColumns(cols);
        for (i = 0; i < cols.length; ++i) {
            this.dynamicModel.setShowColumn(i, !this.model.cols[i].isUnseen());
        }
        this.dynamicModel.columnsModified();
        this.sizeColumnsToFit();
    }

    @Override
    public void handleComponentEvent(BComponentEvent event) {
        boolean reload = false;
        BValue value = null;
        switch (event.getId()) {
            case 1: {
                value = event.getValue();
                if (value == null || !(value instanceof BComponent) || this.manager.getLearn() != null && this.manager.getLearn().getJob() != null && !this.manager.getLearn().jobComplete && this.manager.getLearn().getJob() == event.getSourceComponent()) break;
                int depth = this.model.getSubscribeDepth() - 1;
                WbViewEventWorker.getInstance().registerForComponentEventsLater(this.manager, value.asComponent(), depth);
                reload = true;
                break;
            }
            case 0: 
            case 2: {
                value = event.getValue();
                if (value == null || !(value instanceof BComponent)) break;
                reload = true;
                break;
            }
            case 4: {
                reload = true;
            }
        }
        if (reload) {
            WbViewEventWorker.getInstance().reloadLater(this);
        }
        this.repaint();
    }

    @Override
    public CommandArtifact drop(TransferContext cx) throws Exception {
        this.dropActive = false;
        return this.getManager().getController().drop(this, cx);
    }

    CommandArtifact superDrop(TransferContext cx) throws Exception {
        return super.drop(cx);
    }

    class Selection
    extends ComponentTableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BMgrTable.this.manager.controller.updateCommands();
        }
    }

    class Controller
    extends ComponentTableController {
        Controller() {
        }

        @Override
        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
            BMgrTable.this.getManager().getController().cellDoubleClicked(BMgrTable.this, event, row, col);
        }

        @Override
        public BMenu makePopup(ComponentTableSubject subject) {
            BMenu menu = super.makePopup(subject);
            return BMgrTable.this.getManager().getController().makePopup(BMgrTable.this, subject, menu);
        }

        public BMenu makeOptionsMenu() {
            BMenu menu = super.makeOptionsMenu();
            return BMgrTable.this.getManager().getController().makeOptionsMenu(BMgrTable.this, menu);
        }
    }

    public class CellRenderer
    extends ComponentTableCellRenderer {
        @Override
        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BComponent row;
            if (BMgrTable.this.folderModel != null && (row = BMgrTable.this.getComponentAt(cell.row)).getType().is(BMgrTable.this.folderModel.getFolderType())) {
                return Theme.table().getGridBrush();
            }
            return super.getBackground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            TableCellRenderer r = BMgrTable.this.columnIndexToMgrColumn(cell.column).getCellRenderer();
            if (r != null) {
                return r.getPreferredCellWidth(cell);
            }
            return super.getPreferredCellWidth(cell);
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            TableCellRenderer r = BMgrTable.this.columnIndexToMgrColumn(cell.column).getCellRenderer();
            if (r != null) {
                r.paintCell(g, cell);
            } else {
                super.paintCell(g, cell);
            }
        }

        @Override
        public String getCellText(TableCellRenderer.Cell cell) {
            try {
                BComponent component = this.getComponentTable().getComponentModel().getComponentAt(cell.row);
                MgrColumn col = BMgrTable.this.columnIndexToMgrColumn(cell.column);
                return col.toDisplayString(component, cell.value, BMgrTable.this.manager.getCurrentContext());
            }
            catch (Exception e) {
                return "";
            }
        }
    }

    class Model
    extends ComponentTableModel {
        Model() {
        }

        @Override
        public synchronized void sortByColumn(int c, boolean ascending) {
            MgrColumn col = BMgrTable.this.model.cols[c];
            Object[] rows = this.getRows();
            Object[] keys = new Object[rows.length];
            for (int i = 0; i < keys.length; ++i) {
                try {
                    keys[i] = col.toSortKey(rows[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            SortUtil.sort((Object[])keys, (Object[])rows, (boolean)ascending);
            this.setRows((BComponent[])rows);
        }
    }

    static class MgrColumnWrapper
    implements ComponentTableModel.Column {
        MgrColumn mgrCol;

        MgrColumnWrapper(MgrColumn mgrCol) {
            this.mgrCol = mgrCol;
        }

        @Override
        public String getName() {
            return this.mgrCol.getDisplayName();
        }

        @Override
        public Object getValue(BComponent c) {
            try {
                return this.mgrCol.get(c);
            }
            catch (Exception e) {
                return "";
            }
        }
    }
}

