/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.sys.tag.ComponentTags;
import com.tridium.workbench.fieldeditors.BStringFE;
import com.tridium.workbench.fieldeditors.BStringMgrColFE;
import java.util.Optional;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;
import javax.baja.tag.TagInfo;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

public abstract class MgrColumn {
    public static final int EDITABLE = 1;
    public static final int UNSEEN = 2;
    public static final int READONLY = 4;
    BAbstractManager manager;
    String displayName;
    int flags;
    BImage columnIcon = BImage.make((String)"module://icons/x16/object.png");

    protected MgrColumn(String displayName) {
        this(displayName, 0);
    }

    protected MgrColumn(String displayName, int flags) {
        this.displayName = displayName;
        this.flags = flags;
    }

    protected MgrColumn(String displayName, int flags, BImage columnIcon) {
        this.displayName = displayName;
        this.flags = flags;
        this.columnIcon = columnIcon;
    }

    void init(BAbstractManager manager) {
        if (this.manager != null && this.manager != manager) {
            throw new IllegalStateException("MgrColumns cannot shared between manager instances");
        }
        this.manager = manager;
    }

    public BAbstractManager getManager() {
        return this.manager;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public abstract Object get(Object var1);

    public Object toSortKey(Object row) {
        return this.get(row);
    }

    public String toDisplayString(Object row, Object value, Context cx) {
        if (value instanceof BObject) {
            return ((BObject)value).toString(this.manager.getCurrentContext());
        }
        return String.valueOf(value);
    }

    public TableCellRenderer getCellRenderer() {
        return null;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean isEditable() {
        return (this.flags & 1) != 0;
    }

    public boolean isUnseen() {
        return (this.flags & 2) != 0;
    }

    public boolean isReadonly() {
        return (this.flags & 4) != 0;
    }

    public void setHidden() {
        this.flags = (this.flags | 2) & 0xFFFFFFFE;
    }

    public void setReadOnly() {
        this.flags |= 4;
    }

    public boolean isCellValid(MgrEditRow row) {
        return true;
    }

    public void setIcon(BImage columnIcon) {
        this.columnIcon = columnIcon;
    }

    public BImage getIcon() {
        return this.columnIcon;
    }

    public String toString() {
        return this.displayName + "[" + this.getClass().getName() + "]";
    }

    public BValue load(MgrEditRow row) throws Exception {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void save(MgrEditRow row, BValue value, Context cx) throws Exception {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
        return null;
    }

    public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public static BWbFieldEditor toFieldEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor, Property[] propPath) {
        BWbFieldEditor editor;
        BValue val = rows[0].getCell(colIndex);
        for (int i = 1; i < rows.length; ++i) {
            if (rows[i].getCell(colIndex).getClass() == val.getClass()) continue;
            return null;
        }
        BFacets facets = rows.length == 1 && propPath.length == 1 ? rows[0].getTarget().getSlotFacets((Slot)propPath[0]) : propPath[propPath.length - 1].getFacets();
        Context cx = rows[0].getManager().getCurrentContext();
        if (!facets.isNull()) {
            cx = new BasicContext(cx, facets);
        }
        if ((editor = BWbFieldEditor.makeFor((BObject)val, cx)) instanceof BStringFE) {
            editor = new BStringMgrColFE(colIndex);
        }
        if (currentEditor != null && ((Object)((Object)currentEditor)).getClass() == ((Object)((Object)editor)).getClass()) {
            editor = (BWbFieldEditor)currentEditor;
        }
        editor.loadValue((BObject)val, cx);
        return editor;
    }

    public static BWbFieldEditor toFieldEditor(javax.baja.sys.Type mixinType, MgrEditRow[] rows, int colIndex, BWbEditor currentEditor, Property[] propPath) {
        BWbFieldEditor editor;
        BValue val = rows[0].getCell(colIndex);
        for (int i = 1; i < rows.length; ++i) {
            if (rows[i].getCell(colIndex).getClass() == val.getClass()) continue;
            return null;
        }
        BFacets facets = rows.length == 1 && propPath.length == 1 ? ((BComponent)rows[0].getTarget().getMixIn(mixinType)).getSlotFacets((Slot)propPath[0]) : propPath[propPath.length - 1].getFacets();
        Context cx = rows[0].getManager().getCurrentContext();
        if (!facets.isNull()) {
            cx = new BasicContext(cx, facets);
        }
        if ((editor = BWbFieldEditor.makeFor((BObject)val, cx)) instanceof BStringFE) {
            editor = new BStringMgrColFE(colIndex);
        }
        if (currentEditor != null && ((Object)((Object)currentEditor)).getClass() == ((Object)((Object)editor)).getClass()) {
            editor = (BWbFieldEditor)currentEditor;
        }
        editor.loadValue((BObject)val, cx);
        return editor;
    }

    public static void fromFieldEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget, Property[] propPath) throws Exception {
        BWbFieldEditor editor = (BWbFieldEditor)widget;
        BValue val = (BValue)editor.saveValue();
        for (int i = 0; i < rows.length; ++i) {
            rows[i].setCell(colIndex, val);
        }
    }

    public static class TagInfoColumn
    extends MgrColumn {
        protected Tag compTag;

        public TagInfoColumn(TagInfo tag, int flags) {
            super(tag.getTagId().getName(), flags, BImage.make((String)"module://icons/x16/tag.png"));
        }

        @Override
        public Object get(Object row) {
            BComponent parent = (BComponent)row;
            Optional tarValue = parent.tags().get(this.compTag.getId());
            if (tarValue.isPresent()) {
                return tarValue.get();
            }
            return this.compTag.getValue();
        }

        @Override
        public String toDisplayString(Object row, Object value, Context cx) {
            return value == null ? "-" : value.toString();
        }

        @Override
        public boolean isCellValid(MgrEditRow row) {
            try {
                return row.getTarget().tags().get(this.compTag.getId()).isPresent();
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public BValue load(MgrEditRow row) {
            BString value = BString.make((String)"-");
            try {
                value = row.getTarget().tags().get(this.compTag.getId()).map(dv -> (BValue)dv.as(BValue.class)).orElse((BValue)value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return value;
        }

        @Override
        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent parent = row.getTarget();
            parent.tags().remove(this.compTag);
            parent.tags().set(new Tag(this.compTag.getId(), (BIDataValue)value.as(BIDataValue.class)));
        }

        @Override
        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BValue val = rows[0].getCell(colIndex);
            if (val == null) {
                return null;
            }
            for (int i = 1; i < rows.length; ++i) {
                if (rows[i].getCell(colIndex).getClass() == val.getClass()) continue;
                return null;
            }
            BValue editValue = val;
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)editValue);
            editor.loadValue((BObject)editValue.newCopy());
            return editor;
        }

        @Override
        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BValue val = (BValue)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, val.newCopy());
            }
        }
    }

    public static class TagColumn
    extends MgrColumn {
        protected Tag compTag;

        public TagColumn(Tag tag, int flags) {
            super(tag.getId().getName(), flags, BImage.make((String)"module://icons/x16/tag.png"));
            this.compTag = tag;
        }

        public Tag getTag() {
            return this.compTag;
        }

        public void setTag(Tag compTag) {
            this.compTag = compTag;
        }

        @Override
        public Object get(Object row) {
            BComponent parent = (BComponent)row;
            Optional tarValue = parent.tags().get(this.compTag.getId());
            if (tarValue.isPresent()) {
                return tarValue.get();
            }
            return this.compTag.getValue();
        }

        @Override
        public String toDisplayString(Object row, Object value, Context cx) {
            return value == null ? "-" : value.toString();
        }

        @Override
        public boolean isCellValid(MgrEditRow row) {
            try {
                Property tagProp;
                Id id = this.compTag.getId();
                if (new ComponentTags(row.getTarget()).get(id).isPresent() && ((tagProp = row.getTarget().getProperty(SlotPath.escape((String)id.getQName()))) == null || !Flags.isReadonly((BComplex)row.getTarget(), (Slot)tagProp) && !Flags.isHidden((BComplex)row.getTarget(), (Slot)tagProp))) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        @Override
        public BValue load(MgrEditRow row) {
            BString value = BString.make((String)"-");
            try {
                value = row.getTarget().tags().get(this.compTag.getId()).map(dv -> (BValue)dv.as(BValue.class)).orElse((BValue)value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return value;
        }

        @Override
        public void save(MgrEditRow row, BValue value, Context cx) {
            String tagPropName;
            BComponent parent = row.getTarget();
            Property tagProp = parent.getProperty(tagPropName = SlotPath.escape((String)this.compTag.getId().getQName()));
            if (tagProp != null && !Flags.isReadonly((BComplex)parent, (Slot)tagProp) && !Flags.isHidden((BComplex)parent, (Slot)tagProp)) {
                int originalFlags = parent.getFlags((Slot)tagProp);
                BFacets originalFacets = parent.getSlotFacets((Slot)tagProp);
                parent.tags().remove(this.compTag);
                parent.tags().set(new Tag(this.compTag.getId(), (BIDataValue)value.as(BIDataValue.class)));
                tagProp = parent.getProperty(tagPropName);
                if (tagProp != null) {
                    parent.setFlags((Slot)tagProp, originalFlags);
                    parent.setFacets((Slot)tagProp, originalFacets);
                }
            }
        }

        @Override
        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BValue val = rows[0].getCell(colIndex);
            if (val == null) {
                return null;
            }
            for (int i = 1; i < rows.length; ++i) {
                if (rows[i].getCell(colIndex).getClass() == val.getClass()) continue;
                return null;
            }
            BValue editValue = val;
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)editValue);
            editor.loadValue((BObject)editValue.newCopy());
            return editor;
        }

        @Override
        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BValue val = (BValue)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, val.newCopy());
            }
        }
    }

    public static class MixIn
    extends MgrColumn {
        javax.baja.sys.Type type;

        public MixIn(javax.baja.sys.Type type) {
            super(((BIMixIn)type.getInstance()).getDisplayNameInParent(null), 1);
            this.type = type;
        }

        @Override
        public Object get(Object row) {
            BComponent parent = (BComponent)row;
            return parent.getMixIn(this.type);
        }

        @Override
        public String toDisplayString(Object row, Object value, Context cx) {
            return value == null ? "-" : value.toString();
        }

        @Override
        public BValue load(MgrEditRow row) {
            BValue value = row.getTarget().getMixIn(this.type);
            if (value == null) {
                value = (BValue)this.type.getInstance();
            }
            return value;
        }

        @Override
        public void save(MgrEditRow row, BValue value, Context cx) {
            String propName;
            BComponent parent = row.getTarget();
            Property prop = parent.getProperty(propName = this.type.toString().replace(':', '_'));
            if (prop == null) {
                parent.add(propName, value, cx);
            } else {
                parent.set(prop, value, cx);
            }
        }

        @Override
        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BComponent parent;
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor(this.type.getInstance());
            }
            BValue val = null;
            for (int i = 0; i < rows.length && (val = (parent = rows[i].getTarget()).getMixIn(this.type)) == null; ++i) {
            }
            if (val == null) {
                val = (BValue)this.type.getInstance();
            }
            editor.loadValue((BObject)val.newCopy());
            return editor;
        }

        @Override
        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BValue val = (BValue)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, val.newCopy());
            }
        }
    }

    public static class MixinProp
    extends PropPath {
        javax.baja.sys.Type mixinType;

        public MixinProp(javax.baja.sys.Type mixinType, String name, Property prop, int flags) {
            this(mixinType, name, new Property[]{prop}, flags);
        }

        public MixinProp(javax.baja.sys.Type mixinType, String name, Property[] props, int flags) {
            super(name, props, flags);
            this.mixinType = mixinType;
        }

        public MixinProp(javax.baja.sys.Type mixinType, Property prop, int flags) {
            this(mixinType, new Property[]{prop}, flags);
        }

        public MixinProp(javax.baja.sys.Type mixinType, Property[] props, int flags) {
            this(mixinType, props[props.length - 1].getDefaultDisplayName(null), props, flags);
        }

        public MixinProp(javax.baja.sys.Type mixinType, Property prop) {
            this(mixinType, new Property[]{prop});
        }

        public MixinProp(javax.baja.sys.Type mixinType, Property[] props) {
            this(mixinType, props, 0);
        }

        @Override
        protected BComplex getRowBase(Object row) {
            BComponent parent = (BComponent)row;
            return (BComplex)parent.getMixIn(this.mixinType);
        }

        @Override
        protected BComplex getTargetBase(MgrEditRow row) {
            BComponent parent = row.getTarget();
            BComplex result = (BComplex)parent.getMixIn(this.mixinType);
            if (result == null) {
                result = (BComplex)this.mixinType.getInstance();
                parent.add(this.mixinType.toString().replace(':', '_'), (BValue)result);
            }
            return result;
        }
    }

    public static class PropString
    extends MgrColumn {
        int flags;
        String propString;

        public PropString(String propString, int flags) {
            super(propString, flags);
            this.propString = propString;
            this.flags = flags;
        }

        public PropString(String displayName, String propString, int flags) {
            super(displayName, flags);
            this.propString = propString;
            this.flags = flags;
        }

        @Override
        public Object get(Object row) {
            BComplex val = (BComplex)row;
            return val.get(this.propString);
        }

        @Override
        public String toDisplayString(Object row, Object value, Context cx) {
            BComplex val = (BComplex)row;
            Property prop = val.getProperty(this.propString);
            if (prop == null) {
                return "-";
            }
            return ((BObject)value).toString(cx);
        }

        @Override
        public BValue load(MgrEditRow row) {
            BComponent val = row.getTarget();
            if ((val = ((BComplex)val).get(this.propString)) == null) {
                return null;
            }
            return val.newCopy();
        }

        @Override
        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent target = row.getTarget();
            BValue old = target.get(this.propString);
            if (value == null || old == null) {
                return;
            }
            if (!old.equivalent((Object)value)) {
                target.set(this.propString, value.newCopy());
            }
        }

        @Override
        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            return PropString.toFieldEditor(rows, colIndex, currentEditor, this.propString);
        }

        @Override
        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            PropString.fromFieldEditor(rows, colIndex, editor, this.propString);
        }

        public static BWbFieldEditor toFieldEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor, String propString) {
            BValue val = rows[0].getCell(colIndex);
            if (val == null) {
                return null;
            }
            for (int i = 1; i < rows.length; ++i) {
                if (rows[i].getCell(colIndex).getClass() == val.getClass()) continue;
                return null;
            }
            BFacets facets = null;
            facets = rows[0].getTarget().getSlotFacets((Slot)rows[0].getTarget().getProperty(propString));
            Context cx = rows[0].getManager().getCurrentContext();
            if (!facets.isNull()) {
                cx = new BasicContext(cx, facets);
            }
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)val, cx);
            if (currentEditor != null && ((Object)((Object)currentEditor)).getClass() == ((Object)((Object)editor)).getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)val, cx);
            return editor;
        }

        public static void fromFieldEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget, String propString) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BValue val = (BValue)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, val);
            }
        }
    }

    public static class PropPath
    extends MgrColumn {
        protected Property[] props;

        public PropPath(String name, Property[] props, int flags) {
            super(name, flags);
            this.props = props;
        }

        public PropPath(Property[] props, int flags) {
            this(props[props.length - 1].getDefaultDisplayName(null), props, flags);
        }

        public PropPath(Property[] props) {
            this(props, 0);
        }

        protected BComplex getRowBase(Object row) {
            return (BComplex)row;
        }

        @Override
        public Object get(Object row) {
            BComplex val = this.getRowBase(row);
            for (int i = 0; i < this.props.length - 1; ++i) {
                val = (BComplex)val.get(this.props[i]);
            }
            Property prop = this.props[this.props.length - 1];
            return val.get(prop);
        }

        @Override
        public String toDisplayString(Object row, Object value, Context cx) {
            BComplex val = this.getRowBase(row);
            for (int i = 0; i < this.props.length - 1; ++i) {
                val = (BComplex)val.get(this.props[i]);
            }
            Property prop = this.props[this.props.length - 1];
            BFacets facets = val.getSlotFacets((Slot)prop);
            if (!facets.isNull()) {
                cx = new BasicContext(cx, facets);
            }
            return ((BObject)value).toString(cx);
        }

        protected BComplex getTargetBase(MgrEditRow row) {
            return row.getTarget();
        }

        @Override
        public BValue load(MgrEditRow row) {
            BComplex val = this.getTargetBase(row);
            for (int i = 0; i < this.props.length; ++i) {
                val = val.get(this.props[i]);
            }
            return val.newCopy();
        }

        @Override
        public void save(MgrEditRow row, BValue value, Context cx) {
            BComplex target = this.getTargetBase(row);
            int len = this.props.length;
            for (int i = 0; i < len - 1; ++i) {
                target = (BComplex)target.get(this.props[i]);
            }
            Property prop = this.props[len - 1];
            BValue old = target.get(prop);
            if (!old.equivalent((Object)value)) {
                target.set(prop, value.newCopy(), cx);
            }
        }

        @Override
        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            return PropPath.toFieldEditor(rows, colIndex, currentEditor, this.props);
        }

        @Override
        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            PropPath.fromFieldEditor(rows, colIndex, editor, this.props);
        }
    }

    public static class Prop
    extends MgrColumn {
        protected Property prop;
        protected Property[] props;

        public Prop(String name, Property prop, int flags) {
            super(name, flags);
            this.prop = prop;
            this.props = new Property[]{prop};
        }

        public Prop(Property prop, int flags) {
            this(prop.getDefaultDisplayName(null), prop, flags);
        }

        public Prop(Property prop) {
            this(prop, 0);
        }

        @Override
        public Object get(Object row) {
            BComplex complex = (BComplex)row;
            return complex.get(this.prop);
        }

        @Override
        public String toDisplayString(Object row, Object value, Context cx) {
            BComplex complex = (BComplex)row;
            BFacets facets = complex.getSlotFacets((Slot)this.prop);
            if (!facets.isNull()) {
                cx = new BasicContext(cx, facets);
            }
            return ((BObject)value).toString(cx);
        }

        @Override
        public BValue load(MgrEditRow row) {
            return row.getTarget().get(this.prop).newCopy();
        }

        @Override
        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent target = row.getTarget();
            BValue old = target.get(this.prop);
            if (!old.equivalent((Object)value)) {
                target.set(this.prop, value.newCopy(), cx);
            }
        }

        @Override
        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            return Prop.toFieldEditor(rows, colIndex, currentEditor, this.props);
        }

        @Override
        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            Prop.fromFieldEditor(rows, colIndex, editor, this.props);
        }
    }

    public static class ToString
    extends MgrColumn {
        public ToString(String displayName, int flags) {
            super(displayName, flags);
        }

        @Override
        public Object get(Object row) {
            return ((BComponent)row).toString(null);
        }
    }

    public static class Path
    extends MgrColumn {
        public Path(int flags) {
            super(UiLexicon.bajaui().getText("path"), flags);
        }

        @Override
        public Object get(Object row) {
            return ((BComponent)row).getSlotPath().toDisplayString();
        }
    }

    public static class Type
    extends MgrColumn {
        public Type() {
            super(UiLexicon.bajaui().getText("type"), 1);
        }

        public Type(int flags) {
            super(UiLexicon.bajaui().getText("type"), flags);
        }

        @Override
        public Object get(Object row) {
            return this.getManager().getModel().toType((BComponent)row);
        }

        @Override
        public String toDisplayString(Object row, Object value, Context cx) {
            if (value instanceof BFacets) {
                BFacets dummy = (BFacets)value;
                return dummy.getPickle().toString();
            }
            return String.valueOf(value);
        }

        @Override
        public BValue load(MgrEditRow row) {
            BComponent target = row.getTarget();
            MgrTypeInfo type = target != null ? this.getManager().getModel().toType(target) : row.getAvailableTypes()[0];
            BFacets dummy = BFacets.makePickle((BFacets)BFacets.make((String)"x", (BIDataValue)BBoolean.TRUE), (Object)type);
            return dummy;
        }

        @Override
        public void save(MgrEditRow row, BValue value, Context cx) {
        }

        @Override
        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            int i;
            MgrTypeInfo[] types = MgrEdit.getTypeIntersection(rows);
            if (types.length == 0) {
                return null;
            }
            int curIndex = 0;
            if (rows.length > 0) {
                MgrTypeInfo curType = rows[0].getType();
                for (i = 0; i < types.length; ++i) {
                    if (!curType.equals(types[i])) continue;
                    curIndex = i;
                    break;
                }
            }
            String[] tags = new String[types.length];
            for (i = 0; i < tags.length; ++i) {
                tags[i] = SlotPath.escape((String)types[i].getDisplayName());
            }
            BDynamicEnum choices = BDynamicEnum.make((int)curIndex, (BEnumRange)BEnumRange.make((String[])tags));
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor((BObject)choices);
            }
            editor.loadValue((BObject)choices);
            return editor;
        }

        @Override
        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BDynamicEnum choices = (BDynamicEnum)editor.saveValue();
            String name = choices.getDisplayTag(null);
            MgrTypeInfo[] types = MgrEdit.getTypeIntersection(rows);
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].getDisplayName().equals(name)) continue;
                for (int j = 0; j < rows.length; ++j) {
                    rows[j].setType(types[i]);
                }
                return;
            }
            throw new IllegalStateException();
        }
    }

    public static class Name
    extends MgrColumn {
        public Name() {
            super(UiLexicon.bajaui().getText("name"), 1);
        }

        public Name(int flags) {
            super(UiLexicon.bajaui().getText("name"), flags);
        }

        @Override
        public Object get(Object row) {
            return ((BComponent)row).getDisplayName(null);
        }

        @Override
        public String toDisplayString(Object row, Object value, Context cx) {
            try {
                return SlotPath.unescape((String)value.toString());
            }
            catch (Exception e) {
                return String.valueOf(value);
            }
        }

        @Override
        public BValue load(MgrEditRow row) {
            String name = row.getTarget().getName();
            if (name != null) {
                return BString.make((String)name);
            }
            return BString.DEFAULT;
        }

        @Override
        public void save(MgrEditRow row, BValue value, Context cx) {
        }

        @Override
        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows.length != 1) {
                return null;
            }
            Property propInParent = rows[0].getTarget().getPropertyInParent();
            if (null != propInParent && propInParent.isFrozen()) {
                return null;
            }
            BString name = (BString)rows[0].getCell(colIndex);
            BString displayName = BString.make((String)SlotPath.unescape((String)name.toString()));
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor((BObject)displayName);
            }
            BFacets facets = BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)30));
            editor.loadValue((BObject)displayName, (Context)facets);
            return editor;
        }

        @Override
        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BString displayName = (BString)editor.saveValue();
            BString name = BString.make((String)SlotPath.escape((String)displayName.toString()));
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, (BValue)name);
                rows[i].userDefinedName = name.toString();
            }
        }
    }
}

