/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.workbench.fieldeditors.BIntegerFE;
import javax.baja.data.BIDataValue;
import javax.baja.job.BJob;
import javax.baja.naming.SlotPath;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.tag.Entity;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.component.table.ComponentTableSubject;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.BTemplateTable;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrSupport;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class MgrController
extends MgrSupport {
    public static final int MENU_BAR = 1;
    public static final int TOOL_BAR = 2;
    public static final int ACTION_BAR = 4;
    public static final int POPUP = 8;
    public static final int LEARN_POPUP = 16;
    public static final int BARS = 7;
    static final int[] emptySelection = new int[0];
    static final BComponent[] emptyComponentTable = new BComponent[0];
    public static final Context quickContext = new BasicContext();
    final Lexicon lex = Lexicon.make(MgrController.class);
    static boolean quickCommandsEnabled = true;
    IMgrCommand[] commands;
    IMgrCommand[] baseCommands;
    IMgrCommand[] tagCommands;
    IMgrCommand[] templateCommands;
    public final MgrCommand newCommand;
    public final MgrCommand edit;
    public final MgrToggleCommand learnMode;
    public final MgrToggleCommand tagMode;
    public final MgrToggleCommand templateMode;
    public final MgrCommand discover;
    public final MgrCommand cancel;
    public final MgrCommand add;
    public final MgrCommand match;
    public final MgrCommand quickAdd;
    public final MgrCommand quickMatch;
    public final MgrCommand tagIt;
    public final MgrCommand deploy;

    public MgrController(BAbstractManager manager) {
        super(manager);
        this.newCommand = new New(manager);
        this.edit = new Edit(manager);
        this.learnMode = new LearnMode(manager);
        this.tagMode = new TagMode(manager);
        this.templateMode = new TemplateMode(manager);
        this.discover = new Discover(manager);
        this.cancel = new Cancel(manager);
        this.add = new Add(manager);
        this.match = new Match(manager);
        this.quickAdd = new QuickAdd(manager);
        this.quickMatch = new QuickMatch(manager);
        this.tagIt = new TagIt(manager);
        this.deploy = new Deploy(manager);
        this.newCommand.setFlags(15);
        this.edit.setFlags(15);
        if (manager.isLearnable()) {
            this.learnMode.setFlags(3);
            this.discover.setFlags(7);
            this.cancel.setFlags(7);
            this.add.setFlags(23);
            this.quickAdd.setFlags(1);
            this.match.setFlags(23);
            this.quickMatch.setFlags(1);
        }
        if (manager.isTaggable()) {
            this.tagMode.setFlags(3);
            this.tagIt.setFlags(7);
        }
        if (manager.isTemplatable()) {
            this.templateMode.setFlags(3);
            this.templateMode.setEnabled(false);
        }
    }

    @Override
    public void init() {
        this.updateCommands();
    }

    public BToolBar makeToolBar() {
        BToolBar toolBar = new BToolBar();
        IMgrCommand[] cmds = this.getCommands();
        for (int i = 0; i < cmds.length; ++i) {
            IMgrCommand cmd = cmds[i];
            if ((cmd.getFlags() & 2) == 0) continue;
            String name = "cmd" + i;
            toolBar.add(name, (Command)cmd);
            BAbstractButton b = (BAbstractButton)toolBar.get(name);
            IMgrCommand[] drop = this.getDropDownCommands(cmd);
            if (drop == null || drop.length <= 0) continue;
            b.setMenuController((BAbstractButton.MenuController)new MenuController());
        }
        return toolBar;
    }

    public BMenu[] makeMenus() {
        BMenu menu = new BMenu(this.lex.getText("manager"));
        IMgrCommand[] cmds = this.getCommands();
        for (int i = 0; i < cmds.length; ++i) {
            if ((cmds[i].getFlags() & 1) == 0) continue;
            menu.add("cmd" + i, (Command)cmds[i]);
        }
        return new BMenu[]{menu};
    }

    public BWidget makeActionBar() {
        return this.makeActionPane(this.getCommands());
    }

    protected BWidget makeActionPane(IMgrCommand[] cmds) {
        if (cmds.length == 0) {
            return new BNullWidget();
        }
        int n = 0;
        BGridPane pane = new BGridPane();
        for (int i = 0; i < cmds.length; ++i) {
            IMgrCommand cmd = cmds[i];
            if ((cmd.getFlags() & 4) == 0) continue;
            BAbstractButton b = BAbstractButton.make((Command)((Command)cmd));
            IMgrCommand[] drop = this.getDropDownCommands(cmd);
            if (drop != null && drop.length > 0) {
                b.setMenuController((BAbstractButton.MenuController)new MenuController());
            }
            pane.add("cmd" + i, (BValue)b);
            ++n;
        }
        pane.setColumnCount(n);
        return pane;
    }

    public IMgrCommand[] getDropDownCommands(IMgrCommand command) {
        return null;
    }

    public final IMgrCommand[] getCommands() {
        if (this.baseCommands == null) {
            this.baseCommands = this.makeCommands();
        }
        if (this.tagCommands == null) {
            this.tagCommands = this.makeTagCommands();
        }
        if (this.templateCommands == null) {
            this.templateCommands = this.makeTemplateCommands();
        }
        if (this.commands == null) {
            this.commands = MgrController.append(this.baseCommands, this.tagCommands);
            this.commands = MgrController.append(this.commands, this.templateCommands);
        }
        return (IMgrCommand[])this.commands.clone();
    }

    public final int getCommandCount() {
        return this.commands.length;
    }

    public final IMgrCommand getCommand(int index) {
        if (this.baseCommands == null) {
            this.baseCommands = this.makeCommands();
        }
        if (this.tagCommands == null) {
            this.tagCommands = this.makeTagCommands();
        }
        if (this.templateCommands == null) {
            this.templateCommands = this.makeTemplateCommands();
        }
        if (this.commands == null) {
            this.commands = MgrController.append(this.baseCommands, this.tagCommands);
            this.commands = MgrController.append(this.commands, this.templateCommands);
        }
        return this.commands[index];
    }

    protected IMgrCommand[] makeCommands() {
        return new IMgrCommand[]{this.newCommand, this.edit, this.learnMode, this.discover, this.cancel, this.add, this.quickAdd, this.match, this.quickMatch, this.templateMode};
    }

    protected IMgrCommand[] makeTagCommands() {
        return new IMgrCommand[]{this.tagMode, this.tagIt};
    }

    protected IMgrCommand[] makeTemplateCommands() {
        return new IMgrCommand[0];
    }

    public static IMgrCommand[] append(IMgrCommand[] a, IMgrCommand[] b) {
        IMgrCommand[] r = new IMgrCommand[a.length + b.length];
        System.arraycopy(a, 0, r, 0, a.length);
        System.arraycopy(b, 0, r, a.length, b.length);
        return r;
    }

    public void setQuickCommandsEnabled(boolean enabled) {
        quickCommandsEnabled = enabled;
        this.updateCommands();
    }

    public void updateCommands() {
        int[] sel = this.getSelectedRows();
        this.edit.setEnabled(sel.length > 0);
        if (this.manager.learn != null) {
            BJob job = this.manager.learn.getJob();
            this.discover.setEnabled(job == null || !job.getJobState().isRunning());
            this.cancel.setEnabled(job != null && job.getJobState().isRunning());
        } else {
            this.discover.setEnabled(false);
            this.cancel.setEnabled(false);
        }
        if (this.learnMode.isSelected()) {
            int[] learnSel = this.getLearnSelectedRows();
            this.add.setEnabled(learnSel.length > 0);
            this.match.setEnabled(this.checkMatch(learnSel, sel));
            this.quickAdd.setEnabled(this.add.isEnabled() && quickCommandsEnabled);
            this.quickMatch.setEnabled(this.match.isEnabled() && quickCommandsEnabled);
        } else {
            this.add.setEnabled(false);
            this.match.setEnabled(false);
            this.quickAdd.setEnabled(false);
            this.quickMatch.setEnabled(false);
        }
        if (this.tagMode.isSelected()) {
            Object[] tagSel = this.manager.getMgrTagDictionary().getSelectedObjects();
            this.tagIt.setEnabled(this.checkTag(tagSel, sel));
        } else {
            this.tagIt.setEnabled(false);
        }
    }

    private boolean checkMatch(int[] learnSel, int[] dbSel) {
        try {
            if (learnSel.length == 1 && dbSel.length == 1) {
                Object dis = this.getLearnTable().getObjectAt(learnSel[0]);
                BComponent db = this.getTable().getComponentModel().getComponentAt(dbSel[0]);
                return this.manager.getLearn().isMatchable(dis, db);
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean checkTag(Object[] tagSel, int[] dbSel) {
        if (tagSel.length == 0 || dbSel.length == 0) {
            return false;
        }
        for (int t = 0; t < tagSel.length; ++t) {
            Object tagObject = tagSel[t];
            for (int d = 0; d < dbSel.length; ++d) {
                BComponent dbObject = this.getTable().getComponentModel().getComponentAt(dbSel[d]);
                if (tagObject instanceof TagInfo) {
                    if (this.getManager().getMgrTagDictionary().isTaggable((TagInfo)tagObject, (Entity)dbObject)) continue;
                    return false;
                }
                if (tagObject instanceof TagGroupInfo) {
                    if (this.getManager().getMgrTagDictionary().isTaggable((TagGroupInfo)tagObject, (Entity)dbObject)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public MgrEdit makeEdit(String label) {
        return new MgrEdit(this.getManager(), label);
    }

    public final BMgrTable getTable() {
        return this.manager.model.table;
    }

    public final BLearnTable getLearnTable() {
        if (this.manager.learn == null) {
            return null;
        }
        return this.manager.learn.table;
    }

    public final BTemplateTable getDevTemplateTable() {
        if (this.manager.template == null) {
            return null;
        }
        return this.manager.template.table;
    }

    public final int[] getSelectedRows() {
        BMgrTable table = this.getTable();
        if (table == null) {
            return emptySelection;
        }
        return table.getSelection().getRows();
    }

    public void learnSelectionChanged() {
        if (this.manager.template != null) {
            this.manager.template.learnSelected();
        }
    }

    public int[] getLearnSelectedRows() {
        BLearnTable table = this.getLearnTable();
        if (table == null) {
            return emptySelection;
        }
        return table.getSelection().getRows();
    }

    public void tagSelectionChanged() {
        this.updateCommands();
    }

    public void dbSelectionChanged() {
        this.updateCommands();
    }

    public final BComponent[] getSelectedComponents() {
        BMgrTable table = this.getTable();
        if (table == null) {
            return emptyComponentTable;
        }
        return table.getSelectedComponents();
    }

    public BMenu makePopup(BMgrTable table, ComponentTableSubject subject, BMenu menu) {
        if (menu == null) {
            menu = new BMenu();
        }
        menu.add(null, (BValue)new BSeparator());
        IMgrCommand[] cmds = this.getCommands();
        for (int i = 0; i < cmds.length; ++i) {
            IMgrCommand cmd = cmds[i];
            if ((cmd.getFlags() & 8) == 0) continue;
            menu.add("mgr_" + cmd.getName(), (Command)cmd);
        }
        return menu;
    }

    public BMenu makePopup(BLearnTable table, TreeTableSubject subject, BMenu menu) {
        if (menu == null) {
            menu = new BMenu();
        }
        IMgrCommand[] cmds = this.getCommands();
        for (int i = 0; i < cmds.length; ++i) {
            IMgrCommand cmd = cmds[i];
            if ((cmd.getFlags() & 0x10) == 0) continue;
            menu.add("mgr_" + cmd.getName(), (Command)cmd);
        }
        if (subject.size() == 1) {
            BComponent existing = this.getManager().getLearn().getExisting(subject.get(0));
            menu.add("existing", (Command)new ShowExisting((BWidget)table, existing));
        }
        menu.add("selectAll", (Command)new SelectAll(table));
        return menu;
    }

    public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
        if (this.edit.isEnabled()) {
            this.manager.setMgrEditState(2);
            this.edit.invoke();
            this.manager.setMgrEditState(0);
        }
    }

    public void cellDoubleClicked(BLearnTable table, BMouseEvent event, int row, int col) {
        if (this.add.isEnabled()) {
            this.manager.setMgrEditState(1);
            this.add.invoke();
            this.manager.setMgrEditState(0);
        }
    }

    public void cellDoubleClicked(BTreeTable table, BMouseEvent event, int row, int col) {
        if (this.tagIt.isEnabled()) {
            this.tagIt.invoke();
        }
    }

    public void cellDoubleClicked(BTemplateTable table, BMouseEvent event, int row, int col) {
        if (this.deploy.isEnabled()) {
            this.deploy.invoke();
        }
    }

    public BMenu makeOptionsMenu(BMgrTable table, BMenu menu) {
        return menu;
    }

    public BMenu makeOptionsMenu(BLearnTable table, BMenu menu) {
        return menu;
    }

    public BMenu makeOptionsMenu(BTemplateTable table, BMenu menu) {
        return menu;
    }

    public CommandArtifact drop(BMgrTable table, TransferContext cx) throws Exception {
        try {
            BAbstractManager mgr = this.getManager();
            String data = (String)cx.getEnvelope().getData(TransferFormat.string);
            if (data.equals("dragFromLearn:" + mgr.hashCode())) {
                return this.add.doInvoke();
            }
            if (data.equals("dragFromTag:" + mgr.hashCode())) {
                return this.add.doInvoke();
            }
            if (data.equals("dragFromTemplate:" + mgr.hashCode())) {
                return this.deploy.doInvoke();
            }
            if (data.startsWith("file:") && data.endsWith(".ntpl")) {
                return this.doDeploy((Context)cx);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return table.superDrop(cx);
    }

    public void doLearnMode(boolean learnMode) {
        this.manager.updateContent();
        this.updateCommands();
    }

    public void doTagMode(boolean tagMode) {
        this.manager.updateContent();
        this.updateCommands();
    }

    public void doTemplateMode(boolean templateMode) {
        this.manager.updateContent();
        this.updateCommands();
    }

    public CommandArtifact doDiscover(Context cx) throws Exception {
        this.learnMode.setSelected(true);
        return null;
    }

    public CommandArtifact doCancel(Context cx) throws Exception {
        BJob job;
        if (this.manager.getLearn() != null && (job = this.manager.getLearn().getJob()) != null) {
            job.cancel();
        }
        return null;
    }

    public CommandArtifact doNew(Context cx) throws Exception {
        MgrEdit edit = this.promptForNew(cx);
        if (edit == null) {
            return null;
        }
        return edit.invoke(null);
    }

    public MgrEdit promptForNew(Context cx) throws Exception {
        MgrModel model = this.manager.getModel();
        MgrTypeInfo[] types = model.getNewTypes();
        if (types == null) {
            BDialog.error((BWidget)this.manager, (Object)"Must override MgrModel.getNewTypes()");
            return null;
        }
        MgrTypeInfo.markDuplicates(types);
        BListDropDown typeField = new BListDropDown();
        for (int i = 0; i < types.length; ++i) {
            typeField.getList().addItem(types[i].getIcon(), (Object)types[i]);
        }
        typeField.setSelectedIndex(0);
        BIntegerFE countField = new BIntegerFE();
        countField.loadValue((BObject)BInteger.make((int)1), (Context)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1), (String)"max", (BIDataValue)BInteger.make((int)model.getMaxNewInstances()), (String)"fieldWidth", (BIDataValue)BInteger.make((int)3)));
        BGridPane grid = new BGridPane(2);
        grid.add(null, (BValue)new BLabel(this.lex.getText("add.type")));
        grid.add(null, (BValue)typeField);
        grid.add(null, (BValue)new BLabel(this.lex.getText("add.count")));
        grid.add(null, (BValue)countField);
        String title = this.newCommand.getLabel();
        int r = BDialog.open((BWidget)this.manager, (String)title, (Object)grid, (int)3);
        if (r == 2) {
            return null;
        }
        MgrTypeInfo type = (MgrTypeInfo)typeField.getSelectedItem();
        int count = ((BInteger)countField.saveValue()).getInt();
        MgrEdit edit = this.makeEdit(title);
        for (int i = 0; i < count; ++i) {
            edit.addRow(edit.makeRow(model.newInstance(type), null, types));
        }
        return edit;
    }

    public CommandArtifact doEdit(Context cx) throws Exception {
        BComponent[] sel = this.getSelectedComponents();
        if (sel.length == 0) {
            return null;
        }
        MgrEdit edit = this.makeEdit(this.edit.getLabel());
        for (int i = 0; i < sel.length; ++i) {
            edit.addRow(sel[i]);
        }
        edit.setSelectAll(true);
        return edit.invoke(cx);
    }

    public CommandArtifact doAdd(Context cx) throws Exception {
        Object[] templates;
        Object[] dis;
        if (this.manager.getLearn() != null && this.getLearnTable().getSelectedObjects().length > 0 && (dis = this.getLearnTable().getSelectedObjects()).length > 0) {
            return this.doAdd(dis, cx);
        }
        if (this.manager.getMgrTemplate() != null && (templates = this.manager.template.table.getSelectedObjects()).length > 0) {
            return this.doAddTemplates(templates, cx);
        }
        return null;
    }

    protected CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
        MgrEdit edit = this.makeEdit(this.add.getLabel());
        for (int i = 0; i < discovery.length; ++i) {
            Object dis = discovery[i];
            MgrTypeInfo[] types = this.manager.getLearn().toTypes(dis);
            if (types == null || types.length == 0) continue;
            MgrEditRow row = edit.addRow(dis, types);
            this.manager.getLearn().toRow(dis, row);
        }
        return edit.invoke(cx);
    }

    protected CommandArtifact doAddTemplates(Object[] templates, Context cx) throws Exception {
        MgrEdit edit = this.makeEdit(this.add.getLabel());
        for (int i = 0; i < templates.length; ++i) {
            Object template = templates[i];
            MgrTypeInfo[] types = this.manager.getMgrTemplate().toTypes(template);
            if (types == null || types.length == 0) continue;
            MgrEditRow row = edit.addRow(template, types);
            this.manager.getMgrTemplate().toRow(template, row);
        }
        try {
            return edit.invoke(cx);
        }
        catch (Exception e) {
            return null;
        }
    }

    public CommandArtifact doMatch(Context cx) throws Exception {
        if (!this.manager.isLearnable()) {
            return null;
        }
        Object dis = this.getLearnTable().getSelectedObject();
        if (dis == null) {
            return null;
        }
        BComponent db = this.getTable().getSelectedComponent();
        if (db == null) {
            return null;
        }
        return this.doMatch(dis, db, cx);
    }

    public CommandArtifact doMatch(Object discovery, BComponent database, Context cx) throws Exception {
        MgrEdit edit = this.makeEdit(this.match.getLabel());
        MgrEditRow row = edit.addRow(database);
        this.manager.getLearn().toRow(discovery, row);
        return edit.invoke(cx);
    }

    public CommandArtifact doTagIt(Context cx) throws Exception {
        if (this.manager.isTaggable()) {
            return this.manager.getMgrTagDictionary().doTagIt(cx);
        }
        return null;
    }

    public CommandArtifact doDeploy(Context cx) throws Exception {
        if (!this.manager.isTemplatable()) {
            return null;
        }
        Object template = this.getDevTemplateTable().getSelectedObject();
        if (template == null) {
            if (cx instanceof TransferContext) {
                Mark mark = (Mark)((TransferContext)cx).getEnvelope().getData(TransferFormat.mark);
                return this.doDeploy(mark.getValue(0), cx);
            }
            return null;
        }
        return this.doDeploy(template, cx);
    }

    protected CommandArtifact doDeploy(Object discovery, Context cx) throws Exception {
        return null;
    }

    public void headerPopup(BTemplateTable table, BMouseEvent event, int column) {
    }

    public static class MgrToggleCommand
    extends ToggleCommand
    implements IMgrCommand {
        private String name;
        private int flags;

        public MgrToggleCommand(BWidget owner, Lexicon lexicon, String keyBase) {
            super(owner, lexicon, keyBase);
            this.name = SlotPath.escape((String)keyBase);
        }

        public MgrToggleCommand(BWidget owner, String label) {
            super(owner, label);
            this.name = SlotPath.escape((String)label);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public void setFlags(int flags) {
            this.flags = flags;
        }
    }

    public static class MgrCommand
    extends Command
    implements IMgrCommand {
        private String name;
        private int flags;

        public MgrCommand(BWidget owner, Lexicon lexicon, String keyBase) {
            super(owner, lexicon, keyBase);
            this.name = SlotPath.escape((String)keyBase);
        }

        public MgrCommand(BWidget owner, String label) {
            super(owner, label);
            this.name = SlotPath.escape((String)label);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public void setFlags(int flags) {
            this.flags = flags;
        }
    }

    public static interface IMgrCommand {
        public String getName();

        public int getFlags();

        public void setFlags(int var1);
    }

    class SelectAll
    extends MgrCommand {
        SelectAll(BLearnTable owner) {
            super((BWidget)owner, (Lexicon)UiLexicon.bajaui(), "commands.selectAll");
        }

        public CommandArtifact doInvoke() throws Exception {
            ((BLearnTable)this.getOwner()).getSelection().selectAll();
            return null;
        }
    }

    class ShowExisting
    extends MgrCommand {
        BComponent existing;

        ShowExisting(BWidget owner, BComponent existing) {
            super(owner, MgrController.this.lex, "showExisting");
            this.existing = existing;
            this.setEnabled(existing != null);
        }

        public CommandArtifact doInvoke() throws Exception {
            BDialog.message((BWidget)this.getOwner(), (String)this.getLabel(), (Object)this.existing.toDisplayPathString(null));
            return null;
        }
    }

    class Deploy
    extends MgrCommand {
        Deploy(BWidget owner) {
            super(owner, MgrController.this.lex, "deploy");
        }

        public CommandArtifact doInvoke() throws Exception {
            return MgrController.this.doDeploy(null);
        }

        public Command doMerge(Command c) {
            return this;
        }
    }

    class TagIt
    extends MgrCommand {
        TagIt(BWidget owner) {
            super(owner, MgrController.this.lex, "tagIt");
        }

        public CommandArtifact doInvoke() throws Exception {
            MgrController.this.manager.setMgrEditState(2);
            CommandArtifact artifact = MgrController.this.doTagIt(null);
            MgrController.this.manager.setMgrEditState(0);
            return artifact;
        }

        public Command doMerge(Command c) {
            return this;
        }
    }

    class QuickMatch
    extends MgrCommand {
        QuickMatch(BWidget owner) {
            super(owner, MgrController.this.lex, "quickMatch");
        }

        public CommandArtifact doInvoke() throws Exception {
            MgrController.this.manager.setMgrEditState(3);
            CommandArtifact artifact = MgrController.this.doMatch(quickContext);
            MgrController.this.manager.setMgrEditState(0);
            return artifact;
        }

        public Command doMerge(Command c) {
            return this;
        }
    }

    class Match
    extends MgrCommand {
        Match(BWidget owner) {
            super(owner, MgrController.this.lex, "match");
        }

        public CommandArtifact doInvoke() throws Exception {
            MgrController.this.manager.setMgrEditState(3);
            CommandArtifact artifact = MgrController.this.doMatch(null);
            MgrController.this.manager.setMgrEditState(0);
            return artifact;
        }

        public Command doMerge(Command c) {
            return this;
        }
    }

    class QuickAdd
    extends MgrCommand {
        QuickAdd(BWidget owner) {
            super(owner, MgrController.this.lex, "quickAdd");
        }

        public CommandArtifact doInvoke() throws Exception {
            MgrController.this.manager.setMgrEditState(1);
            CommandArtifact artifact = MgrController.this.doAdd(quickContext);
            MgrController.this.manager.setMgrEditState(0);
            return artifact;
        }

        public Command doMerge(Command c) {
            return this;
        }
    }

    class Add
    extends MgrCommand {
        Add(BWidget owner) {
            super(owner, MgrController.this.lex, "add");
        }

        public CommandArtifact doInvoke() throws Exception {
            MgrController.this.manager.setMgrEditState(1);
            Context cx = null;
            if (MgrController.this.getManager().isTemplatable() && MgrController.this.getManager().getMgrTemplate().getTable().getSelectedObjects().length == 1) {
                cx = quickContext;
            }
            CommandArtifact artifact = MgrController.this.doAdd(cx);
            MgrController.this.manager.setMgrEditState(0);
            return artifact;
        }

        public Command doMerge(Command c) {
            return this;
        }
    }

    class Edit
    extends MgrCommand {
        Edit(BWidget owner) {
            super(owner, MgrController.this.lex, "edit");
        }

        public CommandArtifact doInvoke() throws Exception {
            MgrController.this.manager.setMgrEditState(2);
            CommandArtifact artifact = MgrController.this.doEdit(MgrController.this.manager.getCurrentContext());
            MgrController.this.manager.setMgrEditState(0);
            return artifact;
        }

        public Command doMerge(Command c) {
            return this;
        }
    }

    class New
    extends MgrCommand {
        New(BWidget owner) {
            super(owner, MgrController.this.lex, "new");
        }

        public CommandArtifact doInvoke() throws Exception {
            MgrController.this.manager.setMgrEditState(4);
            CommandArtifact artifact = MgrController.this.doNew(null);
            MgrController.this.manager.setMgrEditState(0);
            return artifact;
        }

        public Command doMerge(Command c) {
            return this;
        }
    }

    class Cancel
    extends MgrCommand {
        Cancel(BWidget owner) {
            super(owner, MgrController.this.lex, "cancel");
        }

        public CommandArtifact doInvoke() throws Exception {
            return MgrController.this.doCancel(null);
        }
    }

    class Discover
    extends MgrCommand {
        Discover(BWidget owner) {
            super(owner, MgrController.this.lex, "discover");
        }

        public CommandArtifact doInvoke() throws Exception {
            return MgrController.this.doDiscover(null);
        }
    }

    class TemplateMode
    extends MgrToggleCommand {
        TemplateMode(BWidget owner) {
            super(owner, MgrController.this.lex, "templateMode");
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            MgrController.this.doTemplateMode(sel);
        }
    }

    class TagMode
    extends MgrToggleCommand {
        TagMode(BWidget owner) {
            super(owner, MgrController.this.lex, "tagMode");
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            MgrController.this.doTagMode(sel);
        }
    }

    class LearnMode
    extends MgrToggleCommand {
        LearnMode(BWidget owner) {
            super(owner, MgrController.this.lex, "learnMode");
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            MgrController.this.doLearnMode(sel);
        }
    }

    class MenuController
    implements BAbstractButton.MenuController {
        MenuController() {
        }

        public boolean isMenuDistinct() {
            return true;
        }

        public BMenu getMenu(BAbstractButton button) {
            IMgrCommand[] cmds = MgrController.this.getDropDownCommands((IMgrCommand)button.getCommand());
            BMenu menu = new BMenu();
            for (int i = 0; i < cmds.length; ++i) {
                menu.add(null, (Command)cmds[i]);
            }
            return menu;
        }
    }
}

