/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.workbench.util.BEditTagManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMarker;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.tag.Taggable;
import javax.baja.tag.Tags;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrSupport;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.tag.BTagDictionaryPane;
import javax.baja.workbench.mgr.tag.BTagFilterEnum;

public class MgrTagDictionary
extends MgrSupport {
    private static Logger logger = Logger.getLogger("mgrTagDictionary.loading");
    private TagDictionaryService service;
    private BTagDictionaryPane pane;
    private ArrayList<Entity> newEntities;

    public MgrTagDictionary(BAbstractManager manager) {
        super(manager);
    }

    @Override
    public void init() {
        this.getTagDictionaryService();
    }

    public String getNamespace() {
        return this.pane.getNamespace();
    }

    public void setNamespace(String namespace) {
        this.pane.setNamespace(namespace);
    }

    public BTagFilterEnum getTagFilter() {
        return this.pane.getTagFilter();
    }

    public void setTagFilter(BTagFilterEnum tagFilter) {
        this.pane.setTagFilter(tagFilter);
    }

    public TagDictionaryService getTagDictionaryService() {
        long ticks = Clock.ticks();
        if (this.service != null) {
            logger.fine("tagDictionaryService is cached.");
            return this.service;
        }
        try {
            OrdTarget target = BOrd.make((String)"service:tagdictionary:TagDictionaryService").resolve((BObject)this.getTarget());
            this.service = (TagDictionaryService)target.get();
            ((BComponent)this.service).lease(Integer.MAX_VALUE, Long.MAX_VALUE);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("tagDictionaryService, load time(ms)=" + (Clock.ticks() - ticks));
            }
            return this.service;
        }
        catch (UnresolvedException ex) {
            if (this.manager.getTarget() == null) {
                return null;
            }
            this.service = this.manager.getTarget().getTagDictionaryService();
            if (this.service != null) {
                ((BComponent)this.service).lease(Integer.MAX_VALUE, Long.MAX_VALUE);
            }
            return this.service;
        }
    }

    public BWidget makePane() {
        return this.makePane(null);
    }

    public BWidget makePane(BComponent tagEditComp) {
        if (this.pane == null) {
            this.pane = new BTagDictionaryPane(this, tagEditComp);
        }
        return this.pane;
    }

    public BTreeTable getTable() {
        return this.pane.getTable();
    }

    public Object[] getSelectedObjects() {
        TableSelection selection = this.getTable().getSelection();
        int[] rows = selection.getRows();
        ArrayList<Object> objs = new ArrayList<Object>(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            Object obj = this.getTable().getTreeTableModel().getSubject(rows[i]);
            if (obj instanceof String || this.isExisting(obj)) continue;
            objs.add(obj);
        }
        return objs.toArray();
    }

    public void clearSelectedObjects() {
        TableSelection selection = this.getTable().getSelection();
        selection.deselectAll();
    }

    public boolean isTaggable(TagInfo tag, Entity entity) {
        BComponent c = (BComponent)entity;
        if (c != null && c.tags().contains(tag.getTagId())) {
            return false;
        }
        return tag.isValidFor(entity);
    }

    public boolean isTaggable(TagGroupInfo tagGroup, Entity entity) {
        BComponent c = (BComponent)entity;
        Tags dbTags = c.tags();
        Iterator tagGroupTags = tagGroup.getTags();
        boolean containsAll = true;
        while (tagGroupTags.hasNext()) {
            if (dbTags.contains(((TagInfo)tagGroupTags.next()).getTagId())) continue;
            containsAll = false;
            break;
        }
        if (containsAll) {
            return false;
        }
        return tagGroup.isValidFor(entity);
    }

    public boolean isExisting(Object tagInfo) {
        if (this.getManager() instanceof BEditTagManager) {
            return ((BEditTagManager)this.getManager()).isExisting(tagInfo);
        }
        boolean existInAll = true;
        BMgrTable dbTable = this.getManager().getModel().getTable();
        if (dbTable.getSelectedComponent() == null) {
            return false;
        }
        if (tagInfo instanceof TagInfo) {
            for (BComponent dbSelection : dbTable.getSelectedComponents()) {
                if (this.hasTag((TagInfo)tagInfo, (Entity)dbSelection)) continue;
                existInAll = false;
                break;
            }
        } else if (tagInfo instanceof TagGroupInfo) {
            TagGroupInfo tgi = (TagGroupInfo)tagInfo;
            Iterator tgiTags = tgi.getTags();
            block1: while (tgiTags.hasNext()) {
                TagInfo nextTagInfo = (TagInfo)tgiTags.next();
                for (BComponent dbSelection : dbTable.getSelectedComponents()) {
                    if (this.hasTag(nextTagInfo, (Entity)dbSelection)) continue;
                    existInAll = false;
                    continue block1;
                }
            }
        } else {
            return false;
        }
        return existInAll;
    }

    private boolean hasTag(TagInfo tag, Entity entity) {
        BComponent c = (BComponent)entity;
        if (c != null) {
            return c.tags().contains(tag.getTagId());
        }
        return false;
    }

    public Entity[] getNewEntityPrototypes() {
        if (this.newEntities != null) {
            return this.newEntities.toArray(new Entity[0]);
        }
        MgrModel mgrModel = this.getManager().getModel();
        MgrTypeInfo[] newTypes = mgrModel.getNewTypes();
        if (newTypes == null) {
            return new Entity[0];
        }
        this.newEntities = new ArrayList(newTypes.length);
        TagDictionaryService service = this.getTagDictionaryService();
        for (int i = 0; i < newTypes.length; ++i) {
            try {
                BComponent e = mgrModel.newInstance(newTypes[i]);
                BRelation relation = new BRelation(Id.newId((String)"n:parent"), this.getTarget());
                e.relations().add((Relation)relation);
                Iterator tags = service.getImpliedTags((Entity)e).iterator();
                while (tags.hasNext()) {
                    e.tags().set((Tag)tags.next());
                }
                this.newEntities.add((Entity)e);
                continue;
            }
            catch (Exception ex) {
                System.out.println("MgrTagDictionary.getNewEntityPrototypes " + newTypes[i] + " is not a BComponent, skipping it.");
            }
        }
        return this.newEntities.toArray(new Entity[0]);
    }

    public CommandArtifact doTagIt(Context cx) throws Exception {
        Object[] tagObjects = this.getSelectedObjects();
        if (tagObjects == null || tagObjects.length == 0) {
            return null;
        }
        BComponent[] db = this.manager.getModel().getTable().getSelectedComponents();
        if (db == null || db.length == 0) {
            return null;
        }
        boolean allMarkers = true;
        for (int i = 0; i < tagObjects.length; ++i) {
            if (!(tagObjects[i] instanceof TagInfo)) continue;
            if (!((TagInfo)tagObjects[i]).getTagType().is(BMarker.TYPE)) {
                allMarkers = false;
                continue;
            }
            if (!(tagObjects[i] instanceof TagGroupInfo)) continue;
            Iterator t = ((TagGroupInfo)tagObjects[i]).getTags();
            while (t.hasNext()) {
                if (((TagInfo)t.next()).getTagType().is(BMarker.TYPE)) continue;
                allMarkers = false;
                break;
            }
            if (!allMarkers) break;
        }
        if (allMarkers) {
            return this.setMarkerTags(tagObjects, db, cx);
        }
        return this.setValueAndMarkerTags(tagObjects, db, cx);
    }

    protected CommandArtifact setMarkerTags(Object[] tagObjects, BComponent[] db, Context cx) {
        int t;
        int tagCount = 0;
        for (t = 0; t < tagObjects.length; ++t) {
            if (tagObjects[t] instanceof TagInfo) {
                ++tagCount;
                continue;
            }
            if (!(tagObjects[t] instanceof TagGroupInfo)) continue;
            Iterator i = ((TagGroupInfo)tagObjects[t]).getTags();
            while (i.hasNext()) {
                ++tagCount;
                i.next();
            }
        }
        for (t = 0; t < tagObjects.length; ++t) {
            Object tagObject = tagObjects[t];
            for (int d = 0; d < db.length; ++d) {
                if (tagObject instanceof TagInfo) {
                    ((TagInfo)tagObject).setTagOn((Taggable)db[d]);
                    continue;
                }
                if (!(tagObject instanceof TagGroupInfo)) continue;
                Iterator tags = ((TagGroupInfo)tagObject).getTags();
                while (tags.hasNext()) {
                    ((TagInfo)tags.next()).setTagOn((Taggable)db[d]);
                }
            }
        }
        Lexicon lex = Lexicon.make((String)"workbench", (Context)cx);
        String title = null;
        String message = null;
        if (tagCount == 1) {
            title = lex.get("tag.added.title");
            message = db.length == 1 ? lex.getText("tag.added.singleObject.message") : lex.getText("tag.added.multipleObjects.message", new Object[]{db.length});
        } else {
            title = lex.get("tags.added.title");
            message = db.length == 1 ? lex.getText("tags.added.singleObject.message", new Object[]{tagCount}) : lex.getText("tags.added.multipleObjects.message", new Object[]{tagCount, db.length});
        }
        BDialog.message((BWidget)this.getManager(), (String)title, (Object)message);
        return null;
    }

    protected CommandArtifact setValueAndMarkerTags(final Object[] tagObjects, BComponent[] db, Context cx) throws Exception {
        if (tagObjects == null || tagObjects.length == 0 || db == null || db.length == 0) {
            return null;
        }
        Lexicon lex = Lexicon.make((String)"workbench", (Context)cx);
        MgrEdit edit = new MgrEdit(this.getManager(), lex.get("set.tags.title")){

            @Override
            protected MgrColumn[] makeColumns() {
                return MgrTagDictionary.this.makeTagColumns(tagObjects);
            }
        };
        for (int i = 0; i < db.length; ++i) {
            edit.addRow(db[i]);
        }
        edit.setSelectAll(true);
        return edit.invoke(cx);
    }

    public MgrColumn[] makeTagColumns() {
        return this.makeTagColumns(this.getSelectedObjects());
    }

    public MgrColumn[] makeTagColumns(Object[] tagObjects) {
        if (tagObjects == null || tagObjects.length == 0) {
            return null;
        }
        LinkedHashSet<Object> tagInfos = new LinkedHashSet<Object>(tagObjects.length);
        for (int i = 0; i < tagObjects.length; ++i) {
            if (tagObjects[i] instanceof TagInfo) {
                tagInfos.add((TagInfo)tagObjects[i]);
                continue;
            }
            if (!(tagObjects[i] instanceof TagGroupInfo)) continue;
            Iterator tg = ((TagGroupInfo)tagObjects[i]).getTags();
            while (tg.hasNext()) {
                tagInfos.add(tg.next());
            }
        }
        ArrayList<TagInfoColumn> columns = new ArrayList<TagInfoColumn>(tagInfos.size() + 1);
        for (TagInfo tagInfo : tagInfos) {
            columns.add(new TagInfoColumn(tagInfo, tagInfo.getTagId().toString(), 0));
        }
        MgrColumn[] mgrColumnArray = columns.toArray(new MgrColumn[0]);
        for (int c = 0; c < mgrColumnArray.length; ++c) {
            mgrColumnArray[c].init(this.getManager());
        }
        return mgrColumnArray;
    }

    private static class TagInfoColumn
    extends MgrColumn {
        private TagInfo tagInfo;

        TagInfoColumn(TagInfo tagInfo, String displayName, int flags) {
            super(displayName, flags);
            this.tagInfo = tagInfo;
        }

        @Override
        public Object get(Object row) {
            Optional t = ((BComponent)row).tags().get(this.tagInfo.getTagId());
            if (t.isPresent()) {
                return t.get();
            }
            return this.tagInfo.getTag((Entity)row).getValue();
        }

        @Override
        public BValue load(MgrEditRow row) throws Exception {
            BComponent target = row.getTarget();
            Optional v = target.tags().get(this.tagInfo.getTagId());
            if (v.isPresent()) {
                return (BValue)v.get();
            }
            return (BValue)this.tagInfo.getTag((Entity)target).getValue();
        }

        @Override
        public void save(MgrEditRow row, BValue value, Context cx) throws Exception {
            BComponent target = row.getTarget();
            target.tags().set(this.tagInfo.getTagId(), (BIDataValue)value);
        }

        @Override
        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BValue val = rows[0].getCell(colIndex);
            for (int i = 1; i < rows.length; ++i) {
                if (rows[i].getCell(colIndex).getClass() == val.getClass()) continue;
                return null;
            }
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor((BObject)val);
            }
            if (val == null) {
                val = (BValue)this.tagInfo.getDefaultValue();
            }
            editor.loadValue((BObject)val.newCopy());
            return editor;
        }

        @Override
        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BValue val = (BValue)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, val.newCopy());
            }
        }
    }
}

