/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr.folder;

import com.tridium.workbench.transfer.TransferUtil;
import javax.baja.nre.util.Array;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderModel;

public class FolderController
extends MgrController {
    Lexicon lex = Lexicon.make(BFolderManager.class);
    public final MgrController.MgrCommand newFolder;
    public final MgrController.MgrToggleCommand allDescendants;

    public FolderController(BFolderManager manager) {
        super(manager);
        this.newFolder = new NewFolder(manager);
        this.allDescendants = new AllDescendants(manager);
        this.newFolder.setFlags(15);
        this.allDescendants.setFlags(3);
    }

    public BComponent[] getSelectedComponentsWithoutFolders() {
        FolderModel model = (FolderModel)this.getManager().getModel();
        Type folderType = model.getFolderType();
        BComponent[] all = this.getSelectedComponents();
        Array acc = new Array(BComponent.class, all.length);
        for (int i = 0; i < all.length; ++i) {
            if (all[i].getType().is(folderType)) continue;
            acc.add((Object)all[i]);
        }
        return (BComponent[])acc.trim();
    }

    @Override
    protected MgrController.IMgrCommand[] makeCommands() {
        return FolderController.append(new MgrController.IMgrCommand[]{this.newFolder, this.allDescendants}, super.makeCommands());
    }

    @Override
    public void updateCommands() {
        super.updateCommands();
        BComponent[] sel = this.getSelectedComponentsWithoutFolders();
        this.edit.setEnabled(sel.length > 0);
    }

    @Override
    public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
        FolderModel model = (FolderModel)this.getManager().getModel();
        Type folderType = model.getFolderType();
        BComponent comp = this.getTable().getComponentAt(row);
        BWbShell shell = this.getManager().getWbShell();
        if (comp != null && comp.getType().is(folderType) && shell != null) {
            shell.hyperlink(new HyperlinkInfo(comp.getNavOrd(), (BInputEvent)event));
            return;
        }
        super.cellDoubleClicked(table, event, row, col);
    }

    @Override
    public CommandArtifact doEdit(Context cx) throws Exception {
        BComponent[] sel = this.getSelectedComponentsWithoutFolders();
        if (sel.length == 0) {
            return null;
        }
        MgrEdit edit = this.makeEdit(this.edit.getLabel());
        for (int i = 0; i < sel.length; ++i) {
            edit.addRow(sel[i]);
        }
        edit.setSelectAll(true);
        return edit.invoke(cx);
    }

    public CommandArtifact doNewFolder() throws Exception {
        BFolderManager mgr = (BFolderManager)this.getManager();
        FolderModel model = (FolderModel)mgr.getModel();
        BComponent parent = (BComponent)mgr.getCurrentValue();
        BComponent child = (BComponent)model.getFolderType().getInstance();
        String name = "Folder";
        return TransferUtil.insert(mgr, 16, new Mark((BObject)child, name), (BObject)parent, null, null);
    }

    public void doAllDescendants(boolean selected) {
        ((BFolderManager)this.getManager()).reloadNewDepth();
    }

    class AllDescendants
    extends MgrController.MgrToggleCommand {
        AllDescendants(BWidget owner) {
            super(owner, FolderController.this.lex, "allDescendants");
        }

        public void setSelected(boolean sel) {
            boolean old = this.isSelected();
            super.setSelected(sel);
            if (old != sel) {
                FolderController.this.doAllDescendants(sel);
            }
        }

        public Command doMerge(Command c) {
            return this;
        }
    }

    class NewFolder
    extends MgrController.MgrCommand {
        NewFolder(BWidget owner) {
            super(owner, FolderController.this.lex, "newFolder");
        }

        public CommandArtifact doInvoke() throws Exception {
            return FolderController.this.doNewFolder();
        }

        public Command doMerge(Command c) {
            return this;
        }
    }
}

