/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.nav.menu;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.util.ObjectUtil;
import com.tridium.util.PxUtil;
import com.tridium.workbench.px.PxEditorApi;
import com.tridium.workbench.shell.WbCommands;
import java.security.AccessController;
import java.util.ArrayList;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.gx.BImage;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.Subject;
import javax.baja.ui.commands.HyperlinkCommand;
import javax.baja.ui.commands.InvokeActionCommand;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbLocatorBar;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.WbSys;
import javax.baja.workbench.nav.menu.BNavMenuAgent;

public class NavMenuUtil {
    static TypeInfo pxEditor = null;
    static boolean disable;
    static BImage viewIcon;

    public static BMenu makeMenu(BWidget owner, BObject target) {
        return BNavMenuAgent.makeFor(target).makeMenu(owner, target);
    }

    public static BMenu makeMenu(BWidget owner, Subject subject) {
        subject.lease();
        BMenu result = null;
        for (int i = 0; i < subject.size(); ++i) {
            Object x = subject.get(i);
            if (!(x instanceof BObject)) {
                return null;
            }
            BObject o = (BObject)x;
            BMenu menu = BNavMenuAgent.makeFor(o).makeMenu(owner, o);
            if (menu == null) {
                return null;
            }
            if (result == null) {
                result = menu;
                continue;
            }
            if ((result = NavMenuUtil.merge(result, menu)) != null) continue;
            return null;
        }
        return result;
    }

    public static BMenu merge(BMenu a, BMenu b) {
        if (a == null || b == null) {
            return null;
        }
        BMenu m = new BMenu();
        boolean hasItems = false;
        BComponent[] akids = a.getChildComponents();
        for (int i = 0; i < akids.length; ++i) {
            Command mcmd;
            String name = akids[i].getName();
            BValue bval = b.get(name);
            if (!(bval instanceof BComponent)) continue;
            BComponent akid = akids[i];
            BComponent bkid = (BComponent)bval;
            if (akid.getClass() != bkid.getClass()) continue;
            if (akid instanceof BSeparator) {
                m.add(name, (BValue)new BSeparator());
                continue;
            }
            if (!(akid instanceof BActionMenuItem)) continue;
            Command acmd = ((BActionMenuItem)akid).getCommand();
            Command bcmd = ((BActionMenuItem)bkid).getCommand();
            if (acmd == null || bcmd == null || (mcmd = acmd.merge(bcmd)) == null) continue;
            m.add(name, (BValue)new BActionMenuItem(mcmd));
            hasItems = true;
        }
        if (!hasItems) {
            return null;
        }
        m.removeConsecutiveSeparators();
        return m;
    }

    public static BMenu makeViewsMenu(BWidget owner, BObject target) {
        BINavNode navNode = (BINavNode)target;
        BOrd baseOrd = navNode.getNavOrd();
        return NavMenuUtil.makeViewsMenu(owner, target, baseOrd);
    }

    public static BMenu makeViewsMenu(BWidget owner, BObject target, BOrd baseOrd) {
        UiLexicon lex = UiLexicon.bajaui();
        String lexViews = lex.getText("menu.views.label");
        BPermissions permissions = BPermissions.all;
        if (target instanceof BIProtected) {
            permissions = ((BIProtected)target).getPermissions(null);
        }
        boolean isComp = target instanceof BComponent;
        AgentList agentList = WbSys.getFilteredViewList(owner, target, disable ? AgentFilter.has((BPermissions)permissions).toPredicate() : agent -> true);
        AgentInfo[] agents = agentList.list();
        BMenu menu = new BMenu(lexViews);
        try {
            boolean pxEditable = false;
            ArrayList<AgentInfo> pxViewEditors = null;
            for (int i = 0; i < agents.length; ++i) {
                AgentInfo agent2 = agents[i];
                if (agent2 instanceof PxUtil.PxEditor) {
                    if (pxViewEditors == null) {
                        pxViewEditors = new ArrayList<AgentInfo>();
                    }
                    pxViewEditors.add(agent2);
                    continue;
                }
                if (isComp && pxEditor != null && agent2.getAgentType().is(pxEditor)) {
                    pxEditable = true;
                    continue;
                }
                menu.add("v" + i, NavMenuUtil.makeHyperlinkCommand(owner, baseOrd, agent2));
            }
            if (pxEditable) {
                BComponent comp = (BComponent)target;
                menu.add("sep0", (BValue)new BSeparator());
                menu.add("newView", (Command)new PxEditorApi.NewViewCommand(owner, comp));
                for (int i = 0; pxViewEditors != null && i < pxViewEditors.size(); ++i) {
                    menu.add("edit" + i, NavMenuUtil.makeHyperlinkCommand(owner, baseOrd, (AgentInfo)pxViewEditors.get(i)));
                }
            }
            if (target instanceof BBogFile) {
                BOrd bogOrd = BOrd.make((BOrd)baseOrd, (String)"bog:|slot:/");
                BFolder folder = new BFolder();
                AgentInfo[] folderAgents = WbSys.getFilteredViewList(owner, (BObject)folder, agent -> true).list();
                menu.add("sep1", (BValue)new BSeparator());
                for (int i = 0; i < folderAgents.length; ++i) {
                    AgentInfo a = folderAgents[i];
                    if (pxEditor != null && a.getAgentType().is(pxEditor)) continue;
                    menu.add("bog" + i, NavMenuUtil.makeHyperlinkCommand(owner, bogOrd, a));
                }
            }
            boolean inLocator = false;
            for (BWidget w = owner; w != null; w = w.getParentWidget()) {
                if (!(w instanceof BWbLocatorBar)) continue;
                inLocator = true;
                break;
            }
            if (!inLocator) {
                menu.add("sep2", (BValue)new BSeparator());
                WbCommands.NavHelpCommand guideHelp = new WbCommands.NavHelpCommand(owner, "menu.views.guide", target);
                WbCommands.NavBajadocCommand refHelp = new WbCommands.NavBajadocCommand(owner, "menu.views.bajadoc", target);
                menu.add("helpGuide", (BValue)new BActionMenuItem((Command)guideHelp), null);
                menu.add("helpRef", (BValue)new BActionMenuItem((Command)refHelp), null);
                if (permissions.hasAdminRead() || !disable) {
                    BISession session;
                    menu.add("spyLocal", (Command)new SpyLocalCommand(owner, target));
                    if (target instanceof BISpaceNode && (session = ((BISpaceNode)target).getSession()) != null && session != BLocalHost.INSTANCE) {
                        menu.add("spyRemote", (Command)new SpyRemoteCommand(owner, target));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return menu;
    }

    static Command makeHyperlinkCommand(BWidget owner, BOrd baseOrd, AgentInfo agent) {
        String text = agent.getDisplayName(null);
        BImage icon = BImage.make((BIcon)agent.getIcon(null));
        if (icon == null) {
            icon = viewIcon;
        }
        String agentId = agent.getAgentId();
        BOrd ord = BOrd.make((BOrd)baseOrd, (String)("view:" + agentId));
        return new HyperlinkCommand(owner, icon, text, ord);
    }

    public static BMenu makeActionsMenu(BWidget owner, BComponent target) {
        UiLexicon lex = UiLexicon.bajaui();
        String lexActions = lex.getText("menu.actions.label");
        BPermissions permissions = BPermissions.all;
        if (target instanceof BIProtected) {
            permissions = target.getPermissions(null);
        }
        target.loadSlots();
        Slot[] slots = target.getSlotsArray();
        BMenu menu = new BMenu(lexActions);
        boolean disable = true;
        for (int i = 0; i < slots.length; ++i) {
            int flags;
            Slot slot = slots[i];
            if (!slot.isAction()) continue;
            Action action = (Action)slot;
            if (NavMenuUtil.disable && (((flags = target.getFlags((Slot)action)) & 4) != 0 || ((flags & 0x100) != 0 ? !permissions.has(4) : !permissions.has(64)))) continue;
            InvokeActionCommand cmd = new InvokeActionCommand(owner, target, action);
            menu.add("a" + i, (BValue)new BActionMenuItem((Command)cmd), null);
            disable = false;
        }
        if (disable) {
            menu.setEnabled(false);
        }
        return menu;
    }

    static {
        try {
            pxEditor = Sys.getRegistry().getType("pxEditor:PxEditor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        disable = AccessController.doPrivileged(() -> System.getProperty("workbench.disableIfNoPermission", "true")).equals("true");
        viewIcon = BImage.make((String)"module://icons/x16/views/view.png");
    }

    static class SpyRemoteCommand
    extends Command {
        BObject target;

        SpyRemoteCommand(BWidget owner, BObject target) {
            super(owner, (Lexicon)UiLexicon.bajaui(), "commands.spyRemote");
            this.target = target;
        }

        public CommandArtifact doInvoke(CommandEvent evt) {
            BWbShell shell = (BWbShell)this.getShell();
            BOrd ord = ObjectUtil.toSpyRemote((BObject)this.target);
            if (ord != null) {
                BHyperlinkMode mode = BHyperlinkMode.replace;
                if (evt != null) {
                    mode = evt.isControlDown() ? BHyperlinkMode.newTab : BHyperlinkMode.replace;
                }
                shell.hyperlink(new HyperlinkInfo(ord, mode));
            }
            return null;
        }
    }

    static class SpyLocalCommand
    extends Command {
        BObject target;

        SpyLocalCommand(BWidget owner, BObject target) {
            super(owner, (Lexicon)UiLexicon.bajaui(), "commands.spyLocal");
            this.target = target;
        }

        public CommandArtifact doInvoke(CommandEvent evt) {
            BWbShell shell = (BWbShell)this.getShell();
            BOrd ord = ObjectUtil.toSpyLocal((BObject)this.target);
            if (ord != null) {
                BHyperlinkMode mode = BHyperlinkMode.replace;
                if (evt != null) {
                    mode = evt.isControlDown() ? BHyperlinkMode.newTab : BHyperlinkMode.replace;
                }
                shell.hyperlink(new HyperlinkInfo(ord, mode));
            }
            return null;
        }
    }
}

