/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusSlave.comm;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.modbusSlave.BModbusSlaveNetwork;
import com.tridium.modbusSlave.comm.ModbusSlaveRxDriver;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class ModbusSlaveSerialComm
extends Comm {
    private static final long MIN_SLEEP_TIME = 1L;
    protected BISerialPort serialPort;
    protected InputStream in;
    protected OutputStream out;
    protected Thread rxThread;
    private long lastRecvMessageTicks = 0L;

    public ModbusSlaveSerialComm(BModbusSlaveNetwork serialNetwork) {
        super((BBasicNetwork)serialNetwork, (CommReceiver)new ModbusSlaveRxDriver(serialNetwork));
    }

    protected boolean started() throws Exception {
        try {
            BISerialService platSvc = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            this.serialPort = ((BModbusSlaveNetwork)this.getNetwork()).getSerialPortConfig().open(this.getNetwork().getName());
            this.serialPort.enableReceiveTimeout(platSvc.getMinTimeout());
            this.in = this.serialPort.getInputStream();
            this.out = this.serialPort.getOutputStream();
        }
        catch (Exception e) {
            String errMsg = "Error opening and configuring the serial port: ";
            this.getNetwork().getLog().error(errMsg + e.getLocalizedMessage());
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception x) {
                    this.getNetwork().getLog().error("Unable to close serial input stream: " + x.getLocalizedMessage());
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (Exception x) {
                    this.getNetwork().getLog().error("Unable to close serial output stream: " + x.getLocalizedMessage());
                }
            }
            if (this.serialPort != null) {
                this.serialPort.close();
            }
            throw e;
        }
        this.getCommReceiver().setInputStream(this.in);
        this.getCommTransmitter().setOutputStream(this.out);
        this.rxThread = new Thread((Runnable)this.getCommReceiver(), "SerialRcv:" + this.getNetwork().getName());
        this.getCommReceiver().setAlive(true);
        this.rxThread.start();
        this.rxThread.setPriority(7);
        return true;
    }

    protected void stopped() throws Exception {
        this.getCommReceiver().setAlive(false);
        if (this.getCommReceiver() != null && this.rxThread != null) {
            this.rxThread.interrupt();
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception e) {
                this.getNetwork().getLog().error("Unable to close serial input stream: " + e.getLocalizedMessage());
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception e) {
                this.getNetwork().getLog().error("Unable to close serial output stream: " + e.getLocalizedMessage());
            }
        }
        if (this.serialPort != null) {
            this.serialPort.disableReceiveTimeout();
            this.serialPort.close();
        }
        this.in = null;
        this.out = null;
    }

    public Message transmit(Message msg, BRelTime responseTimeout, int retryCount) throws BasicException {
        if (msg == null) {
            return null;
        }
        if (!msg.getResponseExpected()) {
            this.transmitNoResponse(msg);
            return null;
        }
        this.performInterMessageDelay();
        return super.transmit(msg, responseTimeout, retryCount);
    }

    public void transmitNoResponse(Message msg) throws BasicException {
        if (msg == null) {
            return;
        }
        if (!this.isCommStarted()) {
            throw new BasicException("Communication handler service not started.");
        }
        this.performInterMessageDelay();
        super.transmitNoResponse(msg);
    }

    public void receive(ReceivedMessage msg) {
        if (msg == null) {
            return;
        }
        this.setReceivedMessageTicks(Clock.ticks());
        super.receive(msg);
    }

    protected void performInterMessageDelay() {
        long minDelay = ((BModbusSlaveNetwork)this.getNetwork()).getInterMessageDelay().getMillis();
        if (minDelay <= 0L) {
            return;
        }
        long difference = Clock.ticks() - this.lastRecvMessageTicks;
        if (difference >= minDelay) {
            return;
        }
        long sleepTime = Math.max(minDelay - difference, 1L);
        try {
            Thread.sleep(sleepTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setReceivedMessageTicks(long ticks) {
        this.lastRecvMessageTicks = ticks;
    }

    public BISerialPort getSerialPort() {
        return this.serialPort;
    }
}

