/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.nre.security.SigningPasswordPermission;
import com.tridium.web.BAdditionalHttpsCerts;
import java.security.AccessController;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.StringJoiner;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BICertificateAliasAndPasswordContainer;
import javax.baja.security.BPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alias", type="BString", defaultValue="BString.DEFAULT", facets={@Facet(name="BFacets.SECURITY", value="true"), @Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:CertificateAliasFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:CertificateAliasEditor\")"), @Facet(value="BFacets.make(\"purposeId\", BString.make(\"SERVER_CERT\"))")}, deprecated=true), @NiagaraProperty(name="certAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", flags=4, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="isDuplicate", type="boolean", defaultValue="false", flags=7), @NiagaraProperty(name="isRejected", type="boolean", defaultValue="false", flags=7)})
public class BAdditionalHttpsCert
extends BComponent
implements BICertificateAliasAndPasswordContainer {
    @Deprecated
    @Generated
    public static final Property alias = BAdditionalHttpsCert.newProperty((int)0, (BValue)BString.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"security", (boolean)true), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE"))), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"purposeId", (BIDataValue)BString.make((String)"SERVER_CERT"))));
    @Generated
    public static final Property certAliasAndPassword = BAdditionalHttpsCert.newProperty((int)4, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property isDuplicate = BAdditionalHttpsCert.newProperty((int)7, (boolean)false, null);
    @Generated
    public static final Property isRejected = BAdditionalHttpsCert.newProperty((int)7, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAdditionalHttpsCert.class);
    private static final BIcon ICON = BIcon.std((String)"files/certificate.png");
    private static final LexiconModule LEXICON = LexiconModule.make((String)"web");

    @Deprecated
    @Generated
    public String getAlias() {
        return this.getString(alias);
    }

    @Deprecated
    @Generated
    public void setAlias(String v) {
        this.setString(alias, v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getCertAliasAndPassword() {
        return (BCertificateAliasAndPassword)this.get(certAliasAndPassword);
    }

    @Generated
    public void setCertAliasAndPassword(BCertificateAliasAndPassword v) {
        this.set(certAliasAndPassword, (BValue)v, null);
    }

    @Generated
    public boolean getIsDuplicate() {
        return this.getBoolean(isDuplicate);
    }

    @Generated
    public void setIsDuplicate(boolean v) {
        this.setBoolean(isDuplicate, v, null);
    }

    @Generated
    public boolean getIsRejected() {
        return this.getBoolean(isRejected);
    }

    @Generated
    public void setIsRejected(boolean v) {
        this.setBoolean(isRejected, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        if (!Flags.has((BComplex)this, (Slot)alias, (int)0x10000000)) {
            this.getCertAliasAndPassword().setAlias(this.getAlias());
            this.getCertAliasAndPassword().setPassword(BPassword.DEFAULT);
            Flags.add((BComponent)this, (Slot)alias, null, (int[])new int[]{0x10000005});
        }
        if (!Flags.has((BComplex)this, (Slot)certAliasAndPassword, (int)0x10000000)) {
            Flags.add((BComponent)this, (Slot)certAliasAndPassword, null, (int[])new int[]{0x10000000});
            this.setFlags((Slot)certAliasAndPassword, this.getFlags((Slot)certAliasAndPassword) & 0xFFFFFFFB);
            this.getCertAliasAndPassword().setFacets((Slot)BCertificateAliasAndPassword.alias, BFacets.make((String)"purposeId", (String)KeyPurpose.SERVER_CERT.name()));
        }
    }

    public static BAdditionalHttpsCert make() {
        BAdditionalHttpsCert additionalHttpsCert = new BAdditionalHttpsCert();
        Flags.add((BComponent)additionalHttpsCert, (Slot)alias, null, (int[])new int[]{0x10000005});
        additionalHttpsCert.getCertAliasAndPassword().setAlias(additionalHttpsCert.getAlias());
        return additionalHttpsCert;
    }

    public static BAdditionalHttpsCert make(String alias) {
        BAdditionalHttpsCert additionalHttpsCert = new BAdditionalHttpsCert();
        Flags.add((BComponent)additionalHttpsCert, (Slot)BAdditionalHttpsCert.alias, null, (int[])new int[]{0x10000005});
        additionalHttpsCert.setAlias(alias);
        additionalHttpsCert.getCertAliasAndPassword().setAlias(alias);
        return additionalHttpsCert;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAdditionalHttpsCerts;
    }

    public boolean isChildLegal(BComponent child) {
        if (IndividualSignedCertConfigHolder.INDIVIDUAL_SIGNED_CERT_CONFIG_TYPE != null) {
            return child.getType().is(IndividualSignedCertConfigHolder.INDIVIDUAL_SIGNED_CERT_CONFIG_TYPE);
        }
        return false;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (certAliasAndPassword.equals(property)) {
            ((BComponent)this.getParent()).changed(this.getPropertyInParent(), context);
        }
    }

    public final String toString(Context cx) {
        if (!this.getCertAliasAndPassword().getAlias().isEmpty()) {
            StringBuilder builder = new StringBuilder(this.getCertAliasAndPassword().getAlias());
            if (this.getIsDuplicate() || this.getIsRejected()) {
                StringJoiner joiner = new StringJoiner(", ", " (", ")");
                if (this.getIsDuplicate()) {
                    joiner.add(LEXICON.getText("webService.additionalCerts.aliasDuplicated", cx));
                }
                if (this.getIsRejected()) {
                    joiner.add(LEXICON.getText("webService.additionalCerts.aliasRejected", cx));
                }
                builder.append(joiner.toString());
            }
            return builder.toString();
        }
        return LEXICON.getText("webService.additionalCerts.aliasNotSpecified", cx);
    }

    public BIcon getIcon() {
        return ICON;
    }

    public Property getCertificateAliasAndPasswordProperty(Context context) {
        return certAliasAndPassword;
    }

    public BPassword retrieveCertificatePassword(Property certAliasAndPasswordProperty, Context context) {
        if (!certAliasAndPassword.equals(certAliasAndPasswordProperty)) {
            throw new IllegalArgumentException("Unexpected CertificateAliasAndPassword property argument: \"" + certAliasAndPasswordProperty + "\" != \"" + certAliasAndPassword + '\"');
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SigningPasswordPermission(TYPE.getTypeSpec().getModuleName()));
        }
        return BPassword.make((String)AccessController.doPrivileged(() -> this.getCertAliasAndPassword().getPassword().getValue()));
    }

    public void certificateSigned(Property certAliasAndPasswordProperty, X509Certificate[] certificateChain, Context context) {
        if (!certAliasAndPassword.equals(certAliasAndPasswordProperty)) {
            throw new IllegalArgumentException("Unexpected CertificateAliasAndPassword property argument: \"" + certAliasAndPasswordProperty + "\" != \"" + certAliasAndPassword + '\"');
        }
        this.changed(certAliasAndPassword, null);
    }

    private static final class IndividualSignedCertConfigHolder {
        static final TypeInfo INDIVIDUAL_SIGNED_CERT_CONFIG_TYPE;

        private IndividualSignedCertConfigHolder() {
        }

        static {
            TypeInfo individualSignedCertConfigType;
            try {
                individualSignedCertConfigType = Sys.getType((String)"signingService:IndividualSignedCertConfig").getTypeInfo();
            }
            catch (Exception e) {
                individualSignedCertConfigType = null;
            }
            INDIVIDUAL_SIGNED_CERT_CONFIG_TYPE = individualSignedCertConfigType;
        }
    }
}

