/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.filters;

import com.tridium.web.BIOrdTargetResolver;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.Sys;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class TypeTargetResolverFilter
implements Filter {
    private Set<String> supportedTypes = new HashSet<String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        Collections.addAll(this.supportedTypes, Objects.toString(filterConfig.getInitParameter("types"), "").split(";"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        BIOrdTargetResolver resolver;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String type = Objects.toString(request.getParameter("typeSpec"), "");
        if (type.isEmpty()) {
            resp.sendError(400);
            return;
        }
        if (!this.supportedTypes.contains(type = type.replace("%3A", ":"))) {
            resp.sendError(400);
            return;
        }
        try {
            resolver = (BIOrdTargetResolver)Sys.getType((String)type).getInstance();
        }
        catch (Throwable t) {
            req.getServletContext().log("Unable to resolve BIOrdTargetResolver", t);
            resp.sendError(400);
            return;
        }
        OrdTarget target = resolver.resolve(req, resp);
        if (target == null) {
            req.getServletContext().log("BIOrdTargetResolver resolved to 'null' OrdTarget");
            resp.sendError(404);
            return;
        }
        req.setAttribute("niagara.target", (Object)target);
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    public void destroy() {
        this.supportedTypes.clear();
    }
}

