/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.rpc;

import com.tridium.nre.security.SecurityInitializer;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.web.BWebService;

@NiagaraType
public class BPasswordRpc
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BPasswordRpc.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void setPassword(String pwd, String slotName, String baseOrd, boolean useDefault, Context cx) throws Exception {
        BComplex target;
        Property pwdProp;
        BPasswordRpc.securityCheck(cx);
        if (baseOrd != null && !baseOrd.isEmpty() && (pwdProp = (target = BOrd.make((String)baseOrd).resolve(null, cx).get().asComplex()).getProperty(slotName)) != null) {
            if (useDefault) {
                target.set(pwdProp, (BValue)BPassword.DEFAULT, cx);
            } else {
                target.set(pwdProp, (BValue)BPassword.make((String)pwd, (Context)cx), cx);
            }
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void setCertificateAliasAndPassword(String alias, String pwd, String slotName, String baseOrd, boolean useDefault, boolean setAlias, boolean setPassword, Context cx) throws Exception {
        BPasswordRpc.securityCheck(cx);
        if (baseOrd != null && !baseOrd.isEmpty()) {
            BComplex target = BOrd.make((String)baseOrd).resolve(null, cx).get().asComplex();
            Property prop = target.getProperty(slotName);
            BPassword password = null;
            if (setPassword) {
                password = useDefault ? BPassword.DEFAULT : BPassword.make((String)pwd, (Context)cx);
            }
            if (setPassword && setAlias) {
                BCertificateAliasAndPassword aliasAndPassword = new BCertificateAliasAndPassword(alias, password);
                target.set(prop, (BValue)aliasAndPassword, cx);
            } else if (setPassword) {
                BCertificateAliasAndPassword aliasAndPassword = (BCertificateAliasAndPassword)target.get(prop);
                aliasAndPassword.set(BCertificateAliasAndPassword.password, (BValue)password, cx);
            } else if (setAlias) {
                BCertificateAliasAndPassword aliasAndPassword = (BCertificateAliasAndPassword)target.get(prop);
                aliasAndPassword.set(BCertificateAliasAndPassword.alias, (BValue)BString.make((String)alias), cx);
            }
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static BPasswordStrength getDefaultPasswordStrength(Context context) {
        return SecurityInitializer.getInstance().isFips() ? BPasswordStrength.FIPS_1 : BPasswordStrength.DEFAULT;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static BPasswordStrength getPasswordStrength(boolean isFips, Context context) {
        return isFips ? BPasswordStrength.FIPS_1 : BPasswordStrength.DEFAULT;
    }

    public static void securityCheck(Context cx) throws LocalizableException {
        if (!cx.getFacets().getb("isSecure", false) && !BPasswordRpc.canChangeInsecurely()) {
            throw new LocalizableException("web", "web.server.httpsRequiredForPassword");
        }
    }

    private static boolean canChangeInsecurely() {
        BWebService webService;
        try {
            webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            return true;
        }
        return !webService.getRequireHttpsForPasswords();
    }
}

