/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.rpc;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.atomic.AtomicLong;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.sys.Sys;
import javax.baja.util.LexiconText;

public class UserDataUtils {
    private static final Log LOG = Log.getLog((String)"web");
    public static final String USER_DATA_DIR = "userdata";

    public static byte[] fileContents(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }

    public static BIFile mkdir(BIFile parent, String name) throws IOException {
        BFileSpace space = parent.getFileSpace();
        BIFile dir = space.getChild(parent, name);
        if (dir == null) {
            dir = space.makeDir(parent.getFilePath().merge(name));
        }
        return dir;
    }

    public static void deleteRecursive(File f) {
        UserDataUtils.empty(f);
        f.delete();
    }

    public static void empty(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                UserDataUtils.empty(c);
                c.delete();
            }
        }
    }

    public static void empty(BIFile dir) throws IOException {
        if (dir.isDirectory()) {
            for (BIFile c : dir.getFileSpace().getChildren(dir)) {
                UserDataUtils.empty(c);
            }
        }
        dir.delete();
    }

    public static BIFile replaceFile(BIFile parent, String name) throws IOException {
        BFileSpace space = parent.getFileSpace();
        BIFile dataFile = space.getChild(parent, name);
        if (dataFile != null) {
            dataFile.delete();
        }
        dataFile = space.makeFile(parent.getFilePath().merge(name));
        return dataFile;
    }

    public static File getTmpHome() {
        File tmpHome = UserDataUtils.makeTmpHome();
        tmpHome.deleteOnExit();
        return tmpHome;
    }

    public static File makeTmpHome() {
        StringBuilder name = new StringBuilder();
        name.append(USER_DATA_DIR).append("_").append(Sys.getStation().getStationName()).append("_").append(BFileSystem.INSTANCE.pathToLocalFile(UserDataUtils.getProtectedStationHome().getFilePath()).toString().hashCode());
        return UserDataUtils.mkdir(TmpDirHolder.TMP_DIR, name.toString());
    }

    public static File getTmpHome(String userName) {
        File tmpFile = UserDataUtils.mkdir(UserDataUtils.getTmpHome(), userName);
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    public static BIFile getPermanentHome() throws IOException {
        return UserDataUtils.mkdir((BIFile)UserDataUtils.getProtectedStationHome(), USER_DATA_DIR);
    }

    public static BIFile getPermanentHome(String userName) throws IOException {
        return UserDataUtils.mkdir(UserDataUtils.getPermanentHome(), userName);
    }

    public static long size(Path path) throws IOException {
        final AtomicLong size = new AtomicLong(0L);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                size.addAndGet(attrs.size());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException e) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) {
                if (e != null) {
                    LOG.error("Could not visit user data directory", (Throwable)e);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return size.get();
    }

    private static File mkdir(File parent, String name) {
        File dir = new File(parent, name);
        dir.mkdir();
        return dir;
    }

    private static BDirectory getProtectedStationHome() {
        BLocalFileStore protectedStationHomeStore = new BLocalFileStore((BFileSpace)BFileSystem.INSTANCE, new FilePath("^^"), Sys.getProtectedStationHome());
        return new BDirectory((BIFileStore)protectedStationHomeStore, LexiconText.make((String)"baja", (String)"nav.protectedStationHome"));
    }

    private static final class TmpDirHolder {
        private static final File TMP_DIR = TmpDirHolder.getTmpDir();

        private TmpDirHolder() {
        }

        private static File getTmpDir() {
            try {
                return AccessController.doPrivileged(() -> new File(System.getProperty("java.io.tmpdir")));
            }
            catch (PrivilegedActionException e) {
                LOG.error("Could not retrieve java.io.tmpdir", (Throwable)e);
                return null;
            }
        }
    }
}

