/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.web.WebUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.Context;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SpeedTestServlet
extends HttpServlet {
    private static final Logger DIAGNOSTIC_LOG = Logger.getLogger("diagnostics.web.speedTest");

    public void init(ServletConfig config) throws ServletException {
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri;
        Context cx = (Context)req.getAttribute("niagara.context");
        if (cx == null || cx.getUser() == null || !cx.getUser().getPermissions().isSuperUser()) {
            resp.sendError(403);
        }
        if ("/niagaraspeedtest/upload".equals(uri = req.getRequestURI().toLowerCase())) {
            ServletInputStream in = req.getInputStream();
            while (in.read() != -1) {
            }
        } else if ("/niagaraspeedtest/results".equals(uri)) {
            try (BufferedReader reader = req.getReader();){
                if (DIAGNOSTIC_LOG.isLoggable(Level.FINE)) {
                    JSONObject json = new JSONObject(new JSONTokener((Reader)reader));
                    long latency = json.getLong("latency");
                    long download = json.getLong("download");
                    long upload = json.getLong("upload");
                    DiagnosticUtil.completeDuration((long)(latency * 1000000L), (String)"web.speedTest.latency", (Object)req.getRemoteAddr());
                    DiagnosticUtil.completeDuration((long)(download * 1000000L), (String)"web.speedTest.download", (Object)req.getRemoteAddr());
                    DiagnosticUtil.completeDuration((long)(upload * 1000000L), (String)"web.speedTest.upload", (Object)req.getRemoteAddr());
                }
            }
            catch (Throwable e) {
                req.getServletContext().log("Cannot Complete speedTestResults", e);
                WebUtil.sendSafeErrorToUser(resp, 400, e, cx);
            }
        } else {
            resp.sendError(403);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context cx = (Context)req.getAttribute("niagara.context");
        if (cx == null || cx.getUser() == null || !cx.getUser().getPermissions().isSuperUser()) {
            resp.sendError(403);
        }
        resp.setHeader("transfer-encoding", "chunked");
        String uri = req.getRequestURI().toLowerCase();
        if (uri.startsWith("/niagaraspeedtest/download")) {
            long byteSize = 0x100000L;
            int b = 97;
            int i = 0;
            while ((long)i < byteSize) {
                resp.getWriter().write(b);
                ++i;
            }
        }
        if (uri.startsWith("/niagaraspeedtest/latency")) {
            // empty if block
        }
    }
}

