/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.session;

import com.tridium.session.SessionManager;
import com.tridium.web.session.NiagaraWebSession;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionHandler;

public final class WebSessionUtil {
    public static final String WEB_SESSION_ATTR = "javax.baja.web.niagaraWebSession";
    private static final Logger LOGGER = Logger.getLogger(WebSessionUtil.class.getName());

    private WebSessionUtil() {
    }

    public static NiagaraWebSession getSession(HttpServletRequest request) {
        return WebSessionUtil.getSession(request, true);
    }

    public static NiagaraWebSession getSession(HttpServletRequest request, boolean createSession) {
        if (request instanceof Request) {
            Request jettyRequest = (Request)request;
            String requestSessionAttribute = (String)request.getAttribute("org.eclipse.jetty.server.newSessionId");
            String requestedSessionId = WebSessionUtil.getId(request.getRequestedSessionId());
            HttpSession requestSession = request.getSession(false);
            if (requestSessionAttribute != null && requestSession == null) {
                boolean sessionStillValid;
                Session matchingSession = jettyRequest.getSessionHandler().getSession(requestSessionAttribute);
                boolean bl = sessionStillValid = matchingSession != null && matchingSession.isValid();
                if (sessionStillValid) {
                    LOGGER.fine(() -> String.format("[%s] Request session did not match request session attribute, re-using session from attribute: id = %s", request.getRequestURI(), requestSessionAttribute));
                    jettyRequest.setSession((HttpSession)matchingSession);
                } else if (matchingSession != null) {
                    LOGGER.fine(() -> String.format("[%s] Request session did not match request session attribute, clearing session attribute: id = %s", request.getRequestURI(), requestSessionAttribute));
                    jettyRequest.setAttribute("org.eclipse.jetty.server.newSessionId", null);
                }
            } else if (requestedSessionId != null && requestSession == null) {
                boolean sessionStillValid;
                Session matchingSession = jettyRequest.getSessionHandler().getSession(requestedSessionId);
                boolean bl = sessionStillValid = matchingSession != null && matchingSession.isValid();
                if (sessionStillValid) {
                    LOGGER.fine(() -> String.format("[%s] Request session did not match requested session id, re-using session from requested session id: id = %s", request.getRequestURI(), requestedSessionId));
                    jettyRequest.setSession((HttpSession)matchingSession);
                } else if (matchingSession != null) {
                    LOGGER.fine(() -> String.format("[%s] Request session did not match requested session id, clearing requested session id: id = %s", request.getRequestURI(), requestedSessionId));
                    jettyRequest.setRequestedSessionId(null);
                }
            }
        }
        return WebSessionUtil.getSession(WebSessionUtil.getSessionFromRequest(request, createSession));
    }

    public static NiagaraWebSession getSession(HttpSession session) {
        if (session != null) {
            NiagaraWebSession niagaraWebSession = (NiagaraWebSession)session.getAttribute(WEB_SESSION_ATTR);
            if (niagaraWebSession == null) {
                throw new IllegalStateException("HttpSession has no NiagaraWebSession");
            }
            return niagaraWebSession;
        }
        return null;
    }

    public static NiagaraWebSession getSessionOrCreateIfAuthenticated(HttpServletRequest request) {
        HttpSession requestSession = request.getSession(false);
        if (requestSession != null) {
            return WebSessionUtil.getSession(requestSession);
        }
        String requestedSessionId = WebSessionUtil.getId(request.getRequestedSessionId());
        NiagaraWebSession niagaraWebSession = (NiagaraWebSession)SessionManager.getNiagaraSession((String)requestedSessionId, NiagaraWebSession.class);
        if (niagaraWebSession != null && SessionManager.isAuthenticated((String)niagaraWebSession.getSuperId())) {
            return WebSessionUtil.getSession(WebSessionUtil.getSessionFromRequest(request, true));
        }
        return WebSessionUtil.getSession(request.getSession(false));
    }

    public static synchronized HttpSession getSessionFromRequest(HttpServletRequest request, boolean create) {
        HttpSession httpSession = request.getSession(false);
        if (!create || httpSession != null) {
            return httpSession;
        }
        if (request instanceof Request) {
            SessionHandler sessionHandler = ((Request)request).getSessionHandler();
            String requestedId = request.getRequestedSessionId();
            if (requestedId != null && (httpSession = sessionHandler.getSession(WebSessionUtil.getId(request.getRequestedSessionId()))) != null && sessionHandler.isValid(httpSession)) {
                return httpSession;
            }
        }
        return request.getSession(true);
    }

    public static String getId(String extendedId) {
        if (extendedId == null) {
            return null;
        }
        int dot = extendedId.lastIndexOf(46);
        return dot > 0 ? extendedId.substring(0, dot) : extendedId;
    }

    private static Session findSession(String requestedSessionId, SessionHandler requestSessionHandler, Set<SessionHandler> otherSessionHandlers) {
        Session requestedSession = requestSessionHandler.getSession(requestedSessionId);
        if (requestedSession != null) {
            return requestedSession;
        }
        for (SessionHandler sessionHandler : otherSessionHandlers) {
            try {
                requestedSession = sessionHandler.getSession(requestedSessionId);
                if (requestedSession == null) continue;
                break;
            }
            catch (Exception exception) {
            }
        }
        return requestedSession;
    }
}

