/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.stub;

import com.tridium.authn.LoginFailureCause;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.web.session.NiagaraWebSession;
import java.security.Permission;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.web.BWebService;
import javax.servlet.http.HttpSession;

public class StubNiagaraWebSession
implements NiagaraWebSession {
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private String superId;
    private final long creationTime;
    private String id;
    private static String auditTarget;
    private static final Logger LOGGER;

    public StubNiagaraWebSession(HttpSession httpSession) {
        this.id = httpSession.getId();
        this.creationTime = System.currentTimeMillis();
    }

    public String getSuperId() {
        return this.superId;
    }

    public void setSuperId(String superId) {
        NiagaraBasicPermission initPermission = new NiagaraBasicPermission("MODIFY_SESSION_IDS");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)initPermission);
        }
        this.superId = superId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, String> getSessionInfo() {
        return Collections.emptyMap();
    }

    public String getRemoteHost() {
        return "127.0.0.1";
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public String getAuditTarget() {
        if (auditTarget == null) {
            BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
            auditTarget = webService.toPathString();
        }
        return auditTarget;
    }

    public void doSetAuthenticated(BUser user) {
    }

    @Override
    public Set<String> getAttributeKeys() {
        Set<String> attributeKeys = this.attributes.keySet();
        LOGGER.finest(() -> {
            StringJoiner joiner = new StringJoiner(",");
            for (String attributeKey : attributeKeys) {
                joiner.add(attributeKey);
            }
            return String.format("%s, getAttributes: keys = [%s]", this.getId(), joiner.toString());
        });
        return attributeKeys;
    }

    @Override
    public <V> V getAttribute(String key) {
        Object value = this.attributes.get(key);
        LOGGER.finest(() -> String.format("%s: getAttribute, key = [%s], value = [%s]", this.getId(), key, value));
        return value;
    }

    @Override
    public Object setAttribute(String key, Object value) {
        LOGGER.finest(() -> String.format("%s: setAttribute, key = [%s], value = [%s]", this.getId(), key, value));
        if (value == null) {
            return this.attributes.remove(key);
        }
        return this.attributes.put(key, value);
    }

    @Override
    public <V> V removeAttribute(String key) {
        Object value = this.attributes.remove(key);
        LOGGER.finest(() -> String.format("%s: removeAttribute, key = [%s], value = [%s]", this.getId(), key, value));
        return value;
    }

    public void invalidate() {
    }

    public void invalidate(LoginFailureCause cause) {
    }

    @Override
    public boolean isValid() {
        return true;
    }

    static {
        LOGGER = Logger.getLogger("web");
    }
}

