/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web.js;

import com.tridium.json.JSONArray;
import com.tridium.web.graph.CoffmanGrahamDagResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.baja.agent.BIAgent;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.js.BJsBuild;
import javax.baja.web.js.JsInfo;

@NiagaraType
public interface BIWebResource
extends BIAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BIWebResource.class);

    public BOrd[] getFiles();

    default public String[] getRequireJsIds() {
        BOrd[] files = this.getFiles();
        String[] ids = new String[files.length];
        int len = files.length;
        for (int i = 0; i < len; ++i) {
            ids[i] = JsInfo.toRequireJsId(files[i]);
        }
        return ids;
    }

    default public Set<BIWebResource> getDependencies() {
        return Collections.emptySet();
    }

    public static DependencyGraph resolve(Collection<? extends BIWebResource> resources) {
        return new DependencyGraph(resources);
    }

    public static class DependencyGraph {
        private static final Predicate<BIWebResource> STANDARD_WEBDEV_FILTER = resource -> {
            if (resource instanceof BJsBuild) {
                return !((BJsBuild)resource).isWebDevEnabled();
            }
            return true;
        };
        private final List<Set<BIWebResource>> solvedGraph;

        private DependencyGraph(Collection<? extends BIWebResource> resources) {
            this.solvedGraph = CoffmanGrahamDagResolver.resolve(resources, BIWebResource::getDependencies);
        }

        public boolean isEmpty() {
            return this.solvedGraph.isEmpty();
        }

        public List<Set<BIWebResource>> solve() {
            return this.solve(STANDARD_WEBDEV_FILTER);
        }

        public List<Set<BIWebResource>> solve(Predicate<BIWebResource> filter) {
            return this.solvedGraph.stream().map(webResources -> DependencyGraph.filterSet(webResources, filter)).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }

        public JSONArray toJSON() {
            return this.toJSON(STANDARD_WEBDEV_FILTER);
        }

        private JSONArray toJSON(Predicate<BIWebResource> filter) {
            JSONArray arr = new JSONArray();
            for (Set<BIWebResource> layer : this.solvedGraph) {
                JSONArray deps = null;
                for (BIWebResource resource : layer) {
                    if (!filter.test(resource)) continue;
                    if (deps == null) {
                        deps = new JSONArray();
                    }
                    deps.putAll((Object)resource.getRequireJsIds());
                }
                if (deps == null) continue;
                arr.put(deps);
            }
            return arr;
        }

        private static <T> Set<T> filterSet(Set<T> set, Predicate<T> predicate) {
            return set.stream().filter(predicate).collect(Collectors.toCollection(HashSet::new));
        }
    }
}

