/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web.mobile;

import com.tridium.web.IWebEnvProvider;
import com.tridium.web.WebProcessException;
import com.tridium.web.session.WebSessionUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BUserAgentClientEnvironment;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebOp;
import javax.baja.web.mobile.BIMobileWebProfile;
import javax.baja.web.mobile.BMobileWebProfile;
import javax.baja.web.mobile.BMobileWebProfileConfig;

@NiagaraType
@NiagaraProperty(name="userAgentPattern", type="String", defaultValue="BMobileClientEnvironment.DEFAULT_USER_AGENT_PATTERN", override=true)
public final class BMobileClientEnvironment
extends BUserAgentClientEnvironment {
    @Generated
    public static final Property userAgentPattern = BMobileClientEnvironment.newProperty((int)0, (String)"mobile|android|playbook|touch", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMobileClientEnvironment.class);
    private boolean licensed = false;
    public static final Logger LOGGER = Logger.getLogger(BMobileClientEnvironment.class.getName());
    private static final String DEFAULT_USER_AGENT_PATTERN = "mobile|android|playbook|touch";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getWebProfileConfigType() {
        return BMobileWebProfileConfig.TYPE;
    }

    @Override
    public IWebEnv makeWebEnv(WebOp op) {
        IWebEnv env = null;
        BUser user = op.getUser();
        BWebProfileConfig cfg = (BWebProfileConfig)user.getMixIn(this.getWebProfileConfigType());
        if (cfg != null) {
            op.getRequest().getSession(true).setAttribute("profileConfig", (Object)cfg);
            BIWebProfile profile = (BIWebProfile)cfg.make();
            if (profile instanceof IWebEnvProvider) {
                try {
                    env = ((IWebEnvProvider)((Object)profile)).getWebEnv(op);
                }
                catch (WebProcessException ex) {
                    LOGGER.log(Level.WARNING, "WebEnv cannot be obtained, falling back to BMobileWebProfile.webEnv", (Throwable)((Object)ex));
                }
            }
        }
        if (env == null) {
            env = BMobileWebProfile.webEnv();
        }
        if (cfg != null) {
            BWebProfileConfig config = env.getHxProfileConfig(cfg);
            op.getRequest().getSession(true).setAttribute("hxProfileConfig", (Object)env.getHxProfileConfig(cfg));
            WebSessionUtil.getSession(op.getRequest().getSession()).setAttribute("hxProfileConfig", (Object)config);
        }
        return env;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 11) {
            try {
                Sys.getLicenseManager().checkFeature("tridium", "mobile");
                this.licensed = true;
                if (!BMobileClientEnvironment.isMobileAvailable()) {
                    this.updateStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true), "Mobile not installed");
                }
            }
            catch (FeatureNotLicensedException ex) {
                this.licensed = false;
                this.updateStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true), "Feature not licensed: mobile");
            }
        } else if (!(x != 2 || !this.isRunning() || !a.equals(status) || this.licensed && BMobileClientEnvironment.isMobileAvailable() || this.getStatus().isFault())) {
            this.updateStatus(this.getStatus(), null);
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    protected final void updateStatus(BStatus newStatus, String faultCause) {
        if (this.licensed) {
            if (!BMobileClientEnvironment.isMobileAvailable()) {
                this.setStatus(BStatus.makeFault((BStatus)newStatus, (boolean)true));
                this.setFaultCause("Mobile not installed");
            } else {
                super.updateStatus(newStatus, faultCause);
            }
        } else {
            this.setStatus(BStatus.makeFault((BStatus)newStatus, (boolean)true));
            this.setFaultCause("Feature not licensed: mobile");
        }
    }

    public static final boolean isMobileAvailable() {
        boolean res = false;
        try {
            if (Sys.getRegistry().getConcreteTypes(BIMobileWebProfile.TYPE.getTypeInfo()).length > 0) {
                res = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }
}

