/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web.servlets;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import com.tridium.util.NiagaraRpcUtil;
import com.tridium.web.WebUtil;
import com.tridium.web.filters.OrdTargetFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessControlException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.naming.BOrd;
import javax.baja.rpc.TransportType;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class NiagaraRpcServlet
extends HttpServlet {
    private static final JSONArray noArguments = new JSONArray();
    private static final Pattern rpcPathPattern = Pattern.compile("/([^/]+)/(.+)");

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context cx = (Context)req.getAttribute("niagara.context");
        String remoteAddr = Objects.toString(req.getRemoteAddr(), "");
        String pathInfo = Objects.toString(req.getPathInfo(), "");
        resp.setContentType("application/json; charset=utf-8");
        resp.addHeader("Pragma", "no-cache");
        resp.addHeader("Expires", "-1");
        resp.addHeader("Cache-Control", "no-store");
        Matcher matcher = rpcPathPattern.matcher(pathInfo);
        if (matcher.matches()) {
            String methodName = matcher.group(1);
            BOrd ord = OrdTargetFilter.toOrd(matcher.group(2));
            try (BufferedReader reader = req.getReader();
                 PrintWriter writer = resp.getWriter();){
                JSONArray arguments;
                try {
                    arguments = new JSONArray(new JSONTokener((Reader)reader));
                }
                catch (Exception e) {
                    arguments = noArguments;
                }
                Optional retVal = NiagaraRpcUtil.rpc((TransportType)TransportType.web, (boolean)req.isSecure(), (String)remoteAddr, (BOrd)ord, (String)methodName, (JSONArray)arguments, (Context)cx);
                JSONObject respObj = new JSONObject();
                respObj.put("value", retVal.orElse(JSONObject.NULL));
                ((Writer)writer).write(respObj.toString());
            }
            catch (AccessControlException a) {
                this.log("Error invoking RPC: " + ord + " -> " + methodName, a);
                LocalizableRuntimeException e = new LocalizableRuntimeException("baja", "niagaraRpc.securityMessage", null, (Throwable)a);
                WebUtil.sendSafeErrorToUser(resp, 403, (Throwable)e, cx);
            }
            catch (Exception err) {
                this.log("Error invoking RPC: " + ord + " -> " + methodName, err);
                WebUtil.sendSafeErrorToUser(resp, 400, err, cx);
            }
        } else if (pathInfo.isEmpty() || pathInfo.equals("/")) {
            try (BufferedReader reader = req.getReader();
                 PrintWriter writer = resp.getWriter();){
                JSONArray respArray = new JSONArray();
                JSONArray calls = new JSONArray(new JSONTokener((Reader)reader));
                for (int i = 0; i < calls.length(); ++i) {
                    JSONObject callObj = calls.getJSONObject(i);
                    BOrd ord = BOrd.make((String)JSONUtil.getString((JSONObject)callObj, (String)"ord"));
                    String methodName = JSONUtil.getString((JSONObject)callObj, (String)"methodName");
                    JSONArray arguments = callObj.has("args") ? callObj.getJSONArray("args") : noArguments;
                    Optional retVal = NiagaraRpcUtil.rpc((TransportType)TransportType.web, (boolean)req.isSecure(), (String)remoteAddr, (BOrd)ord, (String)methodName, (JSONArray)arguments, (Context)cx);
                    respArray.put(retVal.isPresent() ? retVal.get() : JSONObject.NULL);
                }
                ((Writer)writer).write(respArray.toString());
            }
            catch (AccessControlException a) {
                this.log("Error invoking multi RPC", a);
                LocalizableRuntimeException e = new LocalizableRuntimeException("baja", "niagaraRpc.securityMessage", null, (Throwable)a);
                WebUtil.sendSafeErrorToUser(resp, 403, (Throwable)e, cx);
            }
            catch (Exception err) {
                this.log("Error invoking multi RPC", err);
                WebUtil.sendSafeErrorToUser(resp, 400, err, cx);
            }
        } else {
            resp.sendError(400);
        }
    }
}

