/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.ui;

import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.ui.MemberModel;
import com.tridium.lonworks.util.LonStringUtil;
import com.tridium.nre.platform.OperatingSystemEnum;
import java.security.AccessController;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;

@NiagaraType(agent={@AgentOn(types={"lonIp:IpChannel"})})
public class BMemberManager
extends BFolderManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BMemberManager.class);
    static final UiLexicon lex = UiLexicon.makeUiLexicon(BMemberManager.class);
    private static final boolean HEADLESS = AccessController.doPrivileged(() -> Boolean.getBoolean("java.awt.headless"));

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new MemberModel(this);
    }

    protected MgrController makeController() {
        return new MemberController(this);
    }

    protected void init() {
        super.init();
        ((FolderController)this.getController()).allDescendants.setSelected(true);
    }

    public void doLoadValue(BObject value, Context cx) {
        try {
            super.doLoadValue(value, cx);
        }
        catch (Throwable e) {
            System.out.println(e);
        }
        this.registerForComponentEvents((BComponent)((BIpChannel)value), 1);
    }

    public CommandArtifact doBrowse() {
        block6: {
            if (HEADLESS) {
                throw new UnsupportedOperationException("Display required to launch external application");
            }
            BComponent[] a = this.getModel().getTable().getSelectedComponents();
            if (a.length == 0) {
                return null;
            }
            BChannelMember cm = (BChannelMember)a[0];
            try {
                if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.linux)) {
                    new ProcessBuilder("xdg-open", "http://" + cm.getIpUcAddress()).start();
                    break block6;
                }
                if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows)) {
                    new ProcessBuilder("cmd.exe", "/c", "start", "http://" + cm.getIpUcAddress()).start();
                    break block6;
                }
                throw new IllegalStateException("Unknown OS " + OperatingSystemEnum.getOS());
            }
            catch (Throwable e) {
                System.out.println(e);
            }
        }
        return null;
    }

    public void handleComponentEvent(BComponentEvent event) {
        BComponent srcCmp = event.getSourceComponent();
        switch (event.getId()) {
            case 5: {
                if (srcCmp != this.getCurrentValue() || event.getSlot() != BIpChannel.statusResponse) break;
                String s = ((BString)event.getValue()).getString();
                String[] sa = LonStringUtil.getStringArray((String)s);
                Array a = new Array(BWidget.class);
                for (int i = 1; i < sa.length; ++i) {
                    a.add((Object)new BLabel(sa[i]));
                }
                BGridPane gp = new BGridPane(2, (BWidget[])a.trim());
                BDialog.open((BWidget)this, (String)("Status for " + sa[0]), (Object)gp, (int)1, (BImage)BDialog.INFO_ICON);
            }
        }
        super.handleComponentEvent(event);
    }

    public static UiLexicon lex() {
        return lex;
    }

    class Browse
    extends MgrController.MgrCommand {
        Browse(BWidget owner) {
            super(owner, (Lexicon)BMemberManager.lex(), "commands.browse");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BMemberManager.this.doBrowse();
        }
    }

    public class MemberController
    extends FolderController {
        public final MgrController.MgrCommand browse;

        public MemberController(BFolderManager manager) {
            super(manager);
            this.newFolder.setFlags(0);
            this.allDescendants.setFlags(0);
            this.browse = new Browse((BWidget)manager);
            this.browse.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newCommand, this.edit, this.cancel, this.add, this.browse};
        }

        public MgrEdit makeEdit(String label) {
            return new MgrEdit(this.getManager(), label){

                public BComponent getAddContainer() {
                    return ((BIpChannel)this.getManager().getCurrentValue()).getMemberTable();
                }
            };
        }

        public void updateCommands() {
            super.updateCommands();
            this.browse.setEnabled(this.getSelectedRows().length > 0);
        }
    }
}

