/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BQueryResult;
import javax.baja.query.BQueryScheme;
import javax.baja.search.BISearchProvider;
import javax.baja.search.BSearchParams;
import javax.baja.search.BSearchResultSet;
import javax.baja.search.BSearchService;
import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.user.BUser;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="query", type="String", defaultValue="", flags=259), @NiagaraProperty(name="resultCount", type="long", defaultValue="0", flags=259), @NiagaraProperty(name="resultsExceedLimit", type="boolean", defaultValue="false", flags=259)})
@NiagaraAction(name="expire", flags=2309)
public final class BSearchTask
extends BJob
implements Runnable {
    @Generated
    public static final Property query = BSearchTask.newProperty((int)259, (String)"", null);
    @Generated
    public static final Property resultCount = BSearchTask.newProperty((int)259, (int)0, null);
    @Generated
    public static final Property resultsExceedLimit = BSearchTask.newProperty((int)259, (boolean)false, null);
    @Generated
    public static final Action expire = BSearchTask.newAction((int)2309, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSearchTask.class);
    private static final BIcon icon = BIcon.std((String)"magnifyingGlass.png");
    private static final BFacets lightweightQueryResultsFacets = BFacets.make((String)"lightweightSystemDbQueryResults", (boolean)true);
    private BSearchResultSet searchResults = new BSearchResultSet();
    private CompletableFuture<Void> allTasksFuture;
    BSearchParams searchParams;
    Context searchContext;
    Clock.Ticket expirationTicket;
    private final Object lock = new Object();

    @Generated
    public String getQuery() {
        return this.getString(query);
    }

    @Generated
    public void setQuery(String v) {
        this.setString(query, v, null);
    }

    @Generated
    public long getResultCount() {
        return this.getLong(resultCount);
    }

    @Generated
    public void setResultCount(long v) {
        this.setLong(resultCount, v, null);
    }

    @Generated
    public boolean getResultsExceedLimit() {
        return this.getBoolean(resultsExceedLimit);
    }

    @Generated
    public void setResultsExceedLimit(boolean v) {
        this.setBoolean(resultsExceedLimit, v, null);
    }

    @Generated
    public void expire() {
        this.invoke(expire, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSearchTask() {
    }

    public BSearchTask(BSearchParams searchParams, Context cx) {
        String defaultScheme;
        OrdQuery[] queries2;
        this.setQuery(searchParams.getQuery());
        BOrdScheme ordScheme = null;
        try {
            queries2 = BOrd.make((String)searchParams.getQuery()).parse();
            Optional scheme = BOrdScheme.find((String)queries2[queries2.length - 1].getScheme());
            if (scheme.isPresent()) {
                ordScheme = (BOrdScheme)scheme.get();
            }
        }
        catch (Exception queries2) {
            // empty catch block
        }
        if (ordScheme == null && (defaultScheme = BSearchService.getService().getDefaultScheme()).length() > 0) {
            try {
                String newQuery = defaultScheme + ":" + searchParams.getQuery();
                BOrd.make((String)newQuery).parse();
                searchParams.setQuery(newQuery);
                ordScheme = BOrdScheme.lookup((String)defaultScheme);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ordScheme == null) {
            throw new LocalizableRuntimeException("search", "search.error.noQueryScheme");
        }
        BSearchTask.filterScopes(ordScheme, searchParams.getScopeVector(), cx);
        if (searchParams.getScopeVector().getPropertyCount() == 0) {
            throw new LocalizableRuntimeException("search", "search.error.noScopesForQueryScheme");
        }
        queries2 = BOrd.make((String)searchParams.getQuery()).parse();
        if (queries2.length > 2 || queries2.length > 1 && !queries2[0].getScheme().equals("namespace")) {
            throw new LocalizableRuntimeException("search", "search.error.invalidQueryOrd");
        }
        this.searchParams = searchParams;
        this.searchContext = cx;
    }

    public BSearchResultSet getResults() {
        this.checkExpiration(true);
        return this.searchResults;
    }

    public void doExpire(Context cx) {
        block4: {
            try {
                if (this.expirationTicket != null && !this.expirationTicket.isExpired()) {
                    this.expirationTicket.cancel();
                    this.expirationTicket = null;
                }
                if (this.getJobState().isRunning()) {
                    this.doCancel(cx);
                }
                this.doDispose(cx);
            }
            catch (Exception e) {
                BSearchService.logger.fine("Could not dispose search task gracefully. Forcing removal." + e);
                if (this.getParent() == null) break block4;
                ((BComponent)this.getParent()).remove(this.getPropertyInParent(), cx);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.doRun(this.searchContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BOrd submit(Context cx) {
        return BSearchService.getService().submitSearchTask(this, cx);
    }

    public void doRun(Context cx) throws Exception {
        block7: {
            try {
                BOrd query;
                BSearchService searchService = BSearchService.getService();
                int maxResultsPerSearch = searchService.getMaxResultsPerSearch();
                this.searchResults.setMaxResults(maxResultsPerSearch);
                if (maxResultsPerSearch > 0) {
                    if (maxResultsPerSearch < Integer.MAX_VALUE) {
                        ++maxResultsPerSearch;
                    }
                    this.searchContext = new BasicContext(this.searchContext, BFacets.make((String)"queryLimit", (int)maxResultsPerSearch));
                }
                if ((query = this.searchParams.getQueryOrd()) == null) {
                    this.failed((Throwable)new LocalizableRuntimeException("search", "search.error.noQueryScheme"));
                    return;
                }
                BIObject[] scopes = this.searchParams.resolveScopes();
                int scopeCount = scopes.length;
                if (scopeCount < 1) {
                    this.failed((Throwable)new BajaRuntimeException("No scopes found for the search submitted"));
                    return;
                }
                CompletableFuture[] futures = new CompletableFuture[scopeCount];
                Executor executor = searchService.getExecutor();
                for (int i = 0; i < scopeCount; ++i) {
                    BIObject scope = scopes[i];
                    futures[i] = CompletableFuture.runAsync(() -> this.retrieveQueryResults(query, scope, this.searchContext), executor);
                }
                this.allTasksFuture = CompletableFuture.allOf(futures);
                this.allTasksFuture.handle((ok, ex) -> {
                    this.searchResults.setResultsComplete(true);
                    if (ex == null || ex instanceof CancellationException) {
                        if (this.isAlive()) {
                            this.success();
                        }
                    } else {
                        this.failed((Throwable)ex);
                        if (BSearchService.logger.isLoggable(Level.WARNING)) {
                            BSearchService.logger.log(Level.WARNING, this.toPathString() + " search failed", (Throwable)ex);
                        }
                    }
                    this.checkExpiration(false);
                    return null;
                });
            }
            catch (Exception ex2) {
                this.failed(ex2);
                if (!BSearchService.logger.isLoggable(Level.SEVERE)) break block7;
                BSearchService.logger.log(Level.SEVERE, this.toPathString() + " search could not be processed", ex2);
            }
        }
    }

    public void doCancel(Context cx) throws Exception {
        this.canceled();
        if (this.allTasksFuture != null && !this.allTasksFuture.isDone()) {
            this.allTasksFuture.cancel(true);
        }
    }

    public void stopped() throws Exception {
        if (this.expirationTicket != null) {
            this.expirationTicket.cancel();
            this.expirationTicket = null;
        }
        if (this.getJobState().isRunning()) {
            this.doCancel(null);
        }
        super.stopped();
    }

    public void subscribed() {
        this.checkExpiration(true);
    }

    public void unsubscribed() {
        this.checkExpiration(false);
    }

    public BPermissions getPermissions(Context cx) {
        if (cx != null) {
            BUser searchUser;
            BUser user = cx.getUser();
            BUser bUser = searchUser = this.searchContext != null ? this.searchContext.getUser() : null;
            if (user != null && user != searchUser && !user.getPermissions().isSuperUser()) {
                return BPermissions.none;
            }
        }
        return super.getPermissions(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveQueryResults(BOrd query, BIObject scope, Context context) {
        Stream<Entity> stream = null;
        BasicContext cx = new BasicContext(context, lightweightQueryResultsFacets);
        try {
            OrdQuery[] queries = query.parse();
            BOrdScheme ordScheme = BOrdScheme.lookup((String)queries[queries.length - 1].getScheme());
            if (ordScheme instanceof BQueryScheme) {
                BQueryResult queryResult = (BQueryResult)query.resolve((BObject)scope, (Context)cx).get();
                stream = queryResult.stream();
            } else {
                BISearchProvider provider = BSearchService.findSearchProvider((BObject)scope, ordScheme);
                stream = provider.search(query, scope, (Context)cx);
            }
            this.searchResults.addResults(stream, (Context)cx);
        }
        finally {
            boolean resultsExceedLimit;
            if (stream != null) {
                stream.close();
            }
            if (resultsExceedLimit = this.searchResults.getResultsExceedLimit()) {
                this.setResultsExceedLimit(true);
            }
            this.setResultCount(this.searchResults.getResultCount());
            this.heartbeat();
            if (resultsExceedLimit && this.allTasksFuture != null && !this.allTasksFuture.isDone()) {
                this.allTasksFuture.cancel(true);
            }
        }
    }

    static void filterScopes(BOrdScheme ordScheme, BVector requestScopes, Context cx) {
        if (requestScopes.getPropertyCount() == 0) {
            return;
        }
        ArrayList<Property> toRemove = null;
        SlotCursor c = requestScopes.getProperties();
        while (c.next(BOrd.class)) {
            BOrd scopeOrd = (BOrd)c.get();
            OrdTarget scope = scopeOrd.resolve((BObject)BSearchService.getService(), cx);
            if (scope.canRead() && BSearchService.validSchemeForScope(ordScheme, scope)) continue;
            if (toRemove == null) {
                toRemove = new ArrayList<Property>();
            }
            toRemove.add(c.property());
        }
        if (toRemove != null) {
            Iterator i = toRemove.iterator();
            while (i.hasNext()) {
                requestScopes.remove((Property)i.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkExpiration(boolean resetExpiration) {
        if (!this.isRunning()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean subscribed = this.isSubscribed();
            if (this.expirationTicket != null && (subscribed || resetExpiration)) {
                this.expirationTicket.cancel();
                this.expirationTicket = null;
            }
            if (this.expirationTicket == null && !subscribed) {
                this.expirationTicket = Clock.schedule((BComponent)this, (BRelTime)BSearchService.getService().getSearchTaskTimeToLive(), (Action)expire, null);
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

