/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email.ui;

import com.tridium.email.ui.BEmailAddressFE;
import com.tridium.email.ui.BEmailAddressListFE;
import com.tridium.ui.util.LayoutUtil;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAddress;
import javax.baja.email.BEmailAddressList;
import javax.baja.email.BEmailPart;
import javax.baja.email.BTextPart;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"email:Email"})})
public class BEmailFE
extends BWbFieldEditor
implements BWbFieldEditor.IDialogContentProvider {
    @Generated
    public static final Type TYPE = Sys.loadType(BEmailFE.class);
    private UiLexicon lex = UiLexicon.makeUiLexicon(BEmailFE.class);
    private BEmailAddressFE from = new BEmailAddressFE();
    private BEmailAddressListFE to = new BEmailAddressListFE();
    private BEmailAddressListFE cc = new BEmailAddressListFE();
    private BEmailAddressListFE bcc = new BEmailAddressListFE();
    private BTextField subject = new BTextField("", 45, true);
    private BTextEditor body = new BTextEditor();
    private BEmail email;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BEmailFE() {
        BLabel labFrom = new BLabel(this.lex.getText("email.from"), BHalign.left);
        BLabel labTo = new BLabel(this.lex.getText("email.to"), BHalign.left);
        BLabel labCc = new BLabel(this.lex.getText("email.cc"), BHalign.left);
        BLabel labBcc = new BLabel(this.lex.getText("email.bcc"), BHalign.left);
        BLabel labSubj = new BLabel(this.lex.getText("email.subject"), BHalign.left);
        BGridPane grid = new BGridPane(2);
        grid.setHalign(BHalign.left);
        grid.setColumnAlign(BHalign.left);
        grid.setRowAlign(BValign.center);
        grid.setStretchColumn(1);
        grid.add(null, (BValue)labFrom);
        grid.add(null, (BValue)this.from);
        grid.add(null, (BValue)labTo);
        grid.add(null, (BValue)this.to);
        grid.add(null, (BValue)labCc);
        grid.add(null, (BValue)this.cc);
        grid.add(null, (BValue)labBcc);
        grid.add(null, (BValue)this.bcc);
        grid.add(null, (BValue)labSubj);
        grid.add(null, (BValue)this.subject);
        grid.setColorRows(true);
        BTextEditorPane bodyPane = new BTextEditorPane(this.body, 20, 65);
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BBorderPane((BWidget)grid));
        edge.setCenter((BWidget)new BBorderPane((BWidget)bodyPane));
        this.setContent((BWidget)edge);
        this.linkTo("lk0", (BComponent)this.from, (Slot)BEmailAddressFE.setModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.to, (Slot)BEmailAddressListFE.setModified, (Slot)setModified);
        this.linkTo("lk2", (BComponent)this.cc, (Slot)BEmailAddressListFE.setModified, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.bcc, (Slot)BEmailAddressListFE.setModified, (Slot)setModified);
        this.linkTo("lk4", (BComponent)this.subject, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo("lk5", (BComponent)this.body, (Slot)BTextEditor.textModified, (Slot)setModified);
    }

    protected void doSetReadonly(boolean readonly) {
        this.from.setReadonly(readonly);
        this.to.setReadonly(readonly);
        this.cc.setReadonly(readonly);
        this.bcc.setReadonly(readonly);
        this.subject.setEditable(!readonly);
        this.body.setEditable(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.email = (BEmail)value;
        this.from.loadValue((BObject)this.email.getFrom(), cx);
        this.to.loadValue((BObject)this.email.getTo(), cx);
        this.cc.loadValue((BObject)this.email.getCc(), cx);
        this.bcc.loadValue((BObject)this.email.getBcc(), cx);
        this.subject.setText(this.email.getSubject());
        this.body.setText(this.email.getBody().toString());
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BEmailAddress f = (BEmailAddress)this.from.saveValue(cx);
        f.validate((BObject)f, cx);
        this.email.setFrom(f);
        BEmailAddressList t = (BEmailAddressList)this.to.saveValue(cx);
        t.validate((BObject)t, cx);
        this.email.setTo(t);
        BEmailAddressList c = (BEmailAddressList)this.cc.saveValue(cx);
        c.validate((BObject)c, cx);
        this.email.setCc(c);
        BEmailAddressList b = (BEmailAddressList)this.bcc.saveValue(cx);
        b.validate((BObject)b, cx);
        this.email.setBcc(b);
        String s = this.subject.getText();
        this.email.setSubject(s);
        this.email.setBody((BEmailPart)new BTextPart(this.body.getText()));
        return this.email;
    }

    public BWidget getDialogContent() {
        return LayoutUtil.getScrollablePaneForDialogEditor((BWidget)this);
    }
}

