/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.messages;

import com.tridium.flexSerial.BFlexSerialNetwork;
import com.tridium.flexSerial.messages.BFlexMessageBlock;
import com.tridium.flexSerial.messages.BFlexRequestMessage;
import com.tridium.flexSerial.messages.BFlexResponseMessage;
import com.tridium.flexSerial.messages.FlexInputStream;
import com.tridium.flexSerial.messages.FlexOutputStream;
import com.tridium.flexSerial.messages.SerialMessage;
import com.tridium.flexSerial.messages.SerialResponse;
import com.tridium.program.BProgram;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="request", type="BFlexRequestMessage", defaultValue="new BFlexRequestMessage()"), @NiagaraProperty(name="response", type="BFlexResponseMessage", defaultValue="new BFlexResponseMessage()")})
@NiagaraAction(name="forceMessage", flags=16)
public class BFlexRequestResponse
extends BComponent {
    @Generated
    public static final Property request = BFlexRequestResponse.newProperty((int)0, (BValue)new BFlexRequestMessage(), null);
    @Generated
    public static final Property response = BFlexRequestResponse.newProperty((int)0, (BValue)new BFlexResponseMessage(), null);
    @Generated
    public static final Action forceMessage = BFlexRequestResponse.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFlexRequestResponse.class);
    private static final BIcon icon = BIcon.make((String)"module://flexSerial/com/tridium/flexSerial/icons/flexMessageRequestResponse.png");

    @Generated
    public BFlexRequestMessage getRequest() {
        return (BFlexRequestMessage)this.get(request);
    }

    @Generated
    public void setRequest(BFlexRequestMessage v) {
        this.set(request, (BValue)v, null);
    }

    @Generated
    public BFlexResponseMessage getResponse() {
        return (BFlexResponseMessage)this.get(response);
    }

    @Generated
    public void setResponse(BFlexResponseMessage v) {
        this.set(response, (BValue)v, null);
    }

    @Generated
    public void forceMessage() {
        this.invoke(forceMessage, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(forceMessage)) {
            return this.postForceMessage();
        }
        return super.post(action, arg, cx);
    }

    public IFuture postForceMessage() {
        if (this.isRunning()) {
            return this.getNetwork().postAsync((Runnable)new Invocation((BComponent)this, forceMessage, null, null));
        }
        return null;
    }

    public void doForceMessage() {
        this.sendMessage(null);
    }

    public boolean isRequestDefined() {
        BFlexRequestMessage reqMsg = this.getRequest();
        if (reqMsg == null) {
            return false;
        }
        return !reqMsg.getMessage().getMessageSelect().equals("");
    }

    public boolean isResponseDefined() {
        BFlexResponseMessage respMsg = this.getResponse();
        if (respMsg == null) {
            return false;
        }
        return !respMsg.getMessage().getMessageSelect().equals("");
    }

    public String sendMessage(BRelTime timeOut) {
        BObject obj;
        BOrd errorCheckOrd;
        byte[] data;
        BFlexRequestMessage reqMsg = this.getRequest();
        if (reqMsg == null) {
            return "RequestMessage not defined";
        }
        BFlexMessageBlock msg = (BFlexMessageBlock)reqMsg.get("instance");
        if (msg == null) {
            reqMsg.doCreateInstance();
        }
        if ((msg = (BFlexMessageBlock)reqMsg.get("instance")) == null) {
            return "RequestMessage instance not found.";
        }
        FlexOutputStream out = new FlexOutputStream();
        msg.writeTo((BObject)this, out);
        reqMsg.setByteArray(BBlob.make((byte[])out.toByteArray()));
        BFlexResponseMessage responseMsg = this.getResponse();
        responseMsg.setByteArray(BBlob.DEFAULT);
        SerialMessage sendReq = new SerialMessage(out.toByteArray());
        if (!this.isResponseDefined()) {
            sendReq.setResponseExpected(false);
        }
        SerialResponse respMsg = timeOut == null ? (SerialResponse)this.getNetwork().sendSync(sendReq) : (SerialResponse)this.getNetwork().sendSync(sendReq, timeOut, 0);
        if (!this.isResponseDefined()) {
            return "OK";
        }
        if (respMsg == null) {
            return "response timeout";
        }
        BFlexMessageBlock responseBlock = (BFlexMessageBlock)responseMsg.get("instance");
        if (responseBlock != null && (data = respMsg.getBytes()).length > 0) {
            responseBlock.readFrom((BObject)this, new FlexInputStream(respMsg.getBytes()));
            responseMsg.setByteArray(BBlob.make((byte[])respMsg.getBytes()));
        }
        if (!(errorCheckOrd = responseMsg.getMessageValidate()).equals((Object)BOrd.NULL) && (obj = errorCheckOrd.get((BObject)this)) instanceof BProgram) {
            try {
                BProgram errorCheckPgm = (BProgram)obj;
                errorCheckPgm.set("requestByteArray", (BValue)BBlob.make((byte[])reqMsg.getByteArray().copyBytes()));
                errorCheckPgm.set("responseByteArray", (BValue)BBlob.make((byte[])respMsg.getBytes()));
                errorCheckPgm.doExecute();
                BValue results = errorCheckPgm.get("results");
                String error = ((BString)results).getString();
                if (error != null && error.length() >= 0) {
                    return error;
                }
            }
            catch (Exception e) {
                return "ErrorCheck program object must have requestByteArray, responseByteArray & results slots!";
            }
        }
        return "OK";
    }

    public BFlexSerialNetwork getNetwork() {
        return BFlexSerialNetwork.getParentFlexNetwork((BComplex)this);
    }

    public String toString(Context cx) {
        return this.getRequest().getMessage().getMessageSelect() + " : " + this.getResponse().getMessage().getMessageSelect();
    }

    public BIcon getIcon() {
        return icon;
    }
}

