/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.messages;

import com.tridium.flexSerial.enums.BEncodeTypeEnum;
import com.tridium.flexSerial.messages.BFlexMessageElement;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import javax.baja.sys.BFacets;

public class FlexOutputStream
extends ByteArrayOutputStream {
    int cksumStart = 0;

    public FlexOutputStream() {
    }

    public FlexOutputStream(int size) {
        super(size);
    }

    public void write(int value, BEncodeTypeEnum encode, BFacets facets) {
        switch (encode.getOrdinal()) {
            case 2: {
                StringBuilder sb = new StringBuilder();
                sb.append("000");
                sb.append(Integer.toString(value & 0xFF, 16));
                String temp = sb.toString().toUpperCase();
                this.write((byte)temp.charAt(temp.length() - 2));
                this.write((byte)temp.charAt(temp.length() - 1));
                break;
            }
            default: {
                super.write(value);
            }
        }
    }

    public void writeInt(int i, int size, BEncodeTypeEnum encode, BFacets facets) {
        boolean isBigEndian = BFlexMessageElement.isBigEndian(facets);
        if (isBigEndian) {
            this.writeBigEndianInt(i, size, encode, facets);
        } else {
            this.writeLittleEndianInt(i, size, encode, facets);
        }
    }

    public void writeBigEndianInt(int i, int size, BEncodeTypeEnum encode, BFacets facets) {
        byte[] bytes = new byte[size];
        switch (size) {
            case 4: {
                bytes[0] = (byte)(i >> 24 & 0xFF);
                bytes[1] = (byte)(i >> 16 & 0xFF);
                bytes[2] = (byte)(i >> 8 & 0xFF);
                bytes[3] = (byte)(i & 0xFF);
                break;
            }
            case 3: {
                bytes[0] = (byte)(i >> 16 & 0xFF);
                bytes[1] = (byte)(i >> 8 & 0xFF);
                bytes[2] = (byte)(i & 0xFF);
                break;
            }
            case 2: {
                bytes[0] = (byte)(i >> 8 & 0xFF);
                bytes[1] = (byte)(i & 0xFF);
                break;
            }
            default: {
                bytes[0] = (byte)(i & 0xFF);
            }
        }
        switch (encode.getOrdinal()) {
            case 2: {
                byte[] asciiBytes = this.toAsciiHexByteArray(bytes);
                this.write(asciiBytes, 0, asciiBytes.length);
                break;
            }
            default: {
                this.write(bytes, 0, bytes.length);
            }
        }
    }

    public void writeLittleEndianInt(int i, int size, BEncodeTypeEnum encode, BFacets facets) {
        byte[] bytes = new byte[size];
        switch (size) {
            case 4: {
                bytes[0] = (byte)(i & 0xFF);
                bytes[1] = (byte)(i >> 8 & 0xFF);
                bytes[2] = (byte)(i >> 16 & 0xFF);
                bytes[3] = (byte)(i >> 24 & 0xFF);
                break;
            }
            case 3: {
                bytes[0] = (byte)(i & 0xFF);
                bytes[1] = (byte)(i >> 8 & 0xFF);
                bytes[2] = (byte)(i >> 16 & 0xFF);
                break;
            }
            case 2: {
                bytes[0] = (byte)(i & 0xFF);
                bytes[1] = (byte)(i >> 8 & 0xFF);
                break;
            }
            default: {
                bytes[0] = (byte)(i & 0xFF);
            }
        }
        switch (encode.getOrdinal()) {
            case 2: {
                byte[] asciiBytes = this.toAsciiHexByteArray(bytes);
                this.write(asciiBytes, 0, asciiBytes.length);
                break;
            }
            default: {
                this.write(bytes, 0, bytes.length);
            }
        }
    }

    public void writeString(String s, BEncodeTypeEnum encode, BFacets facets) {
        try {
            this.write(s.getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (facets.getb(BFlexMessageElement.NULL_TERMINATE, false)) {
            this.write(0);
        }
    }

    public byte[] toAsciiHexByteArray(byte[] buf) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] >= 0 && buf[i] < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(buf[i] & 0xFF));
        }
        String s = sb.toString().toUpperCase();
        byte[] ba = new byte[s.length()];
        System.arraycopy(s.getBytes(StandardCharsets.US_ASCII), 0, ba, 0, ba.length);
        return ba;
    }

    public void setCksumStart(int offset) {
        this.cksumStart = offset;
    }

    public int getCksumStart() {
        return this.cksumStart;
    }
}

