/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.ui.lexicon;

import com.tridium.devkit.ui.lexicon.BLexiconEditor;
import com.tridium.devkit.ui.lexicon.BLexiconTool;
import com.tridium.devkit.ui.lexicon.LexiconBuilderTableModel;
import com.tridium.nre.util.NiagaraFiles;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.sys.Nre;
import com.tridium.sys.module.BModuleFile;
import com.tridium.sys.registry.NRegistry;
import com.tridium.util.TimeFormat;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.LocalDate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BBrush;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

@NiagaraType(agent={@AgentOn(types={"devkit:LexiconTool"})})
@NiagaraActions(value={@NiagaraAction(name="buildLexicon", flags=4), @NiagaraAction(name="editModuleName", flags=4)})
public class BLexiconModuleBuilder
extends BWbView {
    @Generated
    public static final Action buildLexicon = BLexiconModuleBuilder.newAction((int)4, null);
    @Generated
    public static final Action editModuleName = BLexiconModuleBuilder.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLexiconModuleBuilder.class);
    BTable table;
    LexiconBuilderTableModel tableModel;
    BTextField moduleField;
    BTextField symbolField;
    BTextField descriptionField;
    BTextField vendorField;
    BTextField versionField;
    BTextField brandField;
    BCheckBox deleteLexiconFiles;
    Command selectModuleCommand;
    Command buildCommand;
    File lexiconHome = new File(Nre.getNiagaraHome(), "lexicon");
    File lexiconFile;
    BLexiconTool tool;
    XElem moduleXml;
    String manifestMf;
    public static final int LMB_CHECKBOX_COL = 0;
    public static final int LMB_SOURCE_COL = 1;
    public static final int LMB_LANGUAGE_COL = 2;
    public static final int LMB_FILE_COL = 3;
    public static final int LMB_PATH_COL = 4;
    public static final int LMB_COL_COUNT = 5;
    private static final int BUFFER = 1024;
    public static final String LMB_SOURCE_FILE = "file";
    public static final String LMB_SOURCE_MODULE = "module";
    public static final String LMB_TEMP_FOLDER = "YYYYMMDDHHmm";
    private static final IFileFilter MODULE_FILTER = new ExtFileFilter("Niagara Jar File", "jar");
    private static boolean moduleLexiconsLoaded = false;
    HashSet<File> moduleStores = new HashSet();
    File loadedLexicon;
    private static final Logger log = Logger.getLogger("sys.lexicon");

    @Generated
    public void buildLexicon() {
        this.invoke(buildLexicon, null, null);
    }

    @Generated
    public void editModuleName() {
        this.invoke(editModuleName, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.tool = (BLexiconTool)value;
        BFlowPane modulePane = new BFlowPane();
        modulePane.setVgap(10);
        this.moduleField = new BTextField("", 40, true);
        modulePane.add(null, (BValue)this.moduleField);
        this.selectModuleCommand = new Command((BWidget)this, Lexicon.make((String)"devkit").module, "commands.selectModule"){

            public CommandArtifact doInvoke() {
                BLexiconModuleBuilder.this.doSelectModule();
                return null;
            }
        };
        BButton selectModuleButton = new BButton(this.selectModuleCommand, true, true);
        modulePane.add(null, (BValue)selectModuleButton);
        this.symbolField = new BTextField("", 15, true);
        this.descriptionField = new BTextField("", 40, true);
        this.vendorField = new BTextField("", 40, true);
        this.versionField = new BTextField("", 15, true);
        this.brandField = new BTextField("", 40, true);
        BFlowPane infoPane = new BFlowPane();
        infoPane.setVgap(10);
        this.deleteLexiconFiles = new BCheckBox(Lexicon.make((String)"devkit").getText("commands.deleteLexicons.label"), false);
        infoPane.add(null, (BValue)this.deleteLexiconFiles);
        BGridPane topPane = new BGridPane(2);
        topPane.setHalign(BHalign.left);
        topPane.add(null, (BValue)new BLabel(Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.module.label") + ": "));
        topPane.add(null, (BValue)modulePane);
        topPane.add(null, (BValue)new BLabel(Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.module.symbol") + ": "));
        topPane.add(null, (BValue)this.symbolField);
        topPane.add(null, (BValue)new BLabel(Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.module.description") + ": "));
        topPane.add(null, (BValue)this.descriptionField);
        topPane.add(null, (BValue)new BLabel(Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.module.vendor") + ": "));
        topPane.add(null, (BValue)this.vendorField);
        topPane.add(null, (BValue)new BLabel(Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.module.vendorVersion") + ": "));
        topPane.add(null, (BValue)this.versionField);
        topPane.add(null, (BValue)new BLabel(Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.module.brand") + ": "));
        topPane.add(null, (BValue)this.brandField);
        topPane.add(null, (BValue)new BLabel(""));
        topPane.add(null, (BValue)infoPane);
        this.linkTo((BComponent)this.moduleField, (Slot)BTextEditor.textModified, (Slot)editModuleName);
        moduleLexiconsLoaded = false;
        String[] cols = new String[]{"", Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.source"), Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.language"), Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.file"), Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.path")};
        this.tableModel = new LexiconBuilderTableModel(cols);
        this.addLexiconFilesToTable();
        this.table = new BTable((TableModel)new DynamicTableModel((TableModel)this.tableModel, new int[]{0, 1, 2, 3, 4}));
        this.table.setMultipleSelection(true);
        this.table.setController((TableController)new LexiconBuilderTableController());
        this.table.setHeaderRenderer((TableHeaderRenderer)new LexiconBuilderTableHeaderRenderer());
        this.table.setCellRenderer((TableCellRenderer)new LexiconBuilderCellRenderer());
        this.table.setOptionsButtonVisible(false);
        this.table.setMultipleSelection(true);
        this.buildCommand = new Command((BWidget)this, Lexicon.make((String)"devkit").module, "commands.build"){

            public CommandArtifact doInvoke() {
                BLexiconModuleBuilder.this.doBuildLexicon();
                return null;
            }
        };
        BButton buildButton = new BButton(this.buildCommand, true, true);
        BFlowPane buttonPane = new BFlowPane();
        buttonPane.setVgap(10);
        buttonPane.setAlign(BHalign.center);
        buttonPane.add(null, (BValue)buildButton);
        BEdgePane mainPane = new BEdgePane();
        mainPane.setTop((BWidget)new BBorderPane((BWidget)topPane));
        mainPane.setCenter((BWidget)this.table);
        mainPane.setBottom((BWidget)new BBorderPane((BWidget)buttonPane));
        if (this.tool.buildModuleName != null && this.tool.buildModuleName.length() > 0) {
            this.moduleField.setText(this.tool.buildModuleName);
        }
        if (this.tool.buildModuleSymbol != null && this.tool.buildModuleSymbol.length() > 0) {
            this.symbolField.setText(this.tool.buildModuleSymbol);
        }
        if (this.tool.buildModuleDescription != null && this.tool.buildModuleDescription.length() > 0) {
            this.descriptionField.setText(this.tool.buildModuleDescription);
        }
        if (this.tool.buildModuleVendor != null && this.tool.buildModuleVendor.length() > 0) {
            this.vendorField.setText(this.tool.buildModuleVendor);
        }
        if (this.tool.buildModuleVersion != null && this.tool.buildModuleVersion.length() > 0) {
            this.versionField.setText(this.tool.buildModuleVersion);
        }
        if (this.tool.buildModuleBrand != null && this.tool.buildModuleBrand.length() > 0) {
            this.brandField.setText(this.tool.buildModuleBrand);
        }
        if (this.tool.buildModuleDeleteLexiconFiles) {
            this.deleteLexiconFiles.setSelected(true);
        }
        if (this.tool.selectedSourceModuleFile != null) {
            log.fine("  Adding module-based lexicon row from " + this.tool.buildModuleName);
            this.addModuleLexicons(this.tool.selectedSourceModuleFile, false);
        }
        if (this.tool.buildModuleSelectedRows != null) {
            for (int i = 0; i < this.tool.buildModuleSelectedRows.length; ++i) {
                int selected = this.tool.buildModuleSelectedRows[i];
                if (this.tableModel.getRowCount() < selected + 1 || this.tableModel.getRowValues(selected) == null) continue;
                this.table.getSelection().select(selected);
            }
        }
        this.setContent((BWidget)mainPane);
    }

    public void doBuildLexicon() {
        if (!this.isModuleAttributeListValid()) {
            return;
        }
        if (this.selectedFilenameConflict()) {
            return;
        }
        String moduleName = this.moduleField.getText();
        boolean preexisting = this.isModuleExisting(moduleName);
        if (preexisting) {
            if (!this.isExistingModuleValid(moduleName)) {
                return;
            }
            int confirm = BDialog.confirm((BWidget)this, (String)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.confirm.overwrite.title"), (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.confirm.overwrite.message"), (int)3);
            if (confirm == 2) {
                return;
            }
        }
        try {
            int confirm;
            int count;
            byte[] data;
            Throwable throwable;
            FileInputStream fis;
            File lexiconFile;
            String relativeBuildPath = this.generateModuleFiles();
            if (relativeBuildPath.length() == 0 || this.moduleXml == null || this.manifestMf == null) {
                BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.build.empty"));
                return;
            }
            final File buildFolder = new File(Nre.getNiagaraHome(), relativeBuildPath);
            char sl = File.separatorChar;
            File zipFile = new File(NiagaraFiles.getModulesPath(), moduleName + ".jar");
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
            XWriter xwriter = new XWriter((OutputStream)zos);
            zos.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            xwriter.write(this.manifestMf);
            xwriter.flush();
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry("META-INF/module.xml"));
            xwriter.write("<?xml version='1.0'?>\n");
            this.moduleXml.write(xwriter);
            xwriter.flush();
            zos.closeEntry();
            Object[] selectedLexiconFiles = this.listSelectedFileLexicons();
            for (int i = 0; i < selectedLexiconFiles.length; ++i) {
                String[] fileElements = (String[])selectedLexiconFiles[i];
                StringBuilder filePathBuffer = new StringBuilder("lexicon").append(sl).append(fileElements[0]).append(sl).append(fileElements[1]);
                lexiconFile = new File(Nre.getNiagaraHome(), filePathBuffer.toString());
                fis = new FileInputStream(lexiconFile);
                throwable = null;
                try {
                    zos.putNextEntry(new ZipEntry(fileElements[0] + "/" + fileElements[1]));
                    data = new byte[1024];
                    while ((count = fis.read(data, 0, 1024)) != -1) {
                        zos.write(data, 0, count);
                    }
                    zos.closeEntry();
                    continue;
                }
                catch (Throwable data2) {
                    throwable = data2;
                    throw data2;
                }
                finally {
                    if (fis != null) {
                        if (throwable != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable data2) {
                                throwable.addSuppressed(data2);
                            }
                        } else {
                            fis.close();
                        }
                    }
                }
            }
            Object[] selectedLexiconModuleFiles = this.listSelectedModuleLexicons();
            for (int i = 0; i < selectedLexiconModuleFiles.length; ++i) {
                String[] fileElements = (String[])selectedLexiconModuleFiles[i];
                lexiconFile = new File(buildFolder, fileElements[2]);
                fis = new FileInputStream(lexiconFile);
                throwable = null;
                try {
                    zos.putNextEntry(new ZipEntry(fileElements[2]));
                    data = new byte[1024];
                    while ((count = fis.read(data, 0, 1024)) != -1) {
                        zos.write(data, 0, count);
                    }
                    zos.closeEntry();
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fis != null) {
                        if (throwable != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            fis.close();
                        }
                    }
                }
            }
            zos.finish();
            zos.flush();
            zos.close();
            if (this.deleteLexiconFiles.isSelected() && (confirm = BDialog.confirm((BWidget)this, (String)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.confirm.delete.title"), (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.confirm.delete.message"), (int)3)) == 1) {
                for (int i = 0; i < selectedLexiconFiles.length; ++i) {
                    String[] fileElements = (String[])selectedLexiconFiles[i];
                    StringBuilder filePathBuffer = new StringBuilder("lexicon").append(sl).append(fileElements[0]).append(sl).append(fileElements[1]);
                    final File lexiconFile2 = new File(Nre.getNiagaraHome(), filePathBuffer.toString());
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            block3: {
                                try {
                                    if (lexiconFile2.exists()) {
                                        lexiconFile2.delete();
                                    }
                                }
                                catch (Exception e) {
                                    System.out.println("FATAL: Cannot delete file: " + lexiconFile2);
                                    if (e == null) break block3;
                                    e.printStackTrace(System.out);
                                }
                            }
                            return null;
                        }
                    });
                }
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    BLexiconModuleBuilder.this.deleteTree(buildFolder);
                    return null;
                }
            });
            ((NRegistry)Sys.getRegistry()).syncModules();
            Lexicon.invalidateCache();
            Object[] sa = new Object[]{this.moduleField.getText()};
            BDialog.info((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.build.success", sa));
        }
        catch (Exception e) {
            if (e.getMessage().length() > 0) {
                Object[] sa = new Object[]{e.getMessage()};
                BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.build.errorMessage", sa));
            }
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.build.error"));
        }
        this.resetView();
    }

    private void deleteTree(File dir) {
        block5: {
            try {
                if (!dir.exists()) {
                    return;
                }
                String[] list = dir.list();
                for (int i = 0; i < list.length; ++i) {
                    String s = list[i];
                    File f = new File(dir, s);
                    if (f.isDirectory()) {
                        this.deleteTree(f);
                        continue;
                    }
                    f.delete();
                }
                dir.delete();
            }
            catch (Exception e) {
                System.out.println("FATAL: Cannot delete directory: " + dir);
                if (e == null) break block5;
                e.printStackTrace(System.out);
            }
        }
    }

    public void deactivated() {
        this.tool.buildModuleName = this.moduleField.getText();
        this.tool.buildModuleSymbol = this.symbolField.getText();
        this.tool.buildModuleDescription = this.descriptionField.getText();
        this.tool.buildModuleVendor = this.vendorField.getText();
        this.tool.buildModuleVersion = this.versionField.getText();
        this.tool.buildModuleBrand = this.brandField.getText();
        this.tool.buildModuleDeleteLexiconFiles = this.deleteLexiconFiles.isSelected();
        this.tool.buildModuleSelectedRows = this.table.getSelection().getRows();
        super.deactivated();
    }

    public void doEditModuleName() {
        if (moduleLexiconsLoaded) {
            moduleLexiconsLoaded = false;
            log.fine("  Need to remove module files because new module name is: " + this.moduleField.getText());
            this.moduleStores.clear();
            this.tableModel.removeAllRows();
            this.addLexiconFilesToTable();
        }
    }

    private void resetView() {
        this.tool.buildModuleName = "";
        this.tool.buildModuleSymbol = "";
        this.tool.buildModuleDescription = "";
        this.tool.buildModuleVendor = "";
        this.tool.buildModuleVersion = "";
        this.tool.buildModuleDeleteLexiconFiles = false;
        this.tool.buildModuleSelectedRows = new int[0];
        this.moduleField.setText("");
        this.symbolField.setText("");
        this.descriptionField.setText("");
        this.vendorField.setText("");
        this.versionField.setText("");
        this.brandField.setText("");
        this.deleteLexiconFiles.setSelected(false);
        this.moduleStores.clear();
        this.loadedLexicon = null;
        this.tableModel.removeAllRows();
        this.addLexiconFilesToTable();
    }

    private boolean selectedFilenameConflict() {
        int[] rows = this.table.getSelection().getRows();
        if (rows.length == 0) {
            return false;
        }
        HashSet<String> selectedFiles = new HashSet<String>();
        for (int i = 0; i < rows.length; ++i) {
            String lexiconPath = (String)this.tableModel.getValueAt(rows[i], 4);
            if (selectedFiles.contains(lexiconPath)) {
                BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.build.duplicate"));
                return true;
            }
            selectedFiles.add(lexiconPath);
        }
        return false;
    }

    private String generateModuleFiles() throws Exception {
        int[] rows = this.table.getSelection().getRows();
        if (rows.length == 0) {
            return "";
        }
        String tempFolder = TimeFormat.format((BAbsTime)BAbsTime.now(), (String)LMB_TEMP_FOLDER);
        char sl = File.separatorChar;
        BFileSystem fs = BFileSystem.INSTANCE;
        File moduleDir = new File(Nre.getNiagaraHome(), "lexicon" + sl + tempFolder);
        FilePath moduleHome = fs.localFileToPath(moduleDir);
        fs.makeDir(moduleHome, null);
        this.moduleXml = this.generateModuleXml();
        this.manifestMf = this.generateManifestMf();
        for (int i = 0; i < rows.length; ++i) {
            File destination;
            String source = (String)this.tableModel.getValueAt(rows[i], 1);
            String language = (String)this.tableModel.getValueAt(rows[i], 2);
            String lexiconFile = (String)this.tableModel.getValueAt(rows[i], 3);
            String lexiconPath = (String)this.tableModel.getValueAt(rows[i], 4);
            if (source.equals(LMB_SOURCE_MODULE)) {
                ZipFile moduleJar = null;
                if (this.moduleStores.isEmpty()) {
                    throw new BajaRuntimeException("Module lexicon file was not resolved");
                }
                for (File moduleStore : this.moduleStores) {
                    try {
                        moduleJar = new ZipFile(moduleStore);
                        ZipEntry zipEntry = moduleJar.getEntry(lexiconPath);
                        if (zipEntry == null) {
                            throw new BajaRuntimeException("Module does not include lexicon file " + lexiconFile);
                        }
                        Path destPath = Paths.get(moduleDir.getAbsolutePath(), zipEntry.getName());
                        if (Files.notExists(destPath.getParent(), new LinkOption[0])) {
                            Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                        }
                        if (Files.notExists(destPath, new LinkOption[0])) {
                            Files.createFile(destPath, new FileAttribute[0]);
                        }
                        File destination2 = destPath.toFile();
                        this.transferFileFromJar(moduleJar, zipEntry, destination2);
                    }
                    catch (IOException e) {
                        throw new BajaRuntimeException("Temporary lexicon file could not be created for " + lexiconPath);
                    }
                    catch (Exception e) {
                        throw new BajaRuntimeException("Module lexicon file was not resolved for " + lexiconPath);
                    }
                    finally {
                        if (moduleJar == null) continue;
                        try {
                            moduleJar.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                continue;
            }
            File languageFile = new File(moduleDir, language);
            if (!languageFile.exists()) {
                languageFile.mkdirs();
            }
            if (!(destination = new File(languageFile, lexiconFile)).exists()) {
                destination.createNewFile();
            }
            File origin = new File(Nre.getNiagaraHome(), "lexicon" + sl + language + sl + lexiconFile);
            BajaFileUtil.copyFile((File)origin, (File)destination);
        }
        return "lexicon" + sl + tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferFileFromJar(ZipFile file, ZipEntry entry, File destination) throws Exception {
        FileOutputStream out = null;
        InputStream in = null;
        try {
            int count;
            byte[] data = new byte[1024];
            out = new FileOutputStream(destination);
            in = file.getInputStream(entry);
            while ((count = in.read(data, 0, 1024)) != -1) {
                out.write(data, 0, count);
            }
            out.flush();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private XElem generateModuleXml() throws Exception {
        XElem rootElem = new XElem(LMB_SOURCE_MODULE);
        rootElem.addAttr("name", this.moduleField.getText());
        rootElem.addAttr("bajaVersion", "0");
        rootElem.addAttr("vendor", this.vendorField.getText());
        rootElem.addAttr("vendorVersion", this.versionField.getText());
        rootElem.addAttr("description", this.descriptionField.getText());
        rootElem.addAttr("preferredSymbol", this.symbolField.getText());
        rootElem.addAttr("nre", "true");
        rootElem.addAttr("installable", "true");
        rootElem.addAttr("autoload", "true");
        rootElem.addAttr("buildMillis", String.valueOf(System.currentTimeMillis()));
        rootElem.addAttr("buildHost", Sys.getHostName());
        String releaseTimestamp = LocalDate.now().toString();
        rootElem.addAttr("releaseDate", releaseTimestamp);
        rootElem.addAttr("moduleName", this.moduleField.getText());
        rootElem.addAttr("runtimeProfile", "rt");
        XElem dependElem = new XElem("dependencies");
        XElem bajaDependency = new XElem("dependency");
        bajaDependency.addAttr("name", "baja");
        bajaDependency.addAttr("vendor", "Tridium");
        bajaDependency.addAttr("vendorVersion", "4.0");
        dependElem.addContent((XContent)bajaDependency);
        rootElem.addContent((XContent)dependElem);
        rootElem.addContent((XContent)new XElem("dirs"));
        XElem defs = new XElem("defs");
        XElem def = new XElem("def");
        def.addAttr("name", this.moduleField.getText());
        def.addAttr("value", this.moduleField.getText());
        defs.addContent((XContent)def);
        rootElem.addContent((XContent)defs);
        XElem lexicons = new XElem("lexicons");
        String brandFilter = this.brandField.getText();
        if (brandFilter.length() > 0) {
            lexicons.addAttr("brand", brandFilter);
        }
        Object[] selectedLexiconFiles = this.listSelectedFileLexicons();
        for (int i = 0; i < selectedLexiconFiles.length; ++i) {
            String[] fileElements = (String[])selectedLexiconFiles[i];
            XElem lexicon = new XElem("lexicon");
            lexicon.addAttr("default", "false");
            lexicon.addAttr("resource", fileElements[2]);
            int end = fileElements[1].indexOf(".lexicon");
            String module = fileElements[1].substring(0, end);
            lexicon.addAttr(LMB_SOURCE_MODULE, module);
            lexicon.addAttr("language", fileElements[0]);
            lexicons.addContent((XContent)lexicon);
        }
        Object[] selectedLexiconModuleFiles = this.listSelectedModuleLexicons();
        for (int i = 0; i < selectedLexiconModuleFiles.length; ++i) {
            String[] fileElements = (String[])selectedLexiconModuleFiles[i];
            XElem lexicon = new XElem("lexicon");
            lexicon.addAttr("default", "false");
            lexicon.addAttr("resource", fileElements[2]);
            int end = fileElements[1].indexOf(".lexicon");
            String module = fileElements[1].substring(0, end);
            lexicon.addAttr(LMB_SOURCE_MODULE, module);
            lexicon.addAttr("language", fileElements[0]);
            lexicons.addContent((XContent)lexicon);
        }
        rootElem.addContent((XContent)lexicons);
        return rootElem;
    }

    private String generateManifestMf() throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("Manifest-Version: 1.0\n");
        buf.append("Implementation-Vendor: ").append(this.vendorField.getText()).append("\n");
        buf.append("Implementation-Version: ").append(this.versionField.getText()).append("\n");
        buf.append("Sealed: true\n");
        return buf.toString();
    }

    private boolean isModuleExisting(String moduleName) {
        File module;
        try {
            module = Nre.bootEnv.findModuleFile(moduleName, RuntimeProfile.rt.name());
        }
        catch (Exception e) {
            return false;
        }
        if (module == null) {
            return false;
        }
        return module.exists();
    }

    private boolean isExistingModuleValid(String moduleName) {
        File moduleFile = new File(NiagaraFiles.getModulesPath(), moduleName + ".jar");
        return this.isExistingModuleValid(moduleFile);
    }

    private boolean isExistingModuleValid(File moduleFile) {
        boolean valid = true;
        try (ZipFile moduleJar = new ZipFile(moduleFile);){
            ZipEntry zipEntry = moduleJar.getEntry("META-INF/module.xml");
            if (zipEntry == null) {
                zipEntry = moduleJar.getEntry("meta-inf/module.xml");
            }
            if (zipEntry == null) {
                throw new BajaRuntimeException("Module does not include manifest.");
            }
            XElem manifest = XParser.make((InputStream)moduleJar.getInputStream(zipEntry)).parse();
            XElem lexElem = manifest.elem("lexicons");
            if (lexElem != null) {
                XElem[] elems = lexElem.elems("lexicon");
                for (int i = 0; i < elems.length; ++i) {
                    if (!elems[i].getb("default", false)) continue;
                    BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleChooser.error.defaultLexicon"));
                    valid = false;
                    break;
                }
            }
            Enumeration<? extends ZipEntry> entries = moduleJar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipFile = entries.nextElement();
                if (!zipFile.getName().endsWith(".class")) continue;
                BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleChooser.error.class"));
                valid = false;
                break;
            }
        }
        catch (ModuleNotFoundException e) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleChooser.error.load"));
            valid = false;
        }
        catch (ModuleException e) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.build.module.exception"));
            valid = false;
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleChooser.error.contents"));
            valid = false;
        }
        return valid;
    }

    private boolean isModuleAttributeListValid() {
        if (!this.isFieldTextValid(this.moduleField, Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.module.label"))) {
            return false;
        }
        if (!this.isFieldTextValid(this.symbolField, Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.module.symbol"))) {
            return false;
        }
        if (!this.isFieldTextValid(this.vendorField, Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.module.vendor"))) {
            return false;
        }
        if (!this.isFieldTextValid(this.versionField, Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.module.vendorVersion"))) {
            return false;
        }
        if (this.symbolField.getText().length() > 8) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.module.error.symbol"));
            return false;
        }
        try {
            new Version(this.versionField.getText());
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.module.error.version"));
            return false;
        }
        return true;
    }

    private boolean isFieldTextValid(BTextField field, String key) {
        String s = field.getText();
        if (s == null || s.length() == 0) {
            Object[] sa = new Object[]{key};
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.module.error.general", sa));
            return false;
        }
        return true;
    }

    private Vector<String[]> listLexiconFiles() {
        String[] lexicons;
        Vector<String[]> result = new Vector<String[]>();
        File lexiconHome = new File(Nre.getNiagaraHome(), "lexicon");
        if (!lexiconHome.exists()) {
            lexiconHome.mkdir();
        }
        if ((lexicons = lexiconHome.list((dir, name) -> {
            File f = new File(dir, name);
            return f.isDirectory();
        })) == null || lexicons.length == 0) {
            return result;
        }
        for (int i = 0; i < lexicons.length; ++i) {
            File lexiconDir = new File(lexiconHome, lexicons[i]);
            String[] lexiconFiles = lexiconDir.list((dir, name) -> name.indexOf(".lexicon") >= 0);
            if (lexiconFiles == null) continue;
            for (int j = 0; j < lexiconFiles.length; ++j) {
                String[] s = new String[]{lexicons[i], lexiconFiles[j]};
                result.add(s);
            }
        }
        return result;
    }

    private Object[] listSelectedFileLexicons() {
        Vector<String[]> result = new Vector<String[]>();
        int[] rows = this.table.getSelection().getRows();
        for (int i = 0; i < rows.length; ++i) {
            String source = (String)this.tableModel.getValueAt(rows[i], 1);
            String language = (String)this.tableModel.getValueAt(rows[i], 2);
            String file = (String)this.tableModel.getValueAt(rows[i], 3);
            String path = (String)this.tableModel.getValueAt(rows[i], 4);
            if (source != LMB_SOURCE_FILE) continue;
            String[] sa = new String[]{language, file, path};
            result.add(sa);
        }
        return result.toArray();
    }

    private Object[] listSelectedModuleLexicons() {
        Vector<String[]> result = new Vector<String[]>();
        int[] rows = this.table.getSelection().getRows();
        for (int i = 0; i < rows.length; ++i) {
            String source = (String)this.tableModel.getValueAt(rows[i], 1);
            String language = (String)this.tableModel.getValueAt(rows[i], 2);
            String file = (String)this.tableModel.getValueAt(rows[i], 3);
            String path = (String)this.tableModel.getValueAt(rows[i], 4);
            if (source != LMB_SOURCE_MODULE) continue;
            String[] sa = new String[]{language, file, path};
            result.add(sa);
        }
        return result.toArray();
    }

    private Object[] listSelectedLanguages() {
        Vector<String> result = new Vector<String>();
        int[] rows = this.table.getSelection().getRows();
        for (int i = 0; i < rows.length; ++i) {
            String language = (String)this.tableModel.getValueAt(rows[i], 2);
            if (result.contains(language)) continue;
            result.add(language);
        }
        return result.toArray();
    }

    private void addLexiconFilesToTable() {
        if (this.tableModel == null) {
            return;
        }
        Vector<String[]> lexiconFiles = this.listLexiconFiles();
        Enumeration<String[]> e = lexiconFiles.elements();
        while (e.hasMoreElements()) {
            Object[] row = new String[5];
            row[0] = "";
            row[1] = LMB_SOURCE_FILE;
            String[] sa = e.nextElement();
            row[2] = sa[0];
            row[3] = sa[1];
            row[4] = sa[0] + "/" + sa[1];
            this.tableModel.addRow(row);
        }
    }

    public void doSelectModule() {
        BIFile file;
        try {
            File modules = NiagaraFiles.getModulesPath();
            file = BFileChooserDialog.chooseFile((BWidget)this, null, (String)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleName.browser.title"), (String)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleName.browser.message"), (BIFile)BFileSystem.INSTANCE.makeDir(BFileSystem.INSTANCE.localFileToPath(modules), null), (IFileFilter)MODULE_FILTER, (IFileFilter)MODULE_FILTER);
        }
        catch (IOException e) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleChooser.error.io"));
            return;
        }
        if (file == null) {
            return;
        }
        if (!(file instanceof BModuleFile)) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleChooser.error.jar"));
            return;
        }
        String moduleName = file.getFileName();
        int end = moduleName.indexOf(".jar");
        moduleName = moduleName.substring(0, end);
        FilePath fp = file.getFilePath();
        File source = BFileSystem.INSTANCE.pathToLocalFile(fp);
        if (fp.isAbsolute() && fp.getScheme().equalsIgnoreCase(LMB_SOURCE_FILE)) {
            this.loadedLexicon = source;
        }
        if (!this.isExistingModuleValid(source)) {
            return;
        }
        this.tool.selectedSourceModuleFile = source;
        this.tableModel.removeAllRows();
        this.addLexiconFilesToTable();
        this.addModuleLexicons(source, true);
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (!this.tableModel.getValueAt(i, 1).equals(LMB_SOURCE_MODULE)) continue;
            this.table.getSelection().select(i);
        }
    }

    private void addModuleLexicons(File moduleFile, boolean loadNewModule) {
        String brandPattern = "";
        try (ZipFile moduleJar = new ZipFile(moduleFile);){
            ZipEntry entry = moduleJar.getEntry("META-INF/module.xml");
            if (entry == null) {
                entry = moduleJar.getEntry("meta-inf/module.xml");
            }
            if (entry == null) {
                throw new BajaRuntimeException("Module does not include manifest.");
            }
            BufferedInputStream in = new BufferedInputStream(moduleJar.getInputStream(entry));
            XElem manifest = XParser.make((InputStream)in).parse();
            XElem lexElem = manifest.elem("lexicons");
            if (lexElem == null) {
                BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleChooser.error.emptyLexicon"));
                return;
            }
            this.moduleStores.add(moduleFile);
            brandPattern = lexElem.get("brand", "");
            if (loadNewModule) {
                this.moduleField.setText(manifest.attrValue(manifest.attrIndex("name")));
                this.descriptionField.setText(manifest.attrValue(manifest.attrIndex("description")));
                this.vendorField.setText(manifest.attrValue(manifest.attrIndex("vendor")));
                this.symbolField.setText(manifest.attrValue(manifest.attrIndex("preferredSymbol")));
                this.versionField.setText(manifest.attrValue(manifest.attrIndex("vendorVersion")));
                this.brandField.setText(brandPattern);
            }
            moduleLexiconsLoaded = true;
            Enumeration<? extends ZipEntry> entries = moduleJar.entries();
            while (entries.hasMoreElements()) {
                XElem[] lexiconElems;
                ZipEntry zipFile = entries.nextElement();
                String zipFileName = zipFile.getName();
                if (!zipFileName.endsWith(".lexicon")) continue;
                for (XElem lexicon : lexiconElems = lexElem.elems()) {
                    String language = lexicon.attrValue(lexicon.attrIndex("language"));
                    String resource = lexicon.attrValue(lexicon.attrIndex("resource"));
                    if (!resource.equals(zipFileName)) continue;
                    Object[] row = new String[]{"", LMB_SOURCE_MODULE, language, new File(zipFile.getName()).getName(), zipFileName};
                    this.tableModel.addRow(row);
                }
            }
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleChooser.error.contents"), (Throwable)e);
            return;
        }
    }

    private void addModuleLexicons(String moduleName, boolean loadNewModule) {
        try {
            File[] moduleFiles = Nre.bootEnv.findModuleFiles(moduleName);
            if (moduleFiles == null || moduleFiles.length == 0) {
                return;
            }
            for (File moduleFile : moduleFiles) {
                this.addModuleLexicons(moduleFile, loadNewModule);
            }
            this.tableModel.updateTable(true);
        }
        catch (ModuleNotFoundException e) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleChooser.error.load"));
            return;
        }
        catch (ModuleException e) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.build.module.exception"));
            return;
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)Lexicon.make((String)"devkit").getText("lexiconModuleBuilder.moduleChooser.error.contents"), (Throwable)e);
            return;
        }
    }

    public class LexiconBuilderTableHeaderRenderer
    extends TableHeaderRenderer {
        public BBrush getBackground(TableHeaderRenderer.Header header) {
            return super.getBackground(header);
        }

        protected BBrush loadBrush(String lexiconText, BBrush defaultBrush) {
            try {
                return BBrush.make((String)lexiconText);
            }
            catch (Exception e) {
                return defaultBrush;
            }
        }
    }

    public class LexiconBuilderCellRenderer
    extends TableCellRenderer {
        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return this.getBackground(cell);
        }
    }

    class LexiconBuilderTableController
    extends TableController {
        LexiconBuilderTableController() {
        }

        protected void checkSelection(BMouseEvent event, int row) {
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            super.cellReleased(event, row, column);
            if (event.getClickCount() == 2) {
                if (column != 0) {
                    String lexicon = (String)BLexiconModuleBuilder.this.tableModel.getValueAt(row, 2);
                    String module = (String)BLexiconModuleBuilder.this.tableModel.getValueAt(row, 3);
                    String path = (String)BLexiconModuleBuilder.this.tableModel.getValueAt(row, 4);
                    int end = module.indexOf(".lexicon");
                    if ((module = module.substring(0, end)) == null || lexicon == null) {
                        return;
                    }
                    BWbShell shell = BLexiconModuleBuilder.this.getWbShell();
                    BLexiconModuleBuilder.this.tool.key = null;
                    if (shell != null) {
                        BLexiconModuleBuilder.this.tool.lexiconName = lexicon;
                        BLexiconModuleBuilder.this.tool.moduleName = module;
                        BLexiconModuleBuilder.this.tool.path = path;
                        shell.hyperlink(BOrd.make((String)("view:" + BLexiconEditor.TYPE)));
                    }
                }
            } else if (event.getClickCount() == 1 && column == 0) {
                BTable table = this.getTable();
                TableSelection sel = table.getSelection();
                if (table.getMultipleSelection()) {
                    if (sel.isSelected(row)) {
                        sel.deselect(row);
                    } else {
                        sel.select(row);
                    }
                } else {
                    sel.select(row, true);
                    this.getTable().fireActionPerformed(new BWidgetEvent(2, (BWidget)this.getTable()));
                }
            }
        }

        public void focusGained(BFocusEvent event) {
            this.getTable().repaint();
        }

        protected void backgroundPressed(BMouseEvent event) {
            if (event.isPopupTrigger()) {
                this.backgroundPopup(event);
            }
        }
    }
}

