/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.util;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.Sys;

public abstract class DependencyChecker {
    private static void checkDependencies(ModuleInfo module, Set<ModuleInfo> set) {
        DependencyInfo[] dep = module.getDependencies();
        for (int i = 0; i < dep.length; ++i) {
            ModuleInfo m = dep[i].getModuleInfo();
            set.add(m);
            DependencyChecker.checkDependencies(m, set);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println();
            System.out.println("usage: DependencyChecker <moduleName>");
            return;
        }
        TreeSet<ModuleInfo> set = new TreeSet<ModuleInfo>(new Comparator<ModuleInfo>(){

            @Override
            public int compare(ModuleInfo m1, ModuleInfo m2) {
                return m1.getModulePartName().compareTo(m2.getModulePartName());
            }
        });
        for (ModuleInfo module : Sys.getRegistry().getModules(args[0])) {
            DependencyChecker.checkDependencies(module, set);
        }
        System.out.println();
        System.out.println("Dependencies for " + args[0] + ": ");
        System.out.println();
        for (ModuleInfo m : set) {
            System.out.println("    " + m.getModulePartName());
        }
    }
}

