/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.wizards;

import com.tridium.devkit.wizards.DriverWizardModel;
import com.tridium.devkit.wizards.NewDriverWizard2;
import com.tridium.devkit.wizards.NewModuleWizard;
import com.tridium.gradle.plugins.templates.GradleProjectGenerator;
import com.tridium.gradle.plugins.templates.NDriverModuleGenerator;
import com.tridium.gradle.plugins.templates.VelocityGenerator;
import com.tridium.gradle.plugins.templates.util.NDriverCommInfo;
import com.tridium.slottool.Slotomatic;
import java.security.AccessController;
import java.util.logging.ConsoleHandler;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.gx.Size;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.workbench.BWbShell;

public class NewNDriverWizard
extends DriverWizardModel {
    BWidget step3ProtocolSelection;
    BCheckBox httpCheckBox = new BCheckBox("HTTP");
    BCheckBox tcpCheckBox = new BCheckBox("TCP/IP");
    BCheckBox udpCheckBox = new BCheckBox("UDP/IP");
    BCheckBox serialCheckBox = new BCheckBox("Serial");
    BCheckBox processUnsolicited = new BCheckBox("Process unsolicited messages");
    BWidget step4Names;
    BTextField classPrefix = new BTextField("", 25);
    BTextField network = new BTextField("", 25);
    BTextField device = new BTextField("", 25);
    BTextField deviceFolder = new BTextField("", 25);
    BCheckBox customDevMgr;
    BLabel deviceManagerLabel = new BLabel("DeviceManager");
    BTextField deviceManager = new BTextField("", 25);
    BCheckBox deviceManagerDiscovery = new BCheckBox("DeviceManager supports discovery");
    BWidget step5Points;
    BCheckBox points;
    BTextField pointDeviceExt = new BTextField("", 25);
    BTextField pointFolder = new BTextField("", 25);
    BTextField proxyExt = new BTextField("", 25);
    BCheckBox customPntMgr;
    BLabel pointManagerLabel = new BLabel("PointManager");
    BTextField pointManager = new BTextField("", 25);
    BCheckBox pointManagerDiscovery = new BCheckBox("PointManager supports discovery");

    public NewNDriverWizard(BWbShell shell, NewDriverWizard2 drvWizard) {
        super(shell, drvWizard);
        this.customDevMgr = new BCheckBox((ToggleCommand)new DevMgrToggle((BWidget)shell, "Custom Device Manager"));
        this.customPntMgr = new BCheckBox((ToggleCommand)new PntMgrToggle((BWidget)shell, "Custom Point Manager"));
        this.points = new BCheckBox((ToggleCommand)new PointToggle((BWidget)shell, "Point Device Ext"));
        this.customDevMgr.setSelected(false);
        this.customPntMgr.setSelected(false);
        this.deviceManagerDiscovery.setSelected(false);
        this.pointManagerDiscovery.setSelected(true);
        this.buildModuleDetailsStep(this.getTitle(), NewDriverWizard2.lexStepXofY(2, 5));
        this.buildProtocolSelectionStep(3, 5);
        this.buildNamesStep(4, 5);
        this.buildPoints(5, 5);
    }

    private void buildProtocolSelectionStep(int tab, int maxTab) {
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), NewDriverWizard2.lexStepXofY(tab, maxTab)));
        BGridPane a = new BGridPane(1);
        a.setHalign(BHalign.left);
        a.setValign(BValign.top);
        a.add(null, (BValue)new BLabel(lex.getText("driver.selectProtocols")));
        a.add(null, (BValue)this.httpCheckBox);
        a.add(null, (BValue)this.tcpCheckBox);
        a.add(null, (BValue)this.udpCheckBox);
        a.add(null, (BValue)this.serialCheckBox);
        a.add(null, (BValue)new BLabel(" "));
        a.add(null, (BValue)this.processUnsolicited);
        edge.setCenter((BWidget)new BBorderPane((BWidget)a, 10.0, 10.0, 10.0, 10.0));
        this.step3ProtocolSelection = edge;
    }

    private void buildNamesStep(int tab, int maxTab) {
        this.classPrefix.setModel((TextModel)new MasterModel());
        BGridPane a = new BGridPane(2);
        a.setHalign(BHalign.left);
        a.setValign(BValign.top);
        a.add(null, (BValue)new BLabel("Class Prefix"));
        a.add(null, (BValue)this.classPrefix);
        a.add(null, (BValue)new BLabel("DeviceNetwork"));
        a.add(null, (BValue)this.network);
        a.add(null, (BValue)new BLabel("Device"));
        a.add(null, (BValue)this.device);
        a.add(null, (BValue)new BLabel("DeviceFolder"));
        a.add(null, (BValue)this.deviceFolder);
        a.add(null, (BValue)new BLabel(" "));
        a.add(null, (BValue)new BLabel(""));
        a.add(null, (BValue)this.customDevMgr);
        a.add(null, (BValue)new BLabel(""));
        a.add(null, (BValue)this.deviceManagerLabel);
        a.add(null, (BValue)this.deviceManager);
        a.add(null, (BValue)new BLabel(" "));
        a.add(null, (BValue)new BLabel(""));
        a.add(null, (BValue)this.deviceManagerDiscovery);
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), NewDriverWizard2.lexStepXofY(tab, maxTab)));
        edge.setCenter((BWidget)new BBorderPane((BWidget)a, 10.0, 10.0, 10.0, 10.0));
        this.step4Names = edge;
    }

    private void initTypes(String x) {
        x = TextUtil.capitalize((String)x);
        this.classPrefix.setText(x);
        this.network.setText(x + "Network");
        this.device.setText(x + "Device");
        this.deviceFolder.setText(x + "DeviceFolder");
        this.deviceManager.setText(x + "DeviceManager");
        this.pointDeviceExt.setText(x + "PointDeviceExt");
        this.pointFolder.setText(x + "PointFolder");
        this.proxyExt.setText(x + "ProxyExt");
        this.pointManager.setText(x + "PointManager");
    }

    private void buildPoints(int tab, int maxTab) {
        BGridPane a = new BGridPane(2);
        a.setHalign(BHalign.left);
        a.setValign(BValign.top);
        a.add(null, (BValue)this.points);
        a.add(null, (BValue)new BLabel(""));
        a.add(null, (BValue)new BLabel("PointDeviceExt"));
        a.add(null, (BValue)this.pointDeviceExt);
        a.add(null, (BValue)new BLabel("PointFolder"));
        a.add(null, (BValue)this.pointFolder);
        a.add(null, (BValue)new BLabel("ProxyExt"));
        a.add(null, (BValue)this.proxyExt);
        a.add(null, (BValue)new BLabel(" "));
        a.add(null, (BValue)new BLabel(""));
        a.add(null, (BValue)this.customPntMgr);
        a.add(null, (BValue)new BLabel(""));
        a.add(null, (BValue)this.pointManagerLabel);
        a.add(null, (BValue)this.pointManager);
        a.add(null, (BValue)new BLabel(" "));
        a.add(null, (BValue)new BLabel(""));
        a.add(null, (BValue)this.pointManagerDiscovery);
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), NewDriverWizard2.lexStepXofY(tab, maxTab)));
        edge.setCenter((BWidget)new BBorderPane((BWidget)a, 10.0, 10.0, 10.0, 10.0));
        this.step5Points = edge;
    }

    public String getTitle() {
        return lex.getText("ndriver.title");
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(490.0, 320.0);
    }

    public void init() {
        this.stepToTab0();
    }

    public void back() {
        switch (this.currentStep) {
            case 0: {
                this.stepToSelectStep();
                break;
            }
            case 1: {
                this.stepToTab0();
                break;
            }
            case 2: {
                this.stepToTab1();
                break;
            }
            case 3: {
                this.stepToTab2();
            }
        }
    }

    public void next() {
        switch (this.currentStep) {
            case 0: {
                this.validateModuleDetail();
                this.initTypes(this.moduleName());
                this.stepToTab1();
                break;
            }
            case 1: {
                this.stepToTab2();
                break;
            }
            case 2: {
                this.stepToTab3();
            }
        }
    }

    public boolean finish() {
        this.saveOpt();
        this.shell.enterBusy();
        try {
            this.generateFiles();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            BDialog.error((BWidget)this.shell, (String)"Error", (Object)"Cannot create new driver", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.shell.exitBusy();
        }
    }

    private void stepToTab0() {
        this.update(this.step0, this.driverWizard == null ? 2 : 3);
        this.getWizard().setNextAsDefault();
        this.moduleDir.requestFocus();
        this.currentStep = 0;
    }

    private void stepToTab1() {
        this.update(this.step3ProtocolSelection, 3);
        this.serialCheckBox.requestFocus();
        this.currentStep = 1;
    }

    private void stepToTab2() {
        this.update(this.step4Names, 3);
        this.points.requestFocus();
        this.currentStep = 2;
    }

    private void stepToTab3() {
        this.update(this.step5Points, 5);
        this.points.requestFocus();
        this.currentStep = 3;
    }

    private void generateFiles() throws Exception {
        FilePath path = new FilePath(this.moduleDir.getText());
        BFileSystem fs = BFileSystem.INSTANCE;
        fs.makeDir(path, null);
        VelocityGenerator velocityGenerator = new VelocityGenerator(fs.pathToLocalFile(path));
        GradleProjectGenerator gradleProjectGenerator = new GradleProjectGenerator(velocityGenerator);
        gradleProjectGenerator.setProjectName(this.moduleName());
        gradleProjectGenerator.setVendor(this.vendor.getText());
        gradleProjectGenerator.setCopyright(this.vendor.getText());
        gradleProjectGenerator.setVersion(this.version.getText());
        FilePath existingProperties = path.merge("gradle.properties");
        if (fs.findFile(existingProperties) == null) {
            NewModuleWizard.configureGradleProperties(gradleProjectGenerator);
        }
        NDriverModuleGenerator nDriverModuleGenerator = NDriverModuleGenerator.make(gradleProjectGenerator, this.moduleName());
        nDriverModuleGenerator.setPreferredSymbol(this.prefSymbol.getText());
        nDriverModuleGenerator.setDescription(this.moduleDescription.getText());
        nDriverModuleGenerator.setBasePackage(this.basePackage.getText());
        nDriverModuleGenerator.setClassPrefix(this.classPrefix.getText());
        nDriverModuleGenerator.setDevice(this.device.getText());
        nDriverModuleGenerator.setDeviceNetwork(this.network.getText());
        nDriverModuleGenerator.setDeviceFolder(this.deviceFolder.getText());
        nDriverModuleGenerator.setDeviceManager(this.deviceManager.getText());
        nDriverModuleGenerator.setProxyExt(this.proxyExt.getText());
        nDriverModuleGenerator.setPointManager(this.pointManager.getText());
        nDriverModuleGenerator.setPointDeviceExtension(this.pointDeviceExt.getText());
        nDriverModuleGenerator.setPointFolder(this.pointFolder.getText());
        nDriverModuleGenerator.useDeviceDiscovery(this.deviceManagerDiscovery.isSelected());
        nDriverModuleGenerator.useCustomDeviceManager(this.customDevMgr.isSelected());
        nDriverModuleGenerator.useCustomPointManager(this.customPntMgr.isSelected());
        nDriverModuleGenerator.usePointDeviceExtension(this.points.isSelected());
        nDriverModuleGenerator.usePointDiscovery(this.pointManagerDiscovery.isSelected());
        NDriverCommInfo commInfo = nDriverModuleGenerator.getCommInfo();
        commInfo.setHttp(this.httpCheckBox.isSelected());
        commInfo.setTcp(this.tcpCheckBox.isSelected());
        commInfo.setUdp(this.udpCheckBox.isSelected());
        commInfo.setSerial(this.serialCheckBox.isSelected());
        commInfo.setProcessUnsolicited(this.processUnsolicited.isSelected());
        AccessController.doPrivileged(() -> {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Slotomatic.setLogHandler(new ConsoleHandler());
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                gradleProjectGenerator.generate();
                nDriverModuleGenerator.generate();
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
            return null;
        });
        this.shell.hyperlink(BOrd.make((BOrd)fs.getNavOrd(), (OrdQuery)path));
    }

    public FilePath packageToPath(String pack, FilePath fpath) {
        return this.packageToPath(pack, fpath, false);
    }

    public FilePath packageToPath(String pack, FilePath fpath, boolean isTest) {
        FilePath p = !isTest ? fpath.merge("src") : fpath.merge("srcTest");
        String[] s = TextUtil.split((String)pack, (char)'.');
        for (int j = 0; j < s.length; ++j) {
            p = p.merge(s[j]);
        }
        return p;
    }

    class PntMgrToggle
    extends ToggleCommand {
        PntMgrToggle(BWidget owner, String label) {
            super(owner, label);
            this.setSelected(true);
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
            NewNDriverWizard.this.pointManager.setVisible(selected);
            NewNDriverWizard.this.pointManagerLabel.setVisible(selected);
            BWidget p = (BWidget)NewNDriverWizard.this.pointManager.getParent();
            if (p != null) {
                p.relayoutSync();
            }
        }
    }

    class PointToggle
    extends ToggleCommand {
        PointToggle(BWidget owner, String label) {
            super(owner, label);
            this.setSelected(true);
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
            NewNDriverWizard.this.pointDeviceExt.setEnabled(selected);
            NewNDriverWizard.this.pointFolder.setEnabled(selected);
            NewNDriverWizard.this.proxyExt.setEnabled(selected);
            NewNDriverWizard.this.pointManager.setEnabled(selected);
            NewNDriverWizard.this.customPntMgr.setEnabled(selected);
            NewNDriverWizard.this.pointManagerDiscovery.setEnabled(selected);
        }
    }

    class DevMgrToggle
    extends ToggleCommand {
        DevMgrToggle(BWidget owner, String label) {
            super(owner, label);
            this.setSelected(true);
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
            NewNDriverWizard.this.deviceManager.setVisible(selected);
            NewNDriverWizard.this.deviceManagerLabel.setVisible(selected);
            BWidget p = (BWidget)NewNDriverWizard.this.deviceManager.getParent();
            if (p != null) {
                p.relayoutSync();
            }
        }
    }

    class MasterModel
    extends TextModel {
        MasterModel() {
        }

        protected void textModified() {
            String x = TextUtil.capitalize((String)this.getText());
            NewNDriverWizard.this.network.setText(x + "Network");
            NewNDriverWizard.this.device.setText(x + "Device");
            NewNDriverWizard.this.deviceFolder.setText(x + "DeviceFolder");
            NewNDriverWizard.this.deviceManager.setText(x + "DeviceManager");
            NewNDriverWizard.this.pointDeviceExt.setText(x + "PointDeviceExt");
            NewNDriverWizard.this.pointFolder.setText(x + "PointFolder");
            NewNDriverWizard.this.proxyExt.setText(x + "ProxyExt");
            NewNDriverWizard.this.pointManager.setText(x + "PointManager");
        }
    }
}

