/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gradle.plugins.templates;

import com.tridium.gradle.plugins.templates.TemplateCopyInfo;
import com.tridium.gradle.plugins.templates.VelocityGenerator;
import java.util.HashSet;
import java.util.Set;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public abstract class Generator {
    private final Set<TemplateCopyInfo> fileCopies = new HashSet<TemplateCopyInfo>();
    private final Set<TemplateCopyInfo> templateWrites = new HashSet<TemplateCopyInfo>();
    protected final VelocityGenerator generator;
    protected final VelocityContext context;

    public Generator(VelocityGenerator generator) {
        this(generator, generator.getBaseContext());
    }

    public Generator(VelocityGenerator generator, VelocityContext parentContext) {
        this.generator = generator;
        this.context = new VelocityContext((Context)parentContext);
    }

    public Generator(Generator parent, String subdirectory) {
        this(new VelocityGenerator(parent.generator, subdirectory), parent.context);
    }

    public void addFileCopy(TemplateCopyInfo copyInfo) {
        this.fileCopies.add(copyInfo);
    }

    public void addFileCopy(String sourcePath, String destinationPath) {
        this.addFileCopy(sourcePath, destinationPath, false);
    }

    public void addFileCopy(String sourcePath, String destinationPath, boolean makeExecutable) {
        this.addFileCopy(new TemplateCopyInfo(sourcePath, destinationPath, makeExecutable));
    }

    public void addTemplateWrite(TemplateCopyInfo copyInfo) {
        this.templateWrites.add(copyInfo);
    }

    public void addTemplateWrite(String templatePath, String destinationPath) {
        this.addTemplateWrite(new TemplateCopyInfo(templatePath, destinationPath));
    }

    public VelocityContext getContext() {
        return this.context;
    }

    protected void generateFiles() {
        this.generator.copyFiles(this.fileCopies);
        this.generator.writeTemplates(this.context, this.templateWrites);
    }
}

