/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gradle.plugins.templates;

import com.tridium.gradle.plugins.templates.Generator;
import com.tridium.gradle.plugins.templates.VelocityGenerator;
import java.io.File;
import java.util.Objects;

public class GradleProjectGenerator
extends Generator {
    private String vendor;

    public GradleProjectGenerator(VelocityGenerator generator) {
        super(generator);
        this.context.put("includePath", (Object)"gradle/includes/niagara");
        this.addTemplateWrite("gradle/settings.gradle.kts.vm", "settings.gradle.kts");
        this.addTemplateWrite("gradle/build.gradle.kts.vm", "build.gradle.kts");
        this.addFileCopy("gradle/gradlew", "gradlew", true);
        this.addFileCopy("gradle/gradlew.bat", "gradlew.bat");
        this.addFileCopy("gradle/gradle/wrapper/gradle-wrapper.jar", "gradle/wrapper/gradle-wrapper.jar");
        this.addFileCopy("gradle/gradle/wrapper/gradle-wrapper.properties", "gradle/wrapper/gradle-wrapper.properties");
    }

    public void setProjectName(String projectName) {
        this.context.put("projectName", (Object)projectName);
    }

    public void setCopyright(String copyright) {
        this.context.put("copyright", (Object)copyright);
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = Objects.requireNonNull(vendor);
        this.context.put("vendor", (Object)this.vendor);
    }

    public void setVersion(String version) {
        this.context.put("version", (Object)Objects.requireNonNull(version));
    }

    public void setIncludePath(String includePath) {
        this.context.put("includePath", (Object)includePath);
    }

    public void generate() {
        if (this.context.get("vendor") == null) {
            throw new IllegalArgumentException("vendor must not be null");
        }
        if (!new File(this.generator.getBaseDirectory(), "settings.gradle.kts").exists()) {
            this.generateFiles();
        }
    }
}

