/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gradle.plugins.templates;

import java.util.Objects;

public class ModuleDependency
implements Comparable<ModuleDependency> {
    public static final ModuleDependency NRE = new ModuleDependency("", "nre");
    public static final ModuleDependency BAJA = new ModuleDependency("", "baja");
    public static final ModuleDependency TEST_WB = new ModuleDependency("", "test-wb");
    private final String vendor;
    private final String module;
    private final String version;

    public ModuleDependency(String vendor, String module) {
        this(vendor, module, null);
    }

    public ModuleDependency(String vendor, String module, String version) {
        this.vendor = vendor;
        this.module = module;
        this.version = version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getModule() {
        return this.module;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleDependency that = (ModuleDependency)o;
        return this.vendor.equals(that.vendor) && this.module.equals(that.module) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.vendor, this.module, this.version);
    }

    public String toString() {
        return this.vendor + ":" + this.module + (this.version == null ? "" : ":" + this.version);
    }

    @Override
    public int compareTo(ModuleDependency o) {
        int vendorCompare = this.vendor.compareTo(o.vendor);
        if (vendorCompare == 0) {
            int moduleCompare = this.module.compareTo(o.module);
            if (moduleCompare == 0) {
                if (this.version != null && o.version != null) {
                    return this.version.compareTo(o.version);
                }
                if (this.version == null && o.version == null) {
                    return 0;
                }
                if (this.version == null) {
                    return -1;
                }
                return 1;
            }
            return moduleCompare;
        }
        return vendorCompare;
    }
}

