/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gradle.plugins.templates.util;

public final class GeneratorUtils {
    private GeneratorUtils() {
    }

    public static boolean isValidJavaPackage(String str) {
        if (str == null || str.length() == 0 || str.trim().length() == 0) {
            return false;
        }
        if (str.endsWith(".")) {
            return false;
        }
        for (String pkg : str.split("\\.")) {
            if (GeneratorUtils.isValidJavaIdentifier(pkg)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaIdentifier(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(str.codePointAt(0))) {
            return false;
        }
        return !str.codePoints().anyMatch(it -> !Character.isJavaIdentifierPart(it));
    }

    public static String escapeJava(String str) {
        int[] points = new int[str.length() * 2];
        int destIndex = 0;
        for (int srcIndex = 0; srcIndex < str.length(); ++srcIndex) {
            int point = str.codePointAt(srcIndex);
            int escapePoint = GeneratorUtils.getEscapePoint(point);
            if (escapePoint >= 0) {
                points[destIndex++] = 92;
                point = escapePoint;
            }
            points[destIndex++] = point;
        }
        return new String(points, 0, destIndex);
    }

    private static int getEscapePoint(int point) {
        int escapePoint = -1;
        switch (point) {
            case 34: 
            case 92: {
                escapePoint = point;
                break;
            }
            case 10: {
                escapePoint = 110;
                break;
            }
            case 13: {
                escapePoint = 114;
                break;
            }
            case 8: {
                escapePoint = 98;
                break;
            }
            case 9: {
                escapePoint = 116;
                break;
            }
            case 12: {
                escapePoint = 102;
            }
        }
        return escapePoint;
    }
}

