/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool;

import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.tridium.slottool.JavaUnit;
import com.tridium.slottool.SlotomaticOptions;
import com.tridium.slottool.SourceTransformer;
import com.tridium.slottool.generator.AnnotationGenerator;
import com.tridium.slottool.generator.CodeBlock;
import com.tridium.slottool.generator.ExistingCodeBlock;
import com.tridium.slottool.generator.GeneratedCodeBlock;
import com.tridium.slottool.generator.LineRange;
import com.tridium.slottool.model.BajaUnit;
import com.tridium.slottool.model.EmptyBajaUnit;
import com.tridium.slottool.model.NiagaraType;
import com.tridium.slottool.model.annotation.AnnotationProcessor;
import com.tridium.slottool.util.JavaParserUtil;
import java.util.Optional;

public class AnnotationTransformer
extends SourceTransformer {
    protected final NiagaraType niagaraType;

    public AnnotationTransformer(SlotomaticOptions slotomaticOptions, JavaUnit javaUnit, NiagaraType niagaraType) {
        super(slotomaticOptions, javaUnit);
        this.niagaraType = niagaraType;
    }

    @Override
    protected void doTransform() {
        BajaUnit bajaUnit = this.javaUnit.getBajaUnit();
        if (bajaUnit instanceof EmptyBajaUnit) {
            throw new IllegalStateException("Cannot transform a class with no metadata");
        }
        if (!this.javaUnit.hasNiagaraAnnotation("NiagaraType")) {
            bajaUnit.setNiagaraType(this.niagaraType);
        }
        AnnotationGenerator gen = new AnnotationGenerator(this.slotomaticOptions, bajaUnit);
        GeneratedCodeBlock cb = gen.getGeneratedBlock();
        if (this.javaUnit.hasBajaCode()) {
            cb.setStartLine(this.javaUnit.getAnnotationInsertionLine());
            this.javaUnit.getBajaCommentBlock().ifPresent(this.javaSource::addDeletion);
        } else if (this.javaUnit.hasNiagaraAnnotation("NiagaraSlots")) {
            CodeBlock niagaraSlots = this.javaUnit.getNiagaraSlotsBlock().orElseThrow(() -> new IllegalStateException("JavaUnit has NiagaraSlots annotation but no block for it"));
            cb.setStartLine(niagaraSlots.getRange().getStart());
            cb.trim();
            this.javaSource.addDeletion(niagaraSlots);
            for (AnnotationExpr a : this.javaUnit.getNiagaraAnnotations("NiagaraType")) {
                this.deleteAnnotation(a, false);
            }
            if (this.slotomaticOptions.isSortImports()) {
                this.javaUnit.getSortedImports().ifPresent(it -> it.deleteImport("javax.baja.nre.annotations.NiagaraSlots"));
            }
        } else if (this.slotomaticOptions.forceRecompile()) {
            cb.setStartLine(this.javaUnit.getAnnotationInsertionLine());
            for (AnnotationExpr a : this.javaUnit.getNiagaraAnnotations()) {
                this.deleteAnnotation(a, true);
            }
        } else {
            throw new IllegalStateException("Trying to add annotations to an up-to-date file!");
        }
        this.javaSource.addInsertion(cb);
        this.insertImports(cb);
    }

    protected void deleteAnnotation(AnnotationExpr a, boolean deleteComment) {
        String annotationName = AnnotationProcessor.getAnnotationName(a.getName());
        if ("NoSlotomatic".equals(annotationName)) {
            return;
        }
        this.javaSource.addDeletion(this.javaUnit.getSourceBlock(JavaParserUtil.getRange(a)));
        if (deleteComment) {
            Optional<Comment> associatedComment = a.getComment();
            associatedComment.ifPresent(comment -> {
                LineRange commentRange = JavaParserUtil.getRange(comment);
                ExistingCodeBlock ecb = this.javaUnit.getSourceBlock(commentRange);
                this.javaSource.addDeletion(ecb);
            });
        }
    }
}

