/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool;

import com.tridium.slottool.AnnotationTransformer;
import com.tridium.slottool.JavaUnit;
import com.tridium.slottool.SlotomaticOptions;
import com.tridium.slottool.generator.AnnotationGenerator;
import com.tridium.slottool.generator.CodeBlock;
import com.tridium.slottool.generator.GeneratedCodeBlock;
import com.tridium.slottool.model.BajaUnit;
import com.tridium.slottool.model.EmptyBajaUnit;
import com.tridium.slottool.model.NiagaraType;

public class ImportTransformer
extends AnnotationTransformer {
    public ImportTransformer(SlotomaticOptions slotomaticOptions, JavaUnit javaUnit, NiagaraType niagaraType) {
        super(slotomaticOptions, javaUnit, niagaraType);
    }

    @Override
    protected void doTransform() {
        BajaUnit bajaUnit = this.javaUnit.getBajaUnit();
        if (!(bajaUnit instanceof EmptyBajaUnit)) {
            throw new IllegalStateException("Trying to import a file that already has slot code");
        }
        bajaUnit.setNiagaraType(this.niagaraType);
        AnnotationGenerator gen = new AnnotationGenerator(this.slotomaticOptions, bajaUnit);
        GeneratedCodeBlock cb = gen.getGeneratedBlock();
        cb.setStartLine(this.javaUnit.getAnnotationInsertionLine());
        this.javaSource.addInsertion(cb);
        this.javaUnit.getMethod("getType").ifPresent(it -> this.javaSource.addDeletion((CodeBlock)it));
        this.javaUnit.getField("TYPE").ifPresent(it -> this.javaSource.addDeletion((CodeBlock)it));
        this.insertImports(cb);
    }
}

