/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool;

import com.tridium.slottool.Constants;
import com.tridium.slottool.Slotomatic;
import com.tridium.slottool.generator.CodeBlock;
import com.tridium.slottool.generator.LineRange;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaSource {
    private final String lineSeparator;
    private final List<String> sourceLines;
    private final List<CodeBlock> deletions = new LinkedList<CodeBlock>();
    private final List<CodeBlock> insertions = new LinkedList<CodeBlock>();
    protected final Logger log = Slotomatic.getLogger();

    public JavaSource(String source, String lineSeparator) {
        this.lineSeparator = lineSeparator;
        this.sourceLines = Arrays.asList(Constants.EOL.split(source));
    }

    public String render() {
        String suffix = "";
        if (!this.sourceLines.get(this.sourceLines.size() - 1).endsWith(this.lineSeparator)) {
            suffix = this.lineSeparator;
        }
        LinkedList<String> sourceWithDeletions = new LinkedList<String>(this.sourceLines);
        this.deletions.sort(Comparator.comparingInt(it -> it.getRange().getStartIndex()));
        this.insertions.sort(Comparator.comparingInt(it -> it.getRange().getStartIndex()));
        for (CodeBlock deletion : this.deletions) {
            LineRange range = deletion.getRange();
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "Deleting " + range);
            }
            for (int line = range.getStartIndex(); line <= range.getEndIndex(); ++line) {
                sourceWithDeletions.set(line, null);
            }
        }
        StringJoiner joiner = new StringJoiner(this.lineSeparator, "", suffix);
        int line = 0;
        for (CodeBlock insertion : this.insertions) {
            LineRange range = insertion.getRange();
            sourceWithDeletions.subList(line, range.getStartIndex()).stream().filter(Objects::nonNull).forEach(joiner::add);
            insertion.getLines().forEach(joiner::add);
            for (line = range.getStartIndex(); sourceWithDeletions.get(line) == null && line < sourceWithDeletions.size(); ++line) {
            }
        }
        if (line < sourceWithDeletions.size()) {
            sourceWithDeletions.subList(line, sourceWithDeletions.size()).stream().filter(Objects::nonNull).forEach(joiner::add);
        }
        return joiner.toString();
    }

    public void addInsertion(CodeBlock insertion) {
        this.insertions.add(insertion);
    }

    public void addDeletion(CodeBlock deletion) {
        this.deletions.add(deletion);
    }
}

