/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.mode;

import com.tridium.slottool.generator.GeneratedCodeBlock;
import com.tridium.slottool.model.Action;
import com.tridium.slottool.model.BajaUnit;
import com.tridium.slottool.model.Property;
import com.tridium.slottool.model.Topic;
import com.tridium.slottool.processor.ActionProcessor;
import com.tridium.slottool.processor.EnumProcessor;
import com.tridium.slottool.processor.PropertyProcessor;
import com.tridium.slottool.processor.SlotProcessor;
import com.tridium.slottool.processor.TopicProcessor;
import java.util.LinkedList;

public class SlotMode {
    protected final GeneratedCodeBlock cg;
    protected final BajaUnit bajaUnit;
    protected final LinkedList<SlotProcessor<Property>> propertyProcessors = new LinkedList();
    protected final LinkedList<SlotProcessor<Action>> actionProcessors = new LinkedList();
    protected final LinkedList<SlotProcessor<Topic>> topicProcessors = new LinkedList();

    public SlotMode(GeneratedCodeBlock cg, BajaUnit bajaUnit) {
        this.cg = cg;
        this.bajaUnit = bajaUnit;
        this.propertyProcessors.addFirst(new PropertyProcessor(cg));
        this.actionProcessors.addFirst(new ActionProcessor(cg));
        this.topicProcessors.addFirst(new TopicProcessor(cg));
    }

    public String getType() {
        return "TYPE";
    }

    public void header() {
    }

    public void propertyBlock() {
        this.bajaUnit.getProperties().forEach(property -> this.propertyProcessors.forEach(processor -> processor.accept(property)));
    }

    public void actionBlock() {
        this.bajaUnit.getActions().forEach(action -> this.actionProcessors.forEach(processor -> processor.accept(action)));
    }

    public void topicBlock() {
        this.bajaUnit.getTopics().forEach(topic -> this.topicProcessors.forEach(processor -> processor.accept(topic)));
    }

    public void enumBlock() {
        if (this.bajaUnit.isEnum()) {
            new EnumProcessor(this.cg, this.bajaUnit.getName()).accept(this.bajaUnit.getRange(), this.bajaUnit.getEnumDefault());
        }
    }

    public void singleton() {
        if (this.bajaUnit.isSingleton()) {
            this.cg.println();
            this.cg.println("public static final " + this.bajaUnit.getName() + " INSTANCE = new " + this.bajaUnit.getName() + "();");
        }
    }

    public void typeDeclaration() {
        this.cg.addImport("javax.baja.sys.Sys");
        this.cg.addImport("javax.baja.sys.Type");
        this.cg.startRegion("Type");
        if (this.bajaUnit.isInterface()) {
            this.cg.println();
            this.cg.println("Type TYPE = Sys.loadType(" + this.bajaUnit.getName() + ".class);");
        } else {
            this.cg.println();
            this.cg.println("@Override");
            this.cg.println("public Type getType() { return " + this.getType() + "; }");
            this.cg.println("public static final Type TYPE = Sys.loadType(" + this.bajaUnit.getName() + ".class);");
        }
        this.cg.endRegion();
    }

    public void footer() {
    }
}

