/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.model.annotation.processors;

import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.tridium.slottool.Slotomatic;
import com.tridium.slottool.SlotomaticOptions;
import com.tridium.slottool.model.annotation.AnnotationClass;
import com.tridium.slottool.model.annotation.AnnotationProcessor;
import com.tridium.slottool.model.annotation.processors.NiagaraActionProcessor;
import com.tridium.slottool.model.annotation.processors.NiagaraPropertyProcessor;
import com.tridium.slottool.model.annotation.processors.NiagaraTopicProcessor;
import java.util.logging.Logger;

public class NiagaraSlotsProcessor
extends AnnotationProcessor {
    private final Logger log = Slotomatic.getLogger();

    public NiagaraSlotsProcessor(SlotomaticOptions slotomaticOptions, AnnotationClass unit, String source) {
        super(slotomaticOptions, unit, source);
    }

    @Override
    public String getAnnotationName() {
        return "NiagaraSlots";
    }

    @Override
    public void accept(AnnotationExpr annotation) {
        if (!annotation.isNormalAnnotationExpr()) {
            return;
        }
        this.log.warning("@NiagaraSlots annotation is deprecated. Use multiple annotation support instead");
        NormalAnnotationExpr expr = annotation.asNormalAnnotationExpr();
        AnnotationProcessor.AnnotationAttributes attributes = new AnnotationProcessor.AnnotationAttributes(expr);
        this.processAnnotations(attributes, "properties", new NiagaraPropertyProcessor(this.slotomaticOptions, this.unit, this.source));
        this.processAnnotations(attributes, "actions", new NiagaraActionProcessor(this.slotomaticOptions, this.unit, this.source));
        this.processAnnotations(attributes, "topics", new NiagaraTopicProcessor(this.slotomaticOptions, this.unit, this.source));
    }

    private void processAnnotations(AnnotationProcessor.AnnotationAttributes attributes, String attributeName, AnnotationProcessor processor) {
        attributes.getAndMap(attributeName, AnnotationProcessor::getChildrenAnnotations).ifPresent(p -> p.forEach(processor));
    }
}

