/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.model.comment.parsers.baja;

import com.tridium.slottool.model.comment.parsers.baja.AstIdentifier;
import com.tridium.slottool.model.comment.parsers.baja.AstJavaExpression;
import com.tridium.slottool.model.comment.parsers.baja.BajaParser;
import com.tridium.slottool.model.comment.parsers.baja.SimpleNode;

public class AstFlags
extends SimpleNode {
    private String flags;

    public AstFlags(int id) {
        super(id);
    }

    public AstFlags(BajaParser p, int id) {
        super(p, id);
    }

    public String getFlags() {
        if (this.flags == null) {
            if (this.size() == 0) {
                this.flags = "0";
            } else {
                StringBuffer sb = new StringBuffer();
                if (this.size() > 0) {
                    if (this.get(0) instanceof AstIdentifier) {
                        for (int i = 0; i < this.size(); ++i) {
                            if (i > 0) {
                                sb.append('|');
                            }
                            String f = ((AstIdentifier)this.get(i)).getName();
                            sb.append("Flags.").append(AstFlags.toFlagName(f));
                        }
                        this.flags = sb.toString();
                    } else if (this.get(0) instanceof AstJavaExpression) {
                        this.flags = ((AstJavaExpression)this.get(0)).toString();
                    }
                }
            }
        }
        return this.flags;
    }

    private static String toFlagName(String fullName) {
        String name;
        StringBuffer buf = new StringBuffer();
        int dotIndex = fullName.indexOf(".");
        if (dotIndex > -1) {
            buf.append(fullName.substring(0, dotIndex));
            name = fullName.substring(dotIndex);
        } else {
            name = fullName;
        }
        int len = name.length();
        char last = '\uffff';
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (Character.isLetter(ch)) {
                if (Character.isLowerCase(ch)) {
                    buf.append(Character.toUpperCase(ch));
                } else {
                    if (last != '_' && Character.isLowerCase(last)) {
                        buf.append('_');
                    }
                    buf.append(ch);
                }
            } else if (Character.isDigit(ch)) {
                if (last != '_' && !Character.isDigit(last) && Character.isLowerCase(last)) {
                    buf.append('_');
                }
                buf.append(ch);
            } else {
                buf.append(ch);
            }
            last = ch;
        }
        return buf.toString();
    }
}

