/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.model.comment.parsers.baja;

import com.tridium.slottool.model.comment.parsers.baja.AstBajaType;
import com.tridium.slottool.model.comment.parsers.baja.AstDefault;
import com.tridium.slottool.model.comment.parsers.baja.AstFlags;
import com.tridium.slottool.model.comment.parsers.baja.AstIdentifier;
import com.tridium.slottool.model.comment.parsers.baja.AstJavaExpression;
import com.tridium.slottool.model.comment.parsers.baja.AstSlotFacets;
import com.tridium.slottool.model.comment.parsers.baja.BajaParser;
import com.tridium.slottool.model.comment.parsers.baja.SimpleNode;
import com.tridium.slottool.model.comment.parsers.baja.Token;

public abstract class SlotNode
extends SimpleNode {
    private Token commentToken;
    private boolean commentsLoaded = false;
    private String comment;

    public SlotNode(int id) {
        super(id);
    }

    public SlotNode(BajaParser p, int id) {
        super(p, id);
    }

    void setCommentToken(Token commentToken) {
        this.commentToken = commentToken;
    }

    public String getName() {
        AstIdentifier id = (AstIdentifier)this.getFirstOfType(AstIdentifier.class);
        return id.getName();
    }

    public AstBajaType getType() {
        return (AstBajaType)this.getFirstOfType(AstBajaType.class);
    }

    public String getMethodizedName() {
        return new String(Character.toUpperCase(this.getName().charAt(0)) + this.getName().substring(1));
    }

    public String getComment() {
        if (!this.commentsLoaded && this.commentToken != null) {
            this.commentsLoaded = true;
            this.comment = BajaParser.getBajaComment(this.commentToken.next);
        }
        return this.comment;
    }

    public String getFacets() {
        AstSlotFacets sf = (AstSlotFacets)this.getFirstOfType(AstSlotFacets.class);
        return sf == null ? null : sf.getFacets();
    }

    public String getFlags() {
        AstFlags flags = (AstFlags)this.getFirstOfType(AstFlags.class);
        return flags == null ? "0" : flags.getFlags();
    }

    public String getDefault() {
        AstDefault deflt = (AstDefault)this.getFirstOfType(AstDefault.class);
        return deflt == null ? null : ((AstJavaExpression)deflt.child()).getExpression();
    }
}

