/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.processor;

import com.tridium.slottool.generator.CodeGenerator;
import com.tridium.slottool.generator.GeneratedCodeBlock;
import com.tridium.slottool.model.BajaType;
import com.tridium.slottool.model.Property;
import com.tridium.slottool.processor.SlotProcessor;
import java.util.Optional;

public class PropertyProcessor
extends SlotProcessor<Property> {
    public PropertyProcessor(GeneratedCodeBlock cg) {
        super(cg);
    }

    @Override
    public void accept(Property property) {
        String setImpl;
        String getImpl;
        String name = property.getName();
        String typeName = property.getTypeName();
        BajaType type = BajaType.forName(typeName);
        String defaultValue = property.getDefaultValue().orElse(null);
        String getter = "get" + CodeGenerator.getMethodizedName(name);
        String setter = "set" + CodeGenerator.getMethodizedName(name);
        String flags = property.getFlags().orElse("0");
        String facets = PropertyProcessor.processFacets(property.getFacets()).orElse("null");
        Optional<String> javaDoc = property.getJavaDoc();
        this.cg.addImport("javax.baja.sys.Property");
        if (this.shouldAddImportFor(type, defaultValue)) {
            this.cg.addImport(type.getImport());
        }
        if (property.getFlags().isPresent() && property.getFlags().get().contains("Flags")) {
            this.cg.addImport("javax.baja.sys.Flags");
        }
        if (!property.getFacets().isEmpty() && property.getFacets().stream().anyMatch(it -> it.getFacet().contains("BFacets"))) {
            this.cg.addImport("javax.baja.sys.BFacets");
        }
        this.cg.startRegion("Property \"" + name + "\"");
        switch (type) {
            case BBOOLEAN_TYPE: {
                defaultValue = defaultValue + ".as(BBoolean.class).getBoolean()";
                typeName = "boolean";
            }
            case BOOLEAN_TYPE: {
                getImpl = "{ return getBoolean(" + name + "); }";
                setImpl = "{ setBoolean(" + name + ", v, null); }";
                break;
            }
            case BINT_TYPE: {
                defaultValue = defaultValue + ".as(BInteger.class).getInt()";
                typeName = "int";
            }
            case INT_TYPE: {
                getImpl = "{ return getInt(" + name + "); }";
                setImpl = "{ setInt(" + name + ", v, null); }";
                break;
            }
            case BLONG_TYPE: {
                defaultValue = defaultValue + ".as(BLong.class).getLong()";
                typeName = "long";
            }
            case LONG_TYPE: {
                getImpl = "{ return getLong(" + name + "); }";
                setImpl = "{ setLong(" + name + ", v, null); }";
                break;
            }
            case BFLOAT_TYPE: {
                defaultValue = defaultValue + ".as(BFloat.class).getFloat()";
                typeName = "float";
            }
            case FLOAT_TYPE: {
                getImpl = "{ return getFloat(" + name + "); }";
                setImpl = "{ setFloat(" + name + ", v, null); }";
                break;
            }
            case BDOUBLE_TYPE: {
                defaultValue = defaultValue + ".as(BDouble.class).getDouble()";
                typeName = "double";
            }
            case DOUBLE_TYPE: {
                getImpl = "{ return getDouble(" + name + "); }";
                setImpl = "{ setDouble(" + name + ", v, null); }";
                break;
            }
            case BSTRING_TYPE: {
                typeName = "String";
            }
            case STRING_TYPE: {
                if ("null".equals(defaultValue)) {
                    defaultValue = "(String)null";
                }
                getImpl = "{ return getString(" + name + "); }";
                setImpl = "{ setString(" + name + ", v, null); }";
                break;
            }
            case BVALUE_TYPE: {
                getImpl = "{ return get(" + name + "); }";
                setImpl = "{ set(" + name + ", v, null); }";
                break;
            }
            default: {
                getImpl = "{ return (" + typeName + ")get(" + name + "); }";
                setImpl = "{ set(" + name + ", v, null); }";
            }
        }
        this.cg.println();
        this.cg.println("/**");
        this.cg.println(" * Slot for the {@code " + name + "} property.");
        javaDoc.ifPresent(this.cg::printJavadocComment);
        this.cg.println(" * @see #" + getter);
        this.cg.println(" * @see #" + setter);
        this.cg.println(" */");
        if (property.isDeprecated()) {
            this.cg.println("@Deprecated");
        }
        this.cg.println("public static final Property " + name + " = newProperty(" + flags + ", " + defaultValue + ", " + facets + ");");
        if (!property.isOverride()) {
            this.cg.println();
            this.cg.println("/**");
            this.cg.println(" * Get the {@code " + name + "} property.");
            javaDoc.ifPresent(this.cg::printJavadocComment);
            this.cg.println(" * @see #" + name);
            this.cg.println(" */");
            if (property.isDeprecated()) {
                this.cg.println("@Deprecated");
            }
            this.cg.println("public " + typeName + " " + getter + "() " + getImpl);
            this.cg.println();
            this.cg.println("/**");
            this.cg.println(" * Set the {@code " + name + "} property.");
            javaDoc.ifPresent(this.cg::printJavadocComment);
            this.cg.println(" * @see #" + name);
            this.cg.println(" */");
            if (property.isDeprecated()) {
                this.cg.println("@Deprecated");
            }
            this.cg.println("public void " + setter + "(" + typeName + " v) " + setImpl);
        }
        this.cg.endRegion();
    }

    private boolean shouldAddImportFor(BajaType type, String defaultValue) {
        if (!type.isBType()) {
            return false;
        }
        if (type == BajaType.BOBJECT_TYPE) {
            return false;
        }
        return type != BajaType.BSTRING_TYPE || defaultValue == null || defaultValue.contains("BString");
    }
}

