/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.export;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.export.BISnmpExportFolder;
import com.tridium.snmp.export.BSnmpExportTable;
import com.tridium.snmp.mib.table.PointContainer;
import com.tridium.snmp.mib.table.PointEntry;
import com.tridium.snmp.mib.table.PointTable;
import com.tridium.snmp.util.SnmpUtil;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
@NiagaraProperty(name="objectIdentifier", type="String", defaultValue="", flags=65)
public class BSnmpExportFolder
extends BFolder
implements BISnmpExportFolder,
PointContainer {
    @Generated
    public static final Property objectIdentifier = BSnmpExportFolder.newProperty((int)65, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSnmpExportFolder.class);
    private PointTable inputs = new PointTable();
    private PointTable outputs = new PointTable();
    private static final BIcon icon = BIcon.std((String)"pointFolder.png");

    @Override
    @Generated
    public String getObjectIdentifier() {
        return this.getString(objectIdentifier);
    }

    @Override
    @Generated
    public void setObjectIdentifier(String v) {
        this.setString(objectIdentifier, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getObjectIdentifier().length() == 0) {
            this.setObjectIdentifier(((BSnmpExportTable)this.getParent()).getNextFolderOid());
        }
        this.inputs.start();
        this.outputs.start();
        if (Sys.isStationStarted()) {
            this.getSnmpNetwork().mibChanged();
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.getSnmpNetwork().mibChanged();
    }

    public BSnmpNetwork getSnmpNetwork() {
        return (BSnmpNetwork)SnmpUtil.getParent((BComponent)this, BSnmpNetwork.TYPE);
    }

    @Override
    public BSnmpExportTable getExportTable() {
        for (BComplex p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof BSnmpExportTable)) continue;
            return (BSnmpExportTable)p;
        }
        throw new IllegalStateException();
    }

    @Override
    public void registerIoObject(PointEntry ioObj) {
        if (ioObj.isSettablePoint()) {
            this.inputs.registerIoObject(ioObj);
        } else {
            this.outputs.registerIoObject(ioObj);
        }
    }

    @Override
    public void unregisterIoObject(PointEntry ioObj) {
        this.inputs.unregisterIoObject(ioObj);
        this.outputs.unregisterIoObject(ioObj);
    }

    @Override
    public PointTable inputs() {
        return this.inputs;
    }

    @Override
    public PointTable outputs() {
        return this.outputs;
    }

    @Override
    public PointTable getTable(boolean input) {
        return input ? this.inputs : this.outputs;
    }

    public BIcon getIcon() {
        return icon;
    }
}

